/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.listeners;

import java.io.File;
import org.apache.commons.jci.listeners.NotificationListener;
import org.apache.commons.jci.monitor.FilesystemAlterationListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NotifyingListener
implements FilesystemAlterationListener {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$jci$listeners$NotifyingListener == null ? (class$org$apache$commons$jci$listeners$NotifyingListener = NotifyingListener.class$("org.apache.commons.jci.listeners.NotifyingListener")) : class$org$apache$commons$jci$listeners$NotifyingListener));
    protected final File repository;
    protected NotificationListener notificationListener;
    private final Signal notificationSignal = new Signal();
    private final Signal checkSignal = new Signal();
    static /* synthetic */ Class class$org$apache$commons$jci$listeners$NotifyingListener;

    public NotifyingListener(File pRepository) {
        this.repository = pRepository;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setNotificationListener(NotificationListener pNotificationListener) {
        this.notificationListener = pNotificationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checked(boolean pNotify) {
        Signal signal;
        if (pNotify) {
            if (this.notificationListener != null) {
                this.notificationListener.handleNotification();
            }
            signal = this.notificationSignal;
            synchronized (signal) {
                this.notificationSignal.triggered = true;
                this.notificationSignal.notifyAll();
            }
        }
        signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = true;
            this.checkSignal.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForNotification() throws Exception {
        Signal signal = this.notificationSignal;
        synchronized (signal) {
            this.notificationSignal.triggered = false;
        }
        log.debug((Object)"waiting for reload signal");
        if (!this.waitForSignal(this.notificationSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    public void waitForFirstCheck() throws Exception {
        log.debug((Object)"waiting for first signal");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCheck() throws Exception {
        Signal signal = this.checkSignal;
        synchronized (signal) {
            this.checkSignal.triggered = false;
        }
        log.debug((Object)"waiting for check signal");
        if (!this.waitForSignal(this.checkSignal, 10)) {
            throw new Exception("timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForSignal(Signal pSignal, int pSecondsTimeout) {
        int i = 0;
        while (true) {
            Signal signal = pSignal;
            synchronized (signal) {
                if (pSignal.triggered) {
                    pSignal.triggered = false;
                    break;
                }
                try {
                    pSignal.wait(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (++i > pSecondsTimeout) {
                    log.error((Object)("timeout after " + pSecondsTimeout + "s"));
                    return false;
                }
            }
        }
        log.debug((Object)"caught signal");
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void onStop();

    public abstract /* synthetic */ void onDeleteDirectory(File var1);

    public abstract /* synthetic */ void onChangeDirectory(File var1);

    public abstract /* synthetic */ void onCreateDirectory(File var1);

    public abstract /* synthetic */ void onDeleteFile(File var1);

    public abstract /* synthetic */ void onChangeFile(File var1);

    public abstract /* synthetic */ void onCreateFile(File var1);

    public abstract /* synthetic */ void onStart();

    public static final class Signal {
        public boolean triggered;
    }
}

