/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment.xml;

import java.io.InputStream;
import java.net.URL;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.xml.BeanSchemaBinding;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;

public class BeanXMLDeployer
extends AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)BeanXMLDeployer.class);
    protected SchemaBinding schemaBinding = BeanSchemaBinding.getSchemaBinding();

    public BeanXMLDeployer(Kernel kernel) throws Throwable {
        super(kernel);
    }

    public KernelDeployment deploy(URL url) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment deployment;
        boolean trace = log.isTraceEnabled();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        if (trace) {
            log.trace((Object)("Parsing " + url));
        }
        if ((deployment = (KernelDeployment)(unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller()).unmarshal(url.toString(), this.schemaBinding)) == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(url.toString());
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }

    public KernelDeployment deploy(String deploymentName, InputStream stream) throws Throwable {
        Unmarshaller unmarshaller;
        KernelDeployment deployment;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Parsing " + deploymentName));
        }
        if ((deployment = (KernelDeployment)(unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller()).unmarshal(stream, this.schemaBinding)) == null) {
            throw new RuntimeException("The deployment " + deploymentName + " is not well formed!");
        }
        deployment.setName(deploymentName);
        if (trace) {
            log.trace((Object)("Deploying " + deployment));
        }
        this.deploy(deployment);
        if (trace) {
            log.trace((Object)("Deployed " + deployment.getInstalledContexts()));
        }
        return deployment;
    }
}

