/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel;

import org.jboss.kernel.KernelPermission;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;

public class Kernel {
    public static final KernelPermission ACCESS = new KernelPermission("access");
    public static final KernelPermission CONFIGURE = new KernelPermission("configure");
    protected KernelBus bus;
    protected KernelConfig config;
    protected KernelConfigurator configurator;
    protected KernelController controller;
    protected KernelEventManager eventManager;
    protected KernelRegistry registry;

    public static void checkAccess() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ACCESS);
        }
    }

    public static void checkConfigure() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONFIGURE);
        }
    }

    public KernelBus getBus() {
        Kernel.checkAccess();
        return this.bus;
    }

    public void setBus(KernelBus bus) {
        Kernel.checkConfigure();
        this.bus = bus;
    }

    public KernelConfig getConfig() {
        Kernel.checkAccess();
        return this.config;
    }

    public void setConfig(KernelConfig config) {
        Kernel.checkConfigure();
        this.config = config;
    }

    public KernelConfigurator getConfigurator() {
        Kernel.checkAccess();
        return this.configurator;
    }

    public void setConfigurator(KernelConfigurator configurator) {
        Kernel.checkConfigure();
        this.configurator = configurator;
    }

    public KernelController getController() {
        Kernel.checkAccess();
        return this.controller;
    }

    public void setController(KernelController controller) {
        Kernel.checkConfigure();
        this.controller = controller;
    }

    public KernelEventManager getEventManager() {
        Kernel.checkAccess();
        return this.eventManager;
    }

    public void setEventManager(KernelEventManager eventManager) {
        Kernel.checkConfigure();
        this.eventManager = eventManager;
    }

    public KernelRegistry getRegistry() {
        Kernel.checkAccess();
        return this.registry;
    }

    public void setRegistry(KernelRegistry registry) {
        Kernel.checkConfigure();
        this.registry = registry;
    }
}

