/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.plugins;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.plugins.SystemDomainClassLoader;
import org.jboss.classloading.spi.ClassLoadingDomain;
import org.jboss.classloading.spi.DomainClassLoader;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;
import org.jboss.util.ClassLoading;
import org.jboss.util.CollectionsFactory;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

public class AbstractClassLoadingDomain
extends JBossObject
implements ClassLoadingDomain,
KernelRegistryPlugin {
    protected boolean java2ClassLoadingCompliance;
    protected ClassLoadingDomain parent;
    protected Map pkgToCLs = CollectionsFactory.createConcurrentReaderMap();
    protected Map cachedClasses = CollectionsFactory.createConcurrentReaderMap();
    protected Map failedClasses = CollectionsFactory.createConcurrentReaderMap();
    protected Map cachedResources = CollectionsFactory.createConcurrentReaderMap();
    protected Set failedResources = CollectionsFactory.createCopyOnWriteSet();
    protected static AbstractClassLoadingDomain root = new AbstractClassLoadingDomain(true, null);

    public AbstractClassLoadingDomain() {
        this(true, root);
    }

    public AbstractClassLoadingDomain(boolean java2ClassLoadingCompliance) {
        this(java2ClassLoadingCompliance, root);
    }

    public AbstractClassLoadingDomain(ClassLoadingDomain parent) {
        this(true, parent);
    }

    public AbstractClassLoadingDomain(boolean java2ClassLoadingCompliance, ClassLoadingDomain parent) {
        this.java2ClassLoadingCompliance = java2ClassLoadingCompliance;
        this.parent = parent;
    }

    public synchronized void addDomainClassLoader(DomainClassLoader cl) {
        boolean trace = this.log.isTraceEnabled();
        cl.setDomain(this);
        Set packages = cl.getPackages();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " adding classloader " + cl + " packages " + packages));
        }
        if (!packages.isEmpty()) {
            Iterator i = packages.iterator();
            while (i.hasNext()) {
                String pkg = (String)i.next();
                String name = pkg.replace('.', '/');
                List cls = (List)this.pkgToCLs.get(name);
                if (cls == null) {
                    cls = CollectionsFactory.createCopyOnWriteList();
                    this.pkgToCLs.put(name, cls);
                }
                cls.add(cl);
            }
        }
        this.toString = null;
        this.flushFailures();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " added classloader " + cl + " packageMap=" + this.pkgToCLs));
        }
    }

    public synchronized void removeDomainClassLoader(DomainClassLoader cl) {
        boolean trace = this.log.isTraceEnabled();
        Set packages = cl.getPackages();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " removing classloader " + cl + " packages " + packages));
        }
        if (!packages.isEmpty()) {
            Iterator i = packages.iterator();
            while (i.hasNext()) {
                String pkg = (String)i.next();
                String name = pkg.replace('.', '/');
                List cls = (List)this.pkgToCLs.get(name);
                if (cls == null) continue;
                cls.remove(cl);
                if (!cls.isEmpty()) continue;
                this.pkgToCLs.remove(name);
            }
        }
        cl.setDomain(null);
        this.toString = null;
        this.flushCache();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " removed classloader " + cl + " packageMap=" + this.pkgToCLs));
        }
    }

    public void flushCache() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.toShortString() + " flushing the cache"));
        }
        this.cachedClasses.clear();
        this.cachedResources.clear();
    }

    public void flushFailures() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.toShortString() + " flushing the failures cache"));
        }
        this.failedClasses.clear();
        this.failedResources.clear();
    }

    public KernelRegistryEntry getEntry(Object name) {
        if (!(name instanceof String)) {
            return null;
        }
        String stringName = (String)name;
        String slashName = stringName.replace('.', '/');
        List pkgs = (List)this.pkgToCLs.get(slashName);
        if (pkgs != null) {
            DomainClassLoader cl = (DomainClassLoader)pkgs.get(0);
            return new AbstractKernelRegistryEntry(name, cl.getPackage(stringName));
        }
        if (this.parent != null && this.parent instanceof KernelRegistryPlugin) {
            KernelRegistryPlugin factory = (KernelRegistryPlugin)((Object)this.parent);
            return factory.getEntry(name);
        }
        return null;
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public ClassLoadingDomain getParent() {
        return this.parent;
    }

    public synchronized Class loadClass(String name, boolean resolve, DomainClassLoader classLoader) throws ClassNotFoundException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading class " + name + " resolve=" + resolve + " classLoader=" + classLoader));
        }
        Class clazz = null;
        if (this.java2ClassLoadingCompliance && this.parent != null) {
            clazz = this.loadClassFromParent(trace, name, resolve, classLoader);
        }
        if (clazz == null) {
            this.checkLoadClassFailed(trace, name, resolve, classLoader);
        }
        if (clazz == null) {
            clazz = this.loadClassFromCache(trace, name, resolve, classLoader);
        }
        if (clazz == null) {
            clazz = this.loadClassFromClassLoaders(trace, name, resolve, classLoader);
        }
        if (clazz == null && !this.java2ClassLoadingCompliance && this.parent != null) {
            clazz = this.loadClassFromParent(trace, name, resolve, classLoader);
        }
        if (clazz == null) {
            this.loadClassFailed(trace, name, resolve, classLoader);
        }
        return clazz;
    }

    public URL loadResource(String name, DomainClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " classLoader=" + classLoader));
        }
        URL url = null;
        if (classLoader != null) {
            this.loadResourceFromClassLoader(trace, name, classLoader);
        }
        if (url == null && this.java2ClassLoadingCompliance && this.parent != null) {
            url = this.loadResourceFromParent(trace, name, classLoader);
        }
        if (url == null && this.checkLoadResourceFailed(trace, name, classLoader)) {
            return null;
        }
        if (url == null) {
            url = this.loadResourceFromCache(trace, name, classLoader);
        }
        if (url == null) {
            url = this.loadResourceFromClassLoaders(trace, name, classLoader);
        }
        if (url == null && !this.java2ClassLoadingCompliance && this.parent != null) {
            url = this.loadResourceFromParent(trace, name, classLoader);
        }
        if (url == null) {
            this.loadResourceFailed(trace, name, classLoader);
        }
        return url;
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("packages=").append(this.pkgToCLs.keySet());
        if (this.parent != null) {
            buffer.append(" parent=").append(this.parent.toShortString());
        }
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getClassShortName()).append('@');
        buffer.append(Integer.toHexString(System.identityHashCode(this)));
    }

    protected Class loadClassFromParent(boolean trace, String name, boolean resolve, DomainClassLoader classLoader) {
        try {
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loading class " + name + " from parent " + this.parent.toShortString()));
            }
            Class clazz = this.parent.loadClass(name, resolve, null);
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loaded " + clazz + " from parent " + this.parent.toShortString()));
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loading class " + name + " failed for parent " + this.parent.toShortString()));
            }
            return null;
        }
    }

    protected Class loadClassFromClassLoaders(boolean trace, String name, boolean resolve, DomainClassLoader classLoader) {
        String dotName = name.replace('.', '/');
        List classLoaders = (List)this.pkgToCLs.get(ClassLoading.getPackageName(dotName));
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading class " + name + " from classloaders " + classLoaders));
        }
        if (classLoaders == null) {
            return null;
        }
        ListIterator i = classLoaders.listIterator();
        while (i.hasNext()) {
            DomainClassLoader cl = (DomainClassLoader)i.next();
            try {
                Class clazz = cl.loadClassLocally(name, resolve);
                if (trace) {
                    this.log.trace((Object)(this.toShortString() + " loaded " + clazz + " from classloader " + cl));
                }
                this.cachedClasses.put(name, clazz);
                return clazz;
            }
            catch (ClassNotFoundException ignored) {
                if (!trace) continue;
                this.log.trace((Object)(this.toShortString() + " loading class " + name + " failed for classloader " + cl), (Throwable)ignored);
            }
        }
        return null;
    }

    protected Class loadClassFromCache(boolean trace, String name, boolean resolve, DomainClassLoader classLoader) {
        Class clazz = (Class)this.cachedClasses.get(name);
        if (trace && clazz != null) {
            this.log.trace((Object)(this.toShortString() + " loaded from cache " + clazz));
        }
        return clazz;
    }

    protected void checkLoadClassFailed(boolean trace, String name, boolean resolve, DomainClassLoader classLoader) throws ClassNotFoundException {
        ClassNotFoundException cnfe = (ClassNotFoundException)this.failedClasses.get(name);
        if (cnfe != null) {
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loading class " + name + " already failed"));
            }
            throw new ClassNotFoundException("Class " + name + " not found", cnfe);
        }
    }

    protected void loadClassFailed(boolean trace, String name, boolean resolve, DomainClassLoader classLoader) throws ClassNotFoundException {
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading class " + name + " failed"));
        }
        ClassNotFoundException cnfe = new ClassNotFoundException("Class " + name + " not found ");
        this.failedClasses.put(name, cnfe);
        throw cnfe;
    }

    protected URL loadResourceFromParent(boolean trace, String name, DomainClassLoader classLoader) {
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " from parent " + this.parent.toShortString()));
        }
        URL url = this.parent.loadResource(name, null);
        if (trace) {
            if (url != null) {
                this.log.trace((Object)(this.toShortString() + " loaded resource " + url + " from parent " + this.parent.toShortString()));
            } else {
                this.log.trace((Object)(this.toShortString() + " loading resource " + name + " failed from parent " + this.parent.toShortString()));
            }
        }
        return url;
    }

    protected URL loadResourceFromClassLoader(boolean trace, String name, DomainClassLoader classLoader) {
        URL url;
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " from classloader " + classLoader));
        }
        if ((url = classLoader.loadResourceLocally(name)) != null) {
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loaded resource " + url + " from classloader " + classLoader));
            }
            return url;
        }
        return null;
    }

    protected URL loadResourceFromClassLoaders(boolean trace, String name, DomainClassLoader classLoader) {
        List classLoaders = (List)this.pkgToCLs.get(ClassLoading.getPackageName(name));
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " from classloaders " + classLoaders));
        }
        if (classLoaders == null) {
            return null;
        }
        ListIterator i = classLoaders.listIterator();
        while (i.hasNext()) {
            DomainClassLoader cl = (DomainClassLoader)i.next();
            URL url = cl.loadResourceLocally(name);
            if (url != null) {
                if (trace) {
                    this.log.trace((Object)(this.toShortString() + " loaded resource " + url + " from classloader " + cl));
                }
                this.cachedResources.put(name, url);
                return url;
            }
            if (!trace) continue;
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " failed from classloader " + cl));
        }
        return null;
    }

    protected URL loadResourceFromCache(boolean trace, String name, DomainClassLoader classLoader) {
        URL url = (URL)this.cachedResources.get(name);
        if (trace && url != null) {
            this.log.trace((Object)(this.toShortString() + " loaded resource " + url + " from cache "));
        }
        return url;
    }

    protected boolean checkLoadResourceFailed(boolean trace, String name, DomainClassLoader classLoader) {
        if (this.failedResources.contains(name)) {
            if (trace) {
                this.log.trace((Object)(this.toShortString() + " loading resource " + name + " already failed"));
            }
            return true;
        }
        return false;
    }

    protected void loadResourceFailed(boolean trace, String name, DomainClassLoader classLoader) {
        this.failedResources.add(name);
        if (trace) {
            this.log.trace((Object)(this.toShortString() + " loading resource " + name + " failed"));
        }
    }

    static {
        SystemDomainClassLoader sdcl = new SystemDomainClassLoader();
        root.addDomainClassLoader(sdcl);
    }
}

