/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.log;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.Log4JCategoryLog;
import org.apache.commons.httpclient.log.NoOpLog;

public class LogSource {
    protected static HashMap _logs = new HashMap();
    protected static boolean _log4jIsAvailable = false;

    private LogSource() {
    }

    public static Log getInstance(String name) {
        Log log = (Log)_logs.get(name);
        if (null == log) {
            log = LogSource.makeNewLogInstance(name);
            _logs.put(name, log);
        }
        return log;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name) {
        Log log = null;
        try {
            String logclassname = System.getProperty("httpclient.log");
            Class<?> logclass = Class.forName(logclassname);
            Class[] argtypes = new Class[]{"".getClass()};
            Constructor<?> ctor = logclass.getConstructor(argtypes);
            Object[] args = new Object[]{name};
            log = (Log)ctor.newInstance(args);
        }
        catch (Exception e) {
            log = null;
        }
        if (null == log) {
            if (_log4jIsAvailable) {
                return new Log4JCategoryLog(name);
            }
            log = new NoOpLog(name);
        }
        return log;
    }

    public static void setLevel(int level) {
        Iterator it = _logs.values().iterator();
        while (it.hasNext()) {
            Log log = (Log)it.next();
            log.setLevel(level);
        }
    }

    public static Iterator getLogNames() {
        return _logs.keySet().iterator();
    }

    static {
        try {
            _log4jIsAvailable = null != Class.forName("org.apache.log4j.Category");
        }
        catch (ClassNotFoundException e) {
            _log4jIsAvailable = false;
        }
    }
}

