/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.net;

import com.pointbase.collxn.collxnIntToObjHashtable;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.file.fileTempFile;
import com.pointbase.file.fileTempFileInputStream;
import com.pointbase.jdbc.jdbcObject;
import com.pointbase.net.netBufferedInputStream;
import com.pointbase.net.netJDBCConnection;
import com.pointbase.net.netLengthedInputStream;
import com.pointbase.net.netLengthedReader;
import com.pointbase.util.utilSequenceNumber;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;

public class netJDBCPrimitives {
    protected int m_ObjId = -10;
    private static boolean m_serverShutdown = false;

    public void handleResponse(DataInputStream dataInputStream) throws SQLException, BatchUpdateException {
        try {
            boolean bl = dataInputStream.readBoolean();
            if (!bl) {
                String string = dataInputStream.readUTF();
                if (string.equalsIgnoreCase("ServerShutdown")) {
                    m_serverShutdown = true;
                }
                if (string.equalsIgnoreCase("SQLException")) {
                    String string2 = dataInputStream.readUTF();
                    String string3 = dataInputStream.readUTF();
                    int n = dataInputStream.readInt();
                    throw new SQLException(string2, string3, n);
                }
                if (string.equalsIgnoreCase("BatchUpdateException")) {
                    String string4 = dataInputStream.readUTF();
                    String string5 = dataInputStream.readUTF();
                    int n = dataInputStream.readInt();
                    int[] nArray = new int[dataInputStream.readInt()];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        nArray[n2] = dataInputStream.readInt();
                        ++n2;
                    }
                    throw new BatchUpdateException(string4, string5, n, nArray);
                }
            }
        }
        catch (IOException iOException) {
            throw new dbexcpException(2006, iOException.toString()).getSQLException();
        }
    }

    public int handleJDBCObjectResponse(DataInputStream dataInputStream) throws SQLException, BatchUpdateException {
        int n = 0;
        try {
            this.handleResponse(dataInputStream);
            boolean bl = dataInputStream.readBoolean();
            if (bl) {
                return -10;
            }
            n = dataInputStream.readInt();
        }
        catch (IOException iOException) {
            throw new dbexcpException(2006, iOException.toString()).getSQLException();
        }
        return n;
    }

    public Object handlePrimitiveResponse(DataInputStream dataInputStream) throws SQLException, BatchUpdateException {
        Object object = null;
        if (!this.isServerShutdown()) {
            try {
                this.handleResponse(dataInputStream);
                boolean bl = dataInputStream.readBoolean();
                if (bl) {
                    return null;
                }
                object = this.readObject(dataInputStream);
            }
            catch (IOException iOException) {
                throw new dbexcpException(2006, new Object[]{"handlePrimitiveResponse(...)", iOException.toString()}).getSQLException();
            }
        } else {
            throw new dbexcpException(90006).getSQLException();
        }
        return object;
    }

    public void sendServerShutdown(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeUTF("ServerShutdown");
        this.flushOutput(dataOutputStream);
    }

    public void sendError(DataOutputStream dataOutputStream, SQLException sQLException) throws IOException {
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeUTF("SQLException");
        dataOutputStream.writeUTF(sQLException.getMessage() == null ? "<Unknown SQLMessage>" : sQLException.getMessage());
        dataOutputStream.writeUTF(sQLException.getSQLState() == null ? "<Unknown SQLState>" : sQLException.getSQLState());
        dataOutputStream.writeInt(sQLException.getErrorCode());
        this.flushOutput(dataOutputStream);
    }

    public void sendError(DataOutputStream dataOutputStream, BatchUpdateException batchUpdateException) throws IOException {
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeUTF("BatchUpdateException");
        dataOutputStream.writeUTF(batchUpdateException.getMessage() == null ? "<Unknown SQLMessage>" : batchUpdateException.getMessage());
        dataOutputStream.writeUTF(batchUpdateException.getSQLState() == null ? "<Unknown SQLState>" : batchUpdateException.getSQLState());
        dataOutputStream.writeInt(batchUpdateException.getErrorCode());
        int[] nArray = batchUpdateException.getUpdateCounts();
        dataOutputStream.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            dataOutputStream.writeInt(nArray[n]);
            ++n;
        }
        this.flushOutput(dataOutputStream);
    }

    public void sendOK(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(true);
    }

    public void sendResponseNoFlush(DataOutputStream dataOutputStream, Object object, collxnIntToObjHashtable collxnIntToObjHashtable2, utilSequenceNumber utilSequenceNumber2) throws IOException {
        dataOutputStream.writeBoolean(object == null);
        if (object != null) {
            if (object instanceof Connection || object instanceof Statement || object instanceof CallableStatement || object instanceof PreparedStatement || object instanceof ResultSet || object instanceof ResultSetMetaData || object instanceof DatabaseMetaData) {
                do {
                    ((jdbcObject)object).setHashCode(utilSequenceNumber2.getNext());
                } while (collxnIntToObjHashtable2.containsKey(object.hashCode()));
                collxnIntToObjHashtable2.put(object.hashCode(), object);
                this.sendObjectId(dataOutputStream, object);
            } else {
                this.writeObject(dataOutputStream, object);
            }
        }
    }

    protected void sendResponseNoFlushString(DataOutputStream dataOutputStream, String string, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
        if (!bl) {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeUTF(string);
        }
    }

    protected void sendResponseNoFlushBoolean(DataOutputStream dataOutputStream, boolean bl, boolean bl2) throws IOException {
        dataOutputStream.writeBoolean(bl2);
        if (!bl2) {
            dataOutputStream.writeInt(4);
            dataOutputStream.writeBoolean(bl);
        }
    }

    protected void sendResponseNoFlushShort(DataOutputStream dataOutputStream, short s, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
        if (!bl) {
            dataOutputStream.writeInt(14);
            dataOutputStream.writeShort(s);
        }
    }

    protected void sendResponseNoFlushLong(DataOutputStream dataOutputStream, long l, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
        if (!bl) {
            dataOutputStream.writeInt(13);
            dataOutputStream.writeLong(l);
        }
    }

    protected void sendResponseNoFlushInt(DataOutputStream dataOutputStream, int n, boolean bl) throws IOException {
        dataOutputStream.writeBoolean(bl);
        if (!bl) {
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt(n);
        }
    }

    public void sendResponse(DataOutputStream dataOutputStream, Object object, collxnIntToObjHashtable collxnIntToObjHashtable2, utilSequenceNumber utilSequenceNumber2) throws IOException {
        this.sendResponseNoFlush(dataOutputStream, object, collxnIntToObjHashtable2, utilSequenceNumber2);
        this.flushOutput(dataOutputStream);
    }

    public void sendObjectId(DataOutputStream dataOutputStream, Object object) throws IOException {
        dataOutputStream.writeInt(object.hashCode());
    }

    public void setObjectId(int n) {
        this.m_ObjId = n;
    }

    public int getObjectId() {
        return this.m_ObjId;
    }

    public void sendMethodRequestNoFlush(netJDBCConnection netJDBCConnection2, DataOutputStream dataOutputStream, String string, Object[] objectArray) throws SQLException {
        block6: {
            try {
                if (!this.isServerShutdown()) {
                    dataOutputStream.writeInt(netJDBCConnection2.hashCode());
                    int n = this.getObjectId();
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(string);
                    if (objectArray == null) {
                        dataOutputStream.writeInt(0);
                    } else {
                        dataOutputStream.writeInt(objectArray.length);
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            this.writeObject(dataOutputStream, objectArray[n2]);
                            ++n2;
                        }
                    }
                    break block6;
                }
                throw new dbexcpException(90006).getSQLException();
            }
            catch (IOException iOException) {
                throw new dbexcpException(2006, new Object[]{"sendMethodRequestNoFlush(...)", iOException.toString()}).getSQLException();
            }
        }
    }

    public void sendMethodRequest(netJDBCConnection netJDBCConnection2, DataOutputStream dataOutputStream, String string, Object[] objectArray) throws SQLException {
        if (!this.isServerShutdown()) {
            try {
                this.sendMethodRequestNoFlush(netJDBCConnection2, dataOutputStream, string, objectArray);
                this.flushOutput(dataOutputStream);
            }
            catch (IOException iOException) {
                throw new dbexcpException(2006, new Object[]{"sendMethodRequest(...)", iOException.toString()}).getSQLException();
            }
        } else {
            throw new dbexcpException(90006).getSQLException();
        }
    }

    public void flushOutput(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.flush();
    }

    public Object readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        switch (n) {
            case -10: {
                return null;
            }
            case 1: {
                return dataInputStream.readUTF();
            }
            case 3: {
                return new Integer(dataInputStream.readInt());
            }
            case 4: {
                return new Boolean(dataInputStream.readBoolean());
            }
            case 7: {
                String string = dataInputStream.readUTF();
                return Timestamp.valueOf(string);
            }
            case 8: {
                long l = dataInputStream.readLong();
                return new Date(l);
            }
            case 9: {
                long l = dataInputStream.readLong();
                return new Time(l);
            }
            case 10: {
                return new Double(dataInputStream.readDouble());
            }
            case 11: {
                return new Float(dataInputStream.readFloat());
            }
            case 12: {
                return new BigDecimal(dataInputStream.readUTF());
            }
            case 13: {
                return new Long(dataInputStream.readLong());
            }
            case 14: {
                return new Short(dataInputStream.readShort());
            }
            case 15: {
                return new Byte(dataInputStream.readByte());
            }
            case 16: {
                SQLWarning sQLWarning = new SQLWarning(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt());
                int n2 = dataInputStream.readInt();
                int n3 = 0;
                while (n3 < n2) {
                    SQLWarning sQLWarning2 = new SQLWarning(dataInputStream.readUTF(), dataInputStream.readUTF(), dataInputStream.readInt());
                    sQLWarning.setNextWarning(sQLWarning2);
                    ++n3;
                }
                return sQLWarning;
            }
            case 2: {
                int n4 = dataInputStream.readInt();
                String[] stringArray = new String[n4];
                int n5 = 0;
                while (n5 < n4) {
                    stringArray[n5] = dataInputStream.readUTF();
                    ++n5;
                }
                return stringArray;
            }
            case 18: {
                int n6 = dataInputStream.readInt();
                int[] nArray = new int[n6];
                int n7 = 0;
                while (n7 < n6) {
                    nArray[n7] = dataInputStream.readInt();
                    ++n7;
                }
                return nArray;
            }
            case 5: {
                int n8 = dataInputStream.readInt();
                byte[] byArray = new byte[n8];
                int n9 = n8;
                while (n9 > 0) {
                    n9 -= dataInputStream.read(byArray, n8 - n9, n9);
                }
                return byArray;
            }
            case 6: {
                int n10 = dataInputStream.readInt();
                byte[] byArray = new byte[Math.min(102500, n10)];
                File file = null;
                FileOutputStream fileOutputStream = null;
                int n11 = 0;
                int n12 = 0;
                int n13 = 0;
                int n14 = 0;
                boolean bl = false;
                while ((n11 = dataInputStream.readInt()) != -10) {
                    if (n11 == -1) {
                        if (!bl || n13 <= 0) break;
                        fileOutputStream.write(byArray, 0, n13);
                        break;
                    }
                    do {
                        int n15;
                        if ((n15 = Math.min(n11, byArray.length - n13)) == 0) {
                            if (!bl) {
                                file = fileTempFile.constructFile("net");
                                fileOutputStream = new FileOutputStream(file);
                                bl = true;
                            }
                            fileOutputStream.write(byArray, 0, n13);
                            n13 = 0;
                            n15 = Math.min(n11, byArray.length - n13);
                        }
                        if ((n12 = dataInputStream.read(byArray, n13, n15)) >= 0) {
                            n14 += n12;
                        }
                        n13 += n12;
                    } while ((n11 -= n12) != 0);
                }
                if (!bl) {
                    if (n11 == -10) {
                        return new netLengthedInputStream(null, 0);
                    }
                    if (n14 == 0) {
                        return new netLengthedInputStream(new ByteArrayInputStream(byArray, 0, n13), n14);
                    }
                    return new netLengthedInputStream(new netBufferedInputStream(new ByteArrayInputStream(byArray, 0, n13), n14), n14);
                }
                if (n11 == -10) {
                    return new netLengthedInputStream(null, 0);
                }
                if (n14 == 0) {
                    return new netLengthedInputStream(new ByteArrayInputStream(byArray, 0, n13), n14);
                }
                fileTempFile fileTempFile2 = new fileTempFile(file, "rw");
                return new netLengthedInputStream(new fileTempFileInputStream(fileTempFile2), n14);
            }
            case 19: {
                int n16 = dataInputStream.readInt();
                byte[] byArray = new byte[Math.min(102500, n16 * 3)];
                File file = null;
                FileOutputStream fileOutputStream = null;
                int n17 = 0;
                int n18 = 0;
                int n19 = 0;
                int n20 = 0;
                boolean bl = false;
                while ((n17 = dataInputStream.readInt()) != -10) {
                    if (n17 == -1) {
                        if (!bl || n19 <= 0) break;
                        fileOutputStream.write(byArray, 0, n19);
                        break;
                    }
                    do {
                        int n21;
                        if ((n21 = Math.min(n17, byArray.length - n19)) == 0) {
                            if (!bl) {
                                file = fileTempFile.constructFile("net");
                                fileOutputStream = new FileOutputStream(file);
                                bl = true;
                            }
                            fileOutputStream.write(byArray, 0, n19);
                            n19 = 0;
                            n21 = Math.min(n17, byArray.length - n19);
                        }
                        if ((n18 = dataInputStream.read(byArray, n19, n21)) >= 0) {
                            n20 += n18;
                        }
                        n19 += n18;
                    } while ((n17 -= n18) != 0);
                }
                if (!bl) {
                    if (n17 == -10) {
                        return new netLengthedReader(null, 0);
                    }
                    return new netLengthedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n19), "UTF8"), n20);
                }
                if (n17 == -10) {
                    return new netLengthedReader(null, 0);
                }
                if (n20 == 0) {
                    return new netLengthedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray, 0, n19), "UTF8"), n20);
                }
                fileTempFile fileTempFile3 = new fileTempFile(file, "rw");
                return new netLengthedReader(new InputStreamReader((InputStream)new fileTempFileInputStream(fileTempFile3), "UTF8"), n20);
            }
            case 17: {
                int n22 = dataInputStream.readInt();
                byte[] byArray = new byte[n22];
                int n23 = 0;
                int n24 = n22;
                while (n23 < n22) {
                    int n25 = dataInputStream.read(byArray, n23, n24);
                    n23 += n25;
                    n24 -= n25;
                }
                Object object = null;
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return object;
            }
        }
        throw new IOException("netJDBCPrimitives.readObject(), Unrecognized object type: " + n);
    }

    public void writeObject(DataOutputStream dataOutputStream, Object object) throws IOException {
        if (object == null) {
            dataOutputStream.writeInt(-10);
        } else if (object instanceof String) {
            dataOutputStream.writeInt(1);
            dataOutputStream.writeUTF((String)object);
        } else if (object instanceof Integer) {
            dataOutputStream.writeInt(3);
            dataOutputStream.writeInt((Integer)object);
        } else if (object instanceof Boolean) {
            dataOutputStream.writeInt(4);
            dataOutputStream.writeBoolean((Boolean)object);
        } else if (object instanceof Double) {
            dataOutputStream.writeInt(10);
            dataOutputStream.writeDouble((Double)object);
        } else if (object instanceof Float) {
            dataOutputStream.writeInt(11);
            dataOutputStream.writeFloat(((Float)object).floatValue());
        } else if (object instanceof BigDecimal) {
            dataOutputStream.writeInt(12);
            dataOutputStream.writeUTF(((BigDecimal)object).toString());
        } else if (object instanceof Long) {
            dataOutputStream.writeInt(13);
            dataOutputStream.writeLong((Long)object);
        } else if (object instanceof Short) {
            dataOutputStream.writeInt(14);
            dataOutputStream.writeShort(((Short)object).shortValue());
        } else if (object instanceof Byte) {
            dataOutputStream.writeInt(15);
            dataOutputStream.writeByte(((Byte)object).byteValue());
        } else if (object instanceof SQLWarning) {
            dataOutputStream.writeInt(16);
            dataOutputStream.writeUTF(((SQLWarning)object).getMessage() == null ? "<Unknown Message>" : ((SQLWarning)object).getMessage());
            dataOutputStream.writeUTF(((SQLWarning)object).getSQLState() == null ? "<Unknown SQLState>" : ((SQLWarning)object).getSQLState());
            dataOutputStream.writeInt(((SQLWarning)object).getErrorCode());
            Vector<SQLWarning> vector = new Vector<SQLWarning>();
            SQLWarning sQLWarning = (SQLWarning)object;
            while ((sQLWarning = sQLWarning.getNextWarning()) != null) {
                vector.addElement(sQLWarning);
            }
            dataOutputStream.writeInt(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                sQLWarning = (SQLWarning)enumeration.nextElement();
                dataOutputStream.writeUTF(sQLWarning.getMessage() == null ? "<Unknown Message>" : sQLWarning.getMessage());
                dataOutputStream.writeUTF(sQLWarning.getSQLState() == null ? "<Unknown SQLState>" : sQLWarning.getSQLState());
                dataOutputStream.writeInt(sQLWarning.getErrorCode());
            }
        } else if (object instanceof Timestamp) {
            dataOutputStream.writeInt(7);
            dataOutputStream.writeUTF(((Timestamp)object).toString());
        } else if (object instanceof Date) {
            dataOutputStream.writeInt(8);
            dataOutputStream.writeLong(((Date)object).getTime());
        } else if (object instanceof Time) {
            dataOutputStream.writeInt(9);
            dataOutputStream.writeLong(((Time)object).getTime());
        } else if (object instanceof String[]) {
            dataOutputStream.writeInt(2);
            int n = ((String[])object).length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeUTF(((String[])object)[n2]);
                ++n2;
            }
        } else if (object instanceof int[]) {
            dataOutputStream.writeInt(18);
            int n = ((int[])object).length;
            dataOutputStream.writeInt(n);
            int[] nArray = (int[])object;
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeInt(nArray[n3]);
                ++n3;
            }
        } else if (object instanceof byte[]) {
            dataOutputStream.writeInt(5);
            int n = ((byte[])object).length;
            dataOutputStream.writeInt(n);
            dataOutputStream.write((byte[])object);
        } else if (object instanceof netLengthedInputStream) {
            dataOutputStream.writeInt(6);
            int n = ((netLengthedInputStream)object).getLength();
            if (n <= 0) {
                n = 102400;
            }
            InputStream inputStream = ((netLengthedInputStream)object).getInputStream();
            dataOutputStream.writeInt(n);
            byte[] byArray = new byte[Math.min(102500, n)];
            if (inputStream != null) {
                int n4;
                int n5;
                do {
                    n5 = 0;
                    n4 = 0;
                    int n6 = byArray.length;
                    while (n6 != 0) {
                        n5 = inputStream.read(byArray, n4, byArray.length - n4);
                        if (n5 == -1) break;
                        n4 += n5;
                        n6 -= n5;
                    }
                    if (n6 != 0) continue;
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray, 0, byArray.length);
                } while (n5 != -1);
                if (n4 != 0) {
                    dataOutputStream.writeInt(n4);
                    dataOutputStream.write(byArray, 0, n4);
                }
                dataOutputStream.writeInt(-1);
            } else {
                dataOutputStream.writeInt(-10);
            }
        } else if (object instanceof netLengthedReader) {
            dataOutputStream.writeInt(19);
            int n = ((netLengthedReader)object).getLength();
            if (n <= 0) {
                n = 102400;
            }
            Reader reader = ((netLengthedReader)object).getReader();
            dataOutputStream.writeInt(n);
            char[] cArray = new char[Math.min(102500, n)];
            if (reader != null) {
                byte[] byArray;
                int n7;
                int n8;
                do {
                    n8 = 0;
                    n7 = 0;
                    int n9 = cArray.length;
                    while (n9 != 0) {
                        n8 = reader.read(cArray, n7, cArray.length - n7);
                        if (n8 == -1) break;
                        n7 += n8;
                        n9 -= n8;
                    }
                    if (n9 != 0) continue;
                    byArray = new String(cArray).getBytes("UTF8");
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray, 0, byArray.length);
                } while (n8 != -1);
                if (n7 != 0) {
                    byArray = new String(cArray, 0, n7).getBytes("UTF8");
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray, 0, byArray.length);
                }
                dataOutputStream.writeInt(-1);
            } else {
                dataOutputStream.writeInt(-10);
            }
        } else if (object instanceof Serializable) {
            dataOutputStream.writeInt(17);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
        } else {
            throw new IOException("netJDBCPrimitives.writeObject(), Unrecognized object type: " + object.getClass().getName());
        }
    }

    protected boolean isServerShutdown() {
        return m_serverShutdown;
    }
}

