/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.api.apiConnection;
import com.pointbase.api.apiResultHeader;
import com.pointbase.api.apiStatement;
import com.pointbase.cache.cacheManager;
import com.pointbase.collxn.collxnIEnumerator;
import com.pointbase.collxn.collxnVector;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.dt.dtNumber;
import com.pointbase.jdbc.jdbcConnection;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcNewRowSet;
import com.pointbase.jdbc.jdbcObject;
import com.pointbase.jdbc.jdbcParser;
import com.pointbase.jdbc.jdbcResultSet;
import com.pointbase.jdbc.jdbcResultSetMetaData;
import com.pointbase.jdbc.jdbcTmpResultSet;
import com.pointbase.session.sessionManager;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;

public class jdbcStatement
extends jdbcObject
implements Statement {
    public static final int RETURN_GENERATED_KEYS = 1;
    public static final int NO_GENERATED_KEYS = 2;
    protected apiStatement m_apiStatement;
    protected apiConnection m_apiConnection;
    protected jdbcConnection m_jdbcConnection;
    protected ResultSet[] m_ResultSets = null;
    protected int m_ResultSetIndex = -1;
    protected boolean m_bClosed = false;
    protected int m_rowCount;
    protected String m_sql = null;
    protected boolean m_EscapeProcessing = true;
    protected int m_CursorType;
    protected int m_FetchSize;
    protected int m_FetchDirection;
    protected int m_max_rows = 0;
    private int m_max_field_size = 0;
    private int m_fetched_rows = 0;
    private int m_timeout = 0;
    private int m_StmtNum;
    private int m_ResultSetNum;
    private Vector m_BatchStmts;
    private static final int EX_UPDATE = 2;
    private static final int EX_QUERY = 1;
    private static final int EXECUTE = 0;

    public jdbcStatement() {
    }

    public jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this.m_rowCount = 0;
        this.m_apiStatement = null;
        this.m_apiConnection = jdbcConnection2.getApiConnection();
        this.m_CursorType = 17;
        this.m_StmtNum = n;
        this.m_rowCount = 0;
        this.m_jdbcConnection = jdbcConnection2;
        this.resetResultSetIndex();
        this.m_StmtNum = this.m_jdbcConnection.getNextStmtSeqNum();
        this.m_BatchStmts = new Vector();
        this.m_FetchSize = dbgaProperties.getPropertyFetchBlockSize();
        this.m_FetchDirection = 1;
    }

    public jdbcStatement(jdbcConnection jdbcConnection2, int n, int n2, int n3) throws SQLException {
        this(jdbcConnection2, n);
        this.m_CursorType = 0;
        try {
            switch (n2) {
                case 1003: {
                    this.m_CursorType |= 1;
                    break;
                }
                case 1004: {
                    this.m_CursorType |= 2;
                    break;
                }
                case 1005: {
                    this.m_CursorType |= 2;
                    break;
                }
                default: {
                    throw new dbexcpException(25017, new Integer(n2).toString());
                }
            }
            switch (n3) {
                case 1007: {
                    this.m_CursorType |= 0x10;
                    break;
                }
                case 1008: {
                    this.m_CursorType |= 0x20;
                    break;
                }
                default: {
                    throw new dbexcpException(25018, new Integer(n3).toString());
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public ResultSet executeQuery(String string) throws SQLException {
        this.executeQuery(string, 1, 2);
        return this.getResultSet();
    }

    private boolean executeQuery(String string, int n, int n2) throws SQLException {
        try {
            String string2;
            if (this.m_bClosed) {
                throw new dbexcpException(86005);
            }
            this.closeResultSets();
            this.m_sql = string;
            if (this.m_apiStatement != null) {
                this.m_apiStatement.releaseResources();
            } else {
                this.m_apiStatement = this.m_apiConnection.createStatement();
            }
            if (dbgaProperties.getPropertiesDebugLog()) {
                string2 = this.buildLogInfo();
                this.printDebugInfo(string2 + " execute \" " + this.m_sql + " \" ");
            }
            if (this.m_EscapeProcessing) {
                string2 = jdbcParser.parseEscapeSyntax(string);
                this.m_apiStatement.compile(string2);
            } else {
                this.m_apiStatement.compile(string);
            }
            boolean bl = this.m_apiStatement.isResultSetExist();
            switch (n) {
                case 2: {
                    if (!bl) break;
                    throw new dbexcpException(86006);
                }
                case 1: {
                    if (bl) break;
                    throw new dbexcpException(86034);
                }
            }
            this.m_apiStatement.setReturnGeneratedKeys(n2);
            this.m_apiStatement.execute(this.m_CursorType, this.m_FetchDirection == 2, this.m_max_rows);
            boolean bl2 = false;
            if (!cacheManager.getCacheManager().isShutdownCalled()) {
                bl2 = this.processResults();
            } else {
                this.m_bClosed = true;
            }
            if (!sessionManager.getSessionManager().getNewEmbeddedFlag()) {
                if (this.m_rowCount == -1000) {
                    throw new dbexcpException(90000);
                }
                if (this.m_rowCount == -1001) {
                    throw new dbexcpException(90001);
                }
            }
            return bl2;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int executeUpdate(String string) throws SQLException {
        this.executeQuery(string, 2, 2);
        return this.m_rowCount;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        this.executeQuery(string, 2, n);
        return this.m_rowCount;
    }

    public boolean execute(String string) throws SQLException {
        this.executeQuery(string, 0, 2);
        return this.getResultSet() != null;
    }

    public boolean execute(String string, int n) throws SQLException {
        this.executeQuery(string, 0, n);
        return this.getResultSet() != null;
    }

    /*
     * Unable to fully structure code
     */
    public int[] executeBatch() throws BatchUpdateException {
        block7: {
            var1_1 = null;
            var2_2 = 0;
            try {
                try {
                    var1_1 = new int[this.m_BatchStmts.size()];
                    var3_3 = this.m_BatchStmts.elements();
                    while (var3_3.hasMoreElements()) {
                        var4_6 = (String)var3_3.nextElement();
                        if (!var4_6.toUpperCase().trim().startsWith("SELECT")) {
                            var1_1[var2_2] = this.executeUpdate(var4_6);
                            ++var2_2;
                            continue;
                        }
                        throw new dbexcpException(86006);
                    }
                    break block7;
                }
                catch (dbexcpException var3_4) {
                    throw var3_4.getSQLException();
                }
            }
            catch (SQLException var3_5) {
                var4_7 = new int[var2_2];
                var5_8 = 0;
                ** while (var5_8 < var4_7.length)
            }
lbl-1000:
            // 1 sources

            {
                var4_7[var5_8] = var1_1[var5_8];
                ++var5_8;
                continue;
            }
lbl24:
            // 1 sources

            throw new BatchUpdateException(var3_5.getMessage(), var3_5.getSQLState(), var3_5.getErrorCode(), var4_7);
        }
        return var1_1;
    }

    public void close() throws SQLException {
        try {
            if (!this.m_bClosed && this.m_apiStatement != null && !this.m_apiStatement.isClosed()) {
                this.m_apiConnection.isConnectionValid();
                if (dbgaProperties.getPropertiesDebugLog()) {
                    String string = this.buildLogInfo();
                    this.printDebugInfo(string + " Close Statement. ");
                }
                this.closeResultSets();
                this.m_apiStatement.close();
                this.nullMembers();
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public ResultSet getResultSet() {
        if (this.m_ResultSets == null) {
            return null;
        }
        return this.m_ResultSets[this.m_ResultSetIndex];
    }

    public int getUpdateCount() throws SQLException {
        return this.m_rowCount;
    }

    public boolean getMoreResults() throws SQLException {
        boolean bl = false;
        if (this.m_ResultSets != null) {
            ++this.m_ResultSetIndex;
            boolean bl2 = bl = this.m_ResultSetIndex < this.m_ResultSets.length;
            if (this.m_ResultSetIndex - 1 < this.m_ResultSets.length) {
                this.m_ResultSets[this.m_ResultSetIndex - 1].close();
                this.m_apiStatement.getMoreReuslts();
            }
        }
        this.m_rowCount = -1;
        return bl;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.m_max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86033, Integer.toString(n));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        return this.m_max_rows;
    }

    public void setMaxRows(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86032, Integer.toString(n));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_max_rows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.m_EscapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this.m_timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86035, Integer.toString(n));
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_timeout = n;
    }

    public void cancel() throws SQLException {
        try {
            if (this.m_apiStatement != null) {
                this.m_apiStatement.cancel();
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public final SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public void setCursorName(String string) throws SQLException {
        try {
            throw new dbexcpException(86009, new Object[]{"setCursorName"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void addBatch(String string) throws SQLException {
        this.m_BatchStmts.addElement(string);
    }

    public void clearBatch() throws SQLException {
        this.m_BatchStmts.removeAllElements();
    }

    public Connection getConnection() throws SQLException {
        return this.m_jdbcConnection;
    }

    jdbcConnection getjdbcConnection() {
        return this.m_jdbcConnection;
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.m_ResultSets != null && this.m_ResultSetIndex >= 0) {
            return ((jdbcResultSet)this.m_ResultSets[this.m_ResultSetIndex]).getConcurrency();
        }
        switch (this.m_CursorType & 0xF0) {
            case 32: {
                return 1008;
            }
        }
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        if (this.m_ResultSets != null && this.m_ResultSetIndex >= 0) {
            return ((jdbcResultSet)this.m_ResultSets[this.m_ResultSetIndex]).getType();
        }
        switch (this.m_CursorType & 0xF) {
            case 2: {
                return 1004;
            }
            case 4: {
                return 1005;
            }
        }
        return 1003;
    }

    public int getFetchDirection() throws SQLException {
        switch (this.m_FetchDirection) {
            case 4: {
                return 1002;
            }
            case 2: {
                return 1001;
            }
        }
        return 1000;
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            switch (n) {
                case 1001: {
                    if ((this.m_CursorType & 0xF) == 1) {
                        throw new dbexcpException(25019);
                    }
                    this.m_FetchDirection = 2;
                    break;
                }
                case 1000: {
                    this.m_FetchDirection = 1;
                    break;
                }
                case 1002: {
                    this.m_FetchDirection = 4;
                    break;
                }
                default: {
                    throw new dbexcpException(25218);
                }
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        return this.m_FetchSize;
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            if (n < 0) {
                throw new dbexcpException(86031, new Object[]{new Integer(n)});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        this.m_FetchSize = n > 0 ? n : dbgaProperties.getPropertyFetchBlockSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            collxnVector collxnVector2 = this.m_apiStatement.getGeneratedKeys();
            jdbcTmpResultSet jdbcTmpResultSet2 = new jdbcTmpResultSet();
            if (collxnVector2 == null) {
                return jdbcTmpResultSet2;
            }
            collxnVector collxnVector3 = new collxnVector();
            collxnVector3.addElement(this.m_apiStatement.getIdentityColumnMD());
            jdbcTmpResultSet2.setMetaData(new jdbcResultSetMetaData(new apiResultHeader(collxnVector3)));
            collxnIEnumerator collxnIEnumerator2 = collxnVector2.elements();
            while (collxnIEnumerator2.hasMoreElements()) {
                dtNumber dtNumber2 = (dtNumber)collxnIEnumerator2.nextElement();
                Object[] objectArray = new Object[]{dtNumber2.toString()};
                jdbcTmpResultSet2.appendRow(objectArray);
            }
            return jdbcTmpResultSet2;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean getMoreResults(int n) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getMoreResults");
        return false;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("executeUpdate");
        return -1;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("executeUpdate");
        return -1;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("execute");
        return false;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("execute");
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        jdbcDatabaseMetaData.functionUnsupported("getResultSetHoldability");
        return -1;
    }

    public apiStatement getApiStatement() {
        return this.m_apiStatement;
    }

    public String getCommand() {
        return this.m_sql;
    }

    public boolean fetchBlock(collxnVector collxnVector2, collxnVector collxnVector3) throws dbexcpException {
        return this.m_apiStatement.fetchBlock(collxnVector2, collxnVector3);
    }

    public apiResultHeader[] fetchMetaDataArray() throws dbexcpException {
        return this.m_apiStatement.fetchMetaDataArray();
    }

    jdbcResultSetMetaData getJdbcResultSet() {
        return null;
    }

    int getStmtNum() {
        return this.m_StmtNum;
    }

    void rsClose(int n) throws dbexcpException {
        if (this.m_apiStatement != null) {
            this.m_apiStatement.rsClose(n);
        }
    }

    int getType() {
        return this.m_CursorType;
    }

    protected int getResultSetIndex() {
        return this.m_ResultSetIndex;
    }

    protected final boolean processResults() throws dbexcpException {
        int n = this.m_apiStatement.getResultSetCount();
        if (n == 0) {
            this.m_rowCount = this.m_apiStatement.getRowCount();
            this.m_ResultSets = null;
        } else {
            this.m_rowCount = -1;
            this.m_ResultSets = new jdbcResultSet[n];
            int n2 = 0;
            while (n2 < n) {
                Object object;
                if (this.m_apiStatement.isNewUnisyncCommand()) {
                    this.m_ResultSets[n2] = new jdbcNewRowSet(null, this, n2);
                } else {
                    if (n2 != 0 || (object = this.getResultHeader()) == null) {
                        object = this.m_apiStatement.fetchMetaData(n2);
                    }
                    this.m_ResultSets[n2] = new jdbcResultSet((apiResultHeader)object, this, n2);
                }
                if (dbgaProperties.getPropertiesDebugLog()) {
                    object = this.buildLogInfo();
                    this.printDebugInfo((String)object + " Created ResultSet Rs" + Integer.toString(this.m_ResultSetNum));
                }
                ++n2;
            }
        }
        return this.m_ResultSets != null;
    }

    protected void resetResultSetIndex() {
        this.m_ResultSetIndex = 0;
    }

    protected void addResultSet(ResultSet resultSet) {
        this.m_ResultSets[this.m_ResultSetIndex] = resultSet;
    }

    protected String buildLogInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Stmt");
        stringBuffer.append(Integer.toString(this.m_StmtNum));
        return stringBuffer.toString();
    }

    protected void closeResultSets() {
        this.m_rowCount = -1;
        try {
            if (this.m_ResultSets != null) {
                int n = 0;
                while (n < this.m_ResultSets.length) {
                    if (this.m_ResultSets[n] != null) {
                        this.m_ResultSets[n].close();
                    }
                    ++n;
                }
            }
            this.m_ResultSets = null;
            this.resetResultSetIndex();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected int getCommandType() {
        return this.m_apiStatement.getCommandId();
    }

    protected void printDebugInfo(String string) {
        sessionManager.getSessionManager().printDebugInfo(string);
    }

    protected int getNextResultSetNum() {
        return ++this.m_ResultSetNum;
    }

    protected apiResultHeader getResultHeader() throws dbexcpException {
        return null;
    }

    protected int getCursorType() {
        return this.m_apiStatement.getCursorType();
    }

    private void createRs() {
    }

    private void nullMembers() {
        this.m_bClosed = true;
        this.m_apiStatement = null;
        this.m_apiConnection = null;
        this.m_jdbcConnection = null;
        this.m_sql = null;
        this.m_ResultSets = null;
    }

    public ResultSet[] getAllResultSets() {
        return this.m_ResultSets;
    }

    protected void finalize() throws Throwable {
        if (!this.m_bClosed && this.m_apiStatement != null) {
            this.m_apiStatement.close();
            this.nullMembers();
        }
    }
}

