/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.collxn;

import com.pointbase.collxn.collxnIEnumerator;
import com.pointbase.collxn.collxnIntToObjHashtableEnum;
import com.pointbase.dbexcp.dbexcpException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;

public class collxnIntToObjHashtable {
    public static int NOT_FOUND = Integer.MAX_VALUE;
    private static int SEARCH_LIMIT = 12;
    private int[] m_HashArray = null;
    private Object[] m_ValueArray = null;
    private int m_NumberOfElements = 0;
    private int m_NumberOfPrimarySlots = 0;
    private Object m_OldValue = null;
    private int m_OverflowSize = 0;
    private int m_PrimeIndex = 0;
    private static int[] m_PrimeTable = new int[]{11, 17, 23, 31, 41, 59, 79, 107, 149, 199, 269, 359, 479, 641, 857, 1151, 1543, 2063, 2753, 3671, 4903, 6547, 8731, 11657};
    private boolean m_isRehashing = false;

    public collxnIntToObjHashtable() {
        this(11);
    }

    public collxnIntToObjHashtable(int n) {
        int n2 = 0;
        while (true) {
            if (n2 >= m_PrimeTable.length) {
                this.m_NumberOfPrimarySlots = n % 2 == 0 ? n + 1 : n;
                break;
            }
            if (m_PrimeTable[n2] >= n) {
                this.m_NumberOfPrimarySlots = m_PrimeTable[n2];
                ++n2;
                break;
            }
            ++n2;
        }
        this.m_OverflowSize = this.m_NumberOfPrimarySlots / 5;
        if (this.m_OverflowSize % 2 == 0) {
            ++this.m_OverflowSize;
        }
        int n3 = this.m_NumberOfPrimarySlots + this.m_OverflowSize;
        this.m_HashArray = new int[n3];
        this.m_ValueArray = new Object[n3];
        this.clear();
    }

    public void clear() {
        int n = 0;
        while (n < this.m_HashArray.length) {
            this.m_HashArray[n] = NOT_FOUND;
            this.m_ValueArray[n] = null;
            ++n;
        }
        this.m_NumberOfElements = 0;
    }

    public int capacity() {
        return this.m_NumberOfPrimarySlots;
    }

    public collxnIEnumerator elements() {
        return new collxnHashtableEnumerator(this.m_HashArray, this.m_ValueArray);
    }

    public Object get(int n) {
        int n2 = this.findKeyIndex(n);
        Object object = n2 == -1 ? null : this.m_ValueArray[n2];
        return object;
    }

    public Object put(int n, Object object) {
        this.put(n, object, true);
        Object object2 = this.m_OldValue;
        this.m_OldValue = null;
        return object2;
    }

    private boolean put(int n, Object object, boolean bl) {
        int n2 = this.findKeyIndex(n);
        if (n2 == -1) {
            while (this.m_HashArray[n2 = this.getHashKey(n)] != NOT_FOUND) {
                int n3 = this.getOverflowHashKey(n);
                int n4 = 0;
                while (n4 < SEARCH_LIMIT && n4 < this.m_OverflowSize && this.m_HashArray[(n3 + n4) % this.m_OverflowSize + this.m_NumberOfPrimarySlots] != NOT_FOUND) {
                    ++n4;
                }
                if (n4 < SEARCH_LIMIT && n4 < this.m_OverflowSize) {
                    n2 = (n3 + n4) % this.m_OverflowSize + this.m_NumberOfPrimarySlots;
                    break;
                }
                if (bl) {
                    this.rehash();
                    continue;
                }
                return false;
            }
        }
        this.m_OldValue = this.m_ValueArray[n2];
        if (this.m_OldValue == null) {
            ++this.m_NumberOfElements;
        }
        this.m_HashArray[n2] = n;
        this.m_ValueArray[n2] = object;
        return true;
    }

    public Object remove(int n) {
        int n2 = this.findKeyIndex(n);
        if (n2 != -1) {
            Object object = this.m_ValueArray[n2];
            this.m_HashArray[n2] = NOT_FOUND;
            this.m_ValueArray[n2] = null;
            --this.m_NumberOfElements;
            return object;
        }
        return null;
    }

    public int size() {
        return this.m_NumberOfElements;
    }

    public boolean containsKey(int n) {
        return this.findKeyIndex(n) != -1;
    }

    int[] getHashArray() {
        return this.m_HashArray;
    }

    public int getNumberOfPrimarySlots() {
        return this.m_NumberOfPrimarySlots;
    }

    int getOverflowSize() {
        return this.m_OverflowSize;
    }

    Object[] getValueArray() {
        return this.m_ValueArray;
    }

    private int findKeyIndex(int n) {
        int n2 = this.getHashKey(n);
        if (this.m_HashArray[n2] == n) {
            return n2;
        }
        int n3 = this.m_NumberOfPrimarySlots + this.m_OverflowSize;
        int n4 = this.getOverflowHashKey(n);
        int n5 = 0;
        n5 = 0;
        while (n5 < SEARCH_LIMIT) {
            int n6 = (n4 + n5) % this.m_OverflowSize + this.m_NumberOfPrimarySlots;
            if (this.m_HashArray[n6] == n) {
                return n6;
            }
            ++n5;
        }
        return -1;
    }

    private int getHashKey(int n) {
        return Math.abs(n) % this.m_NumberOfPrimarySlots;
    }

    private int getOverflowHashKey(int n) {
        return Math.abs(n) % this.m_OverflowSize;
    }

    public collxnIntToObjHashtableEnum keys() {
        return new collxnIntToObjHashtableEnum(this.m_HashArray, this.m_NumberOfPrimarySlots + this.m_OverflowSize);
    }

    private void rehash() {
        this.m_isRehashing = true;
        collxnIntToObjHashtable collxnIntToObjHashtable2 = null;
        int n = this.m_NumberOfPrimarySlots;
        boolean bl = false;
        while (!bl) {
            n = ++this.m_PrimeIndex >= m_PrimeTable.length ? (n += n / 3) : m_PrimeTable[this.m_PrimeIndex];
            collxnIntToObjHashtable2 = new collxnIntToObjHashtable(n);
            bl = true;
            collxnIntToObjHashtableEnum collxnIntToObjHashtableEnum2 = this.keys();
            while (bl && collxnIntToObjHashtableEnum2.hasMoreElements()) {
                int n2 = collxnIntToObjHashtableEnum2.nextElement();
                Object object = this.get(n2);
                bl = collxnIntToObjHashtable2.put(n2, object, false);
            }
        }
        this.m_HashArray = collxnIntToObjHashtable2.getHashArray();
        this.m_ValueArray = collxnIntToObjHashtable2.getValueArray();
        this.m_NumberOfPrimarySlots = collxnIntToObjHashtable2.getNumberOfPrimarySlots();
        this.m_OverflowSize = collxnIntToObjHashtable2.getOverflowSize();
        this.m_isRehashing = false;
    }

    public boolean isRehashing() {
        return this.m_isRehashing;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("exercise prime generator... ");
            boolean bl = true;
            System.out.println();
            collxnIntToObjHashtable collxnIntToObjHashtable2 = new collxnIntToObjHashtable(5);
            collxnIntToObjHashtable2.put(7121239, new Integer(2000));
            collxnIntToObjHashtable2.put(7283212, new Integer(1440));
            collxnIntToObjHashtable2.put(2307223, new Integer(1900));
            collxnIntToObjHashtable2.put(7289282, new Integer(270));
            System.out.println("dump: " + collxnIntToObjHashtable2.toString());
            System.out.println("replacing old value - should be 2000, is: " + collxnIntToObjHashtable2.put(7121239, new Integer(2008)));
            System.out.println("replacing old value - should be 1400, is: " + collxnIntToObjHashtable2.put(7283212, new Integer(1445)));
            System.out.println("replacing old value - should be 1900, is: " + collxnIntToObjHashtable2.put(2307223, new Integer(1965)));
            System.out.println("should be 1965: " + collxnIntToObjHashtable2.get(2307223));
            System.out.println("should be 2008: " + collxnIntToObjHashtable2.get(7121239));
            System.out.println("should be 1445: " + collxnIntToObjHashtable2.get(7283212));
            System.out.println("should be true: " + (collxnIntToObjHashtable2.get(1234) == null ? "true" : "false"));
            System.out.println("should be false: " + (collxnIntToObjHashtable2.get(7121239) == null ? "true" : "false"));
            System.out.println("testing negative keys... ");
            collxnIntToObjHashtable2.put(-1, new Integer(-1));
            collxnIntToObjHashtable2.put(-100, new Integer(-100));
            collxnIntToObjHashtable2.put(-1000, new Integer(-1000));
            System.out.println("should be -1: " + collxnIntToObjHashtable2.get(-1));
            System.out.println("should be -100: " + collxnIntToObjHashtable2.get(-100));
            System.out.println("should be -1000: " + collxnIntToObjHashtable2.get(-1000));
            collxnIntToObjHashtable2 = new collxnIntToObjHashtable(5);
            int n = 0;
            while (n <= 13) {
                collxnIntToObjHashtable2.put(n, new Integer(n));
                ++n;
            }
            System.out.println("\nelements:");
            collxnIEnumerator collxnIEnumerator2 = collxnIntToObjHashtable2.elements();
            while (collxnIEnumerator2.hasMoreElements()) {
                System.out.println(collxnIEnumerator2.nextElement());
            }
            System.out.println("\nkeys:");
            collxnIntToObjHashtableEnum collxnIntToObjHashtableEnum2 = collxnIntToObjHashtable2.keys();
            while (collxnIntToObjHashtableEnum2.hasMoreElements()) {
                System.out.println(collxnIntToObjHashtableEnum2.nextElement());
            }
            System.out.println("removing 3, old value: " + collxnIntToObjHashtable2.remove(3));
            System.out.println("removing 6, old value: " + collxnIntToObjHashtable2.remove(6));
            System.out.println("removing 9, old value: " + collxnIntToObjHashtable2.remove(9));
            System.out.println("removing 12, old value: " + collxnIntToObjHashtable2.remove(12));
            System.out.println("removing 15, old value: " + collxnIntToObjHashtable2.remove(15) + ", should be: " + NOT_FOUND);
            System.out.println("\nelements (after removing 3,6,9,12,15):");
            collxnIEnumerator collxnIEnumerator3 = collxnIntToObjHashtable2.elements();
            while (collxnIEnumerator3.hasMoreElements()) {
                System.out.println(collxnIEnumerator3.nextElement());
            }
            System.out.println("dump table: " + collxnIntToObjHashtable2);
            System.out.println("test overflow/collision handling...");
            collxnIntToObjHashtable2 = new collxnIntToObjHashtable(11);
            int n2 = 0;
            while (n2 < 11) {
                collxnIntToObjHashtable2.put(11 + n2, new Integer(n2));
                ++n2;
            }
            System.out.println("dump table: " + collxnIntToObjHashtable2);
            collxnIntToObjHashtable2.put(0, new Integer(42));
            System.out.println("dump table: " + collxnIntToObjHashtable2);
            System.out.println("get on 0: " + collxnIntToObjHashtable2.get(0));
            System.out.println("random inserts...");
            Random random = new Random(0L);
            Vector<Integer> vector = new Vector<Integer>();
            long l = System.currentTimeMillis();
            int n3 = 0;
            while (n3 < 30000) {
                int n4 = Math.abs(random.nextInt());
                collxnIntToObjHashtable2.put(n4, new Integer(n4));
                vector.addElement(new Integer(n4));
                ++n3;
            }
            System.out.println("randomly inserted: " + collxnIntToObjHashtable2.size() + " keys/value pairs" + " in " + (System.currentTimeMillis() - l) + "ms");
            System.out.println("verifying random keys...");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                int n5 = (Integer)enumeration.nextElement();
                try {
                    if ((Integer)collxnIntToObjHashtable2.get(n5) == n5) continue;
                    System.out.println("******** random key access failed: " + n5);
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("******** random key access failed: " + n5 + " null pointer ");
                }
            }
            System.out.println("clearing table...");
            long l2 = System.currentTimeMillis();
            int n6 = 30000;
            collxnIntToObjHashtable2 = new collxnIntToObjHashtable(1001);
            int n7 = 0;
            while (n7 < n6) {
                collxnIntToObjHashtable2.put(n7, new Integer(n7));
                ++n7;
            }
            int n8 = 0;
            while (n8 < n6) {
                if ((Integer)collxnIntToObjHashtable2.get(n8) != n8) {
                    System.out.println("failed get i=" + n8);
                }
                ++n8;
            }
            long l3 = System.currentTimeMillis();
            System.out.println("sequentially inserted: " + collxnIntToObjHashtable2.size() + " keys/value pairs");
            System.out.println("Time to put/get " + n6 + " int's was: " + (l3 - l2) + " ms");
            System.out.println("now test putting the same key in many times...");
            collxnIntToObjHashtable2 = new collxnIntToObjHashtable(1001);
            int n9 = 0;
            while (n9 < 100) {
                collxnIntToObjHashtable2.put(42, new Integer(42));
                ++n9;
            }
            System.out.println("\nelement, count: " + collxnIntToObjHashtable2.size());
            collxnIEnumerator collxnIEnumerator4 = collxnIntToObjHashtable2.elements();
            while (collxnIEnumerator4.hasMoreElements()) {
                System.out.println(collxnIEnumerator4.nextElement());
            }
        }
        catch (dbexcpException dbexcpException2) {
            System.out.println(dbexcpException2);
            dbexcpException2.printStackTrace();
        }
    }

    class collxnHashtableEnumerator
    implements collxnIEnumerator {
        int m_index = -1;
        int[] m_Keys;
        Object[] m_Values;
        int m_CurrentKey = NOT_FOUND;
        boolean m_NextElementSend = true;

        collxnHashtableEnumerator(int[] nArray, Object[] objectArray) {
            this.m_Keys = nArray;
            this.m_Values = objectArray;
        }

        public boolean hasMoreElements() throws dbexcpException {
            if (!this.m_NextElementSend) {
                return true;
            }
            this.m_NextElementSend = false;
            while (++this.m_index < this.m_Keys.length) {
                this.m_CurrentKey = this.m_Keys[this.m_index];
                if (this.m_CurrentKey == NOT_FOUND) continue;
                this.m_NextElementSend = false;
                return true;
            }
            this.m_NextElementSend = true;
            return false;
        }

        public Object nextElement() throws dbexcpException {
            if (this.m_NextElementSend && !this.hasMoreElements()) {
                throw new NoSuchElementException("collxnHashtableEnumerator");
            }
            this.m_NextElementSend = true;
            return this.m_Values[this.m_index];
        }

        public void releaseResources() throws dbexcpException {
        }
    }
}

