/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Channel;
import org.jgroups.GetStateEvent;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.SetStateEvent;
import org.jgroups.util.Util;

public class LargeState
extends ReceiverAdapter {
    Channel channel;
    byte[] state = null;
    Thread getter = null;
    boolean rc = false;
    String props;
    long start;
    long stop;
    boolean provider = true;

    public void start(boolean provider, int size, String props) throws Exception {
        this.provider = provider;
        this.channel = new JChannel(props);
        this.channel.setOpt(4, Boolean.TRUE);
        this.channel.setReceiver(this);
        this.channel.connect("TestChannel");
        System.out.println("-- connected to channel");
        if (provider) {
            System.out.println("Creating state of " + size + " bytes");
            this.state = this.createLargeState(size);
            System.out.println("Done. Waiting for other members to join and fetch large state");
        } else {
            System.out.println("Getting state");
            this.start = System.currentTimeMillis();
            this.rc = this.channel.getState(null, 30000L);
            System.out.println("getState(), rc=" + this.rc);
            if (!this.rc) {
                this.channel.close();
                return;
            }
        }
        if (provider) {
            while (true) {
                Util.sleep(10000L);
            }
        }
        this.channel.close();
    }

    public void mainLoop() {
        try {
            while (true) {
                Object ret;
                if ((ret = this.channel.receive(0L)) instanceof Message) {
                    System.out.println("-- received msg " + ((Message)ret).getObject() + " from " + ((Message)ret).getSrc());
                    continue;
                }
                if (ret instanceof GetStateEvent) {
                    System.out.println("--> returning state: " + ret);
                    this.channel.returnState(this.state);
                    continue;
                }
                if (!(ret instanceof SetStateEvent)) continue;
                this.stop = System.currentTimeMillis();
                byte[] new_state = ((SetStateEvent)ret).getArg();
                if (new_state != null) {
                    this.state = new_state;
                    System.out.println("<-- Received state, size =" + this.state.length + " (took " + (this.stop - this.start) + "ms)");
                }
                if (!this.provider) break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    byte[] createLargeState(int size) {
        byte[] retval = new byte[size];
        return retval;
    }

    public void receive(Message msg) {
        System.out.println("-- received msg " + msg.getObject() + " from " + msg.getSrc());
    }

    public byte[] getState() {
        System.out.println("--> returning state: " + this.state.length + " bytes");
        return this.state;
    }

    public void setState(byte[] state) {
        this.stop = System.currentTimeMillis();
        byte[] new_state = state;
        if (new_state != null) {
            this.state = new_state;
            System.out.println("<-- Received state, size =" + state.length + " (took " + (this.stop - this.start) + "ms)");
        }
    }

    public static void main(String[] args) {
        boolean provider = false;
        int size = 0x100000;
        String props = "UDP(mcast_addr=239.255.0.35;mcast_port=7500;ip_ttl=2;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;ucast_send_buf_size=80000;ucast_recv_buf_size=150000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=300,600,900,1200,2400):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=60000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        for (int i = 0; i < args.length; ++i) {
            if ("-help".equals(args[i])) {
                LargeState.help();
                return;
            }
            if ("-provider".equals(args[i])) {
                provider = true;
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if (!"-props".equals(args[i])) continue;
            props = args[++i];
        }
        try {
            new LargeState().start(provider, size, props);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    static void help() {
        System.out.println("LargeState [-help] [-size <size of state in bytes] [-provider] [-props <properties>]");
    }
}

