/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.PingSender;
import org.jgroups.protocols.PingWaiter;
import org.jgroups.stack.Protocol;

public abstract class Discovery
extends Protocol {
    final Vector members = new Vector(11);
    Address local_addr = null;
    String group_addr = null;
    long timeout = 3000L;
    int num_initial_members = 2;
    boolean is_server = false;
    PingWaiter ping_waiter;
    int num_ping_requests = 2;
    int num_discovery_requests = 0;

    public void localAddressSet(Address addr) {
    }

    public abstract void sendGetMembersRequest();

    public void handleConnectOK() {
    }

    public void handleDisconnect() {
    }

    public void handleConnect() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        if (this.ping_waiter != null) {
            this.ping_waiter.setTimeout(timeout);
        }
    }

    public int getNumInitialMembers() {
        return this.num_initial_members;
    }

    public void setNumInitialMembers(int num_initial_members) {
        this.num_initial_members = num_initial_members;
        if (this.ping_waiter != null) {
            this.ping_waiter.setNumRsps(num_initial_members);
        }
    }

    public int getNumPingRequests() {
        return this.num_ping_requests;
    }

    public void setNumPingRequests(int num_ping_requests) {
        this.num_ping_requests = num_ping_requests;
    }

    public int getNumberOfDiscoveryRequestsSent() {
        return this.num_discovery_requests;
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>(1);
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            if (this.timeout <= 0L) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"timeout must be > 0");
                }
                return false;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = Integer.parseInt(str);
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("num_ping_requests")) != null) {
            this.num_ping_requests = Integer.parseInt(str);
            props.remove("num_ping_requests");
            if (this.num_ping_requests < 1) {
                this.num_ping_requests = 1;
            }
        }
        if (props.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                sb.append(e.nextElement().toString());
                if (!e.hasMoreElements()) continue;
                sb.append(", ");
            }
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("The following properties are not recognized: " + sb));
            }
            return false;
        }
        return true;
    }

    public void resetStats() {
        super.resetStats();
        this.num_discovery_requests = 0;
    }

    public void start() throws Exception {
        super.start();
        PingSender ping_sender = new PingSender(this.timeout, this.num_ping_requests, this);
        if (this.ping_waiter == null) {
            this.ping_waiter = new PingWaiter(this.timeout, this.num_initial_members, this, ping_sender);
        }
    }

    public void stop() {
        this.is_server = false;
        if (this.ping_waiter != null) {
            this.ping_waiter.stop();
        }
    }

    public Vector findInitialMembers() {
        return this.ping_waiter != null ? this.ping_waiter.findInitialMembers() : null;
    }

    public String findInitialMembersAsString() {
        Vector results = this.findInitialMembers();
        if (results == null || results.size() == 0) {
            return "<empty>";
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            PingRsp rsp = (PingRsp)it.next();
            sb.append(rsp).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (this.local_addr != null && msg.getSrc() != null && this.local_addr.equals(msg.getSrc())) {
                            if (this.trace) {
                                this.log.trace((Object)"discarded my own discovery request");
                            }
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        PingRsp ping_rsp = new PingRsp(this.local_addr, coord, this.is_server);
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, ping_rsp);
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        if (this.trace) {
                            this.log.trace((Object)("received GET_MBRS_REQ from " + msg.getSrc() + ", sending response " + rsp_hdr));
                        }
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = hdr.arg;
                        if (this.trace) {
                            this.log.trace((Object)("received GET_MBRS_RSP, rsp=" + rsp));
                        }
                        this.ping_waiter.addResponse(rsp);
                        return;
                    }
                }
                if (this.warn) {
                    this.log.warn((Object)("got PING header with unknown type (" + hdr.type + ')'));
                }
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                this.localAddressSet(this.local_addr);
                break;
            }
            case 3: {
                this.handleConnectOK();
                this.passUp(evt);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                ++this.num_discovery_requests;
                this.ping_waiter.start();
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.clear();
                        this.members.addAll(tmp);
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                this.handleConnect();
                break;
            }
            case 4: {
                this.handleDisconnect();
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    protected View makeView(Vector mbrs) {
        ViewId view_id = new ViewId(this.local_addr);
        Address coord = view_id.getCoordAddress();
        long id = view_id.getId();
        return new View(coord, id, mbrs);
    }
}

