/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class DatabaseMetaData {
    protected Connection _conn;
    protected String _database = null;
    protected String _quotedId = null;
    private static final byte[] _TABLE_AS_BYTES = "TABLE".getBytes();

    public DatabaseMetaData(Connection connection, String string) {
        this._conn = connection;
        this._database = string;
        try {
            this._quotedId = this._conn.supportsQuotedIdentifiers() ? this.getIdentifierQuoteString() : "";
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    public String getURL() throws SQLException {
        return this._conn.getURL();
    }

    public String getUserName() throws SQLException {
        return this._conn.getUser();
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "MySQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this._conn.getServerVersion();
    }

    public String getDriverName() throws SQLException {
        return "Mark Matthews' MySQL Driver";
    }

    public String getDriverVersion() throws SQLException {
        return "2.0.14";
    }

    public int getDriverMajorVersion() {
        return 2;
    }

    public int getDriverMinorVersion() {
        return 0;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        if (this._conn.supportsQuotedIdentifiers()) {
            if (!this._conn.useAnsiQuotedIdentifiers()) {
                return "`";
            }
            return "\"";
        }
        return " ";
    }

    public String getSQLKeywords() throws SQLException {
        return "AUTO_INCREMENT,BINARY,BLOB,ENUM,INFILE,LOAD,MEDIUMINT,OPTION,OUTFILE,REPLACE,SET,TEXT,UNSIGNED,ZEROFILL";
    }

    public String getNumericFunctions() throws SQLException {
        return "ABS,ACOS,ASIN,ATAN,ATAN2,BIT_COUNT,CEILING,COS,COT,DEGREES,EXP,FLOOR,LOG,LOG10,MAX,MIN,MOD,PI,POW,POWER,RADIANS,RAND,ROUND,SIN,SQRT,TAN,TRUNCATE";
    }

    public String getStringFunctions() throws SQLException {
        return "ACII,CHAR,CHAR_LENGTH,CHARACTER_LENGTH,CONCAT,ELT,FIELD,FIND_IN_SET,INSERT,INSTR,INTERVAL,LCASE,LEFT,LENGTH,LOCATE,LOWER,LTRIM,MID,POSITION,OCTET_LENGTH,REPEAT,REPLACE,REVERSE,RIGHT,RTRIM,SPACE,SOUNDEX,SUBSTRING,SUBSTRING_INDEX,TRIM,UCASE,UPPER";
    }

    public String getSystemFunctions() throws SQLException {
        return "DATABASE,USER,SYSTEM_USER,SESSION_USER,PASSWORD,ENCRYPT,LAST_INSERT_ID,VERSION";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "DAYOFWEEK,WEEKDAY,DAYOFMONTH,DAYOFYEAR,MONTH,DAYNAME,MONTHNAME,QUARTER,WEEK,YEAR,HOUR,MINUTE,SECOND,PERIOD_ADD,PERIOD_DIFF,TO_DAYS,FROM_DAYS,DATE_FORMAT,TIME_FORMAT,CURDATE,CURRENT_DATE,CURTIME,CURRENT_TIME,NOW,SYSDATE,CURRENT_TIMESTAMP,UNIX_TIMESTAMP,FROM_UNIXTIME,SEC_TO_TIME,TIME_TO_SEC";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 1111: {
                        return true;
                    }
                }
                return false;
            }
            case -7: {
                return false;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                switch (n2) {
                    case -6: 
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 0: {
                return false;
            }
            case 1111: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (n2) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: 
                    case 1: 
                    case 12: 
                    case 91: 
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "";
    }

    public String getProcedureTerm() throws SQLException {
        return "";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this._conn.getServerMajorVersion() >= 3) {
            if (this._conn.getServerMajorVersion() == 3) {
                return this._conn.getServerMinorVersion() >= 22;
            }
            return true;
        }
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    public boolean supportsUnion() throws SQLException {
        return this._conn._io.versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsUnionAll() throws SQLException {
        return this._conn._io.versionMeetsMinimum(4, 0, 0);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0xFFFFF8;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return 64;
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 16;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 256;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 512;
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return 64;
    }

    public int getMaxIndexLength() throws SQLException {
        return 128;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return 32;
    }

    public int getMaxRowSize() throws SQLException {
        return 0x7FFFFFF7;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    public int getMaxStatementLength() throws SQLException {
        return MysqlIO.MAXBUF - 4;
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return 64;
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 256;
    }

    public int getMaxUserNameLength() throws SQLException {
        return 16;
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        if (this._conn.supportsIsolationLevel()) {
            return 2;
        }
        return 0;
    }

    public boolean supportsTransactions() throws SQLException {
        return this._conn.supportsTransactions();
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (this._conn.supportsIsolationLevel()) {
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "resTABLE_CAT", 1, 0), new Field("", "REMARKS", 1, 0), new Field("", "PROCEDURE_TYPE", 5, 0)};
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 0), new Field("", "PROCEDURE_CAT", 1, 0), new Field("", "PROCEDURE_SCHEM", 1, 0), new Field("", "PROCEDURE_NAME", 1, 0), new Field("", "COLUMN_NAME", 1, 0), new Field("", "COLUMN_TYPE", 1, 0), new Field("", "DATA_TYPE", 5, 0), new Field("", "TYPE_NAME", 1, 0), new Field("", "PRECISION", 4, 0), new Field("", "LENGTH", 4, 0), new Field("", "SCALE", 5, 0), new Field("", "RADIX", 5, 0), new Field("", "NULLABLE", 5, 0), new Field("", "REMARKS", 1, 0)};
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        Object object;
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + this._quotedId + string + this._quotedId;
            }
        } else {
            string4 = " FROM " + this._quotedId + this._database + this._quotedId;
        }
        if (string3 == null) {
            string3 = "%";
        }
        java.sql.ResultSet resultSet = this._conn.createStatement().executeQuery("show tables " + string4 + " like '" + string3 + "'");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 12, string == null ? 0 : string.length()), new Field("", "TABLE_SCHEM", 12, 0), new Field("", "TABLE_NAME", 12, 255), new Field("", "TABLE_TYPE", 12, 5), new Field("", "REMARKS", 12, 0)};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byte[][] byArrayArray = null;
        while (resultSet.next()) {
            object = resultSet.getString(1);
            byArrayArray = new byte[][]{string == null ? new byte[]{} : string.getBytes(), new byte[0], ((String)object).getBytes(), _TABLE_AS_BYTES, new byte[0]};
            vector.addElement(byArrayArray);
        }
        object = this.buildResultSet(fieldArray, vector, this._conn);
        return object;
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_SCHEM", 1, 0)};
        Vector vector = new Vector();
        java.sql.ResultSet resultSet = this.buildResultSet(fieldArray, vector, this._conn);
        return resultSet;
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        java.sql.ResultSet resultSet = this._conn.createStatement().executeQuery("SHOW DATABASES");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 12, resultSetMetaData.getColumnDisplaySize(1))};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            byte[][] byArrayArray = new byte[][]{resultSet.getBytes(1)};
            vector.addElement(byArrayArray);
        }
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Vector<byte[][]> vector = new Vector<byte[][]>();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_TYPE", 12, 5)};
        byte[][] byArrayArray = new byte[][]{_TABLE_AS_BYTES};
        vector.addElement(byArrayArray);
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        Object object;
        Object object2;
        java.sql.ResultSet resultSet;
        String string5 = "";
        if (string4 == null) {
            string4 = "%";
        }
        if (string != null) {
            if (!string.equals("")) {
                string5 = " FROM " + this._quotedId + string + this._quotedId;
            }
        } else {
            string5 = " FROM " + this._quotedId + this._database + this._quotedId;
        }
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (string3 == null) {
            resultSet = this.getTables(string, string2, "%", new String[0]);
            while (resultSet.next()) {
                object2 = resultSet.getString("TABLE_NAME");
                vector.addElement((String)object2);
                if (((String)object2).length() <= n) continue;
                n = ((String)object2).length();
            }
            resultSet.close();
        } else {
            resultSet = this.getTables(string, string2, string3, new String[0]);
            while (resultSet.next()) {
                object2 = resultSet.getString("TABLE_NAME");
                vector.addElement((String)object2);
                if (((String)object2).length() <= n) continue;
                n = ((String)object2).length();
            }
            resultSet.close();
        }
        int n2 = 0;
        if (string != null) {
            n2 = string.length();
        } else {
            string = "";
            n2 = 0;
        }
        object2 = vector.elements();
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, n2), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, n), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10), new Field("", "NULLABLE", 4, 10), new Field("", "REMARKS", 1, 0), new Field("", "COLUMN_DEF", 1, 0), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "CHAR_OCTET_LENGTH", 4, Integer.toString(Integer.MAX_VALUE).length()), new Field("", "ORDINAL_POSITION", 4, 10), new Field("", "IS_NULLABLE", 1, 3)};
        Vector<byte[][]> vector2 = new Vector<byte[][]>();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            ResultSet resultSet2 = this._conn.execSQL("show columns from " + (String)object + string5 + " like '" + string4 + "'", -1);
            resultSet2.setConnection(this._conn);
            ResultSetMetaData resultSetMetaData = resultSet2.getMetaData();
            int n3 = 1;
            while (resultSet2.next()) {
                Object object3;
                String string6;
                byte[][] byArrayArray = new byte[18][];
                byArrayArray[0] = string.getBytes();
                byArrayArray[1] = new byte[0];
                byArrayArray[2] = ((String)object).getBytes();
                byArrayArray[3] = resultSet2.getBytes("Field");
                String string7 = resultSet2.getString("Type");
                String string8 = "";
                string8 = string7.indexOf("(") != -1 ? string7.substring(0, string7.indexOf("(")) : string7;
                if (this._conn.capitalizeDBMDTypes()) {
                    string8 = string8.toUpperCase();
                }
                byArrayArray[4] = Integer.toString(MysqlDefs.mysqlToJavaType(string8)).getBytes();
                byArrayArray[5] = string8.getBytes();
                if (string7 != null) {
                    if (string7.indexOf("enum") != -1 || string7.indexOf("set") != -1) {
                        string6 = string7.substring(string7.indexOf("("), string7.lastIndexOf(")"));
                        object3 = new StringTokenizer(string6, ",");
                        int n4 = 0;
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            n4 = Math.max(n4, ((StringTokenizer)object3).nextToken().length() - 2);
                        }
                        byArrayArray[6] = Integer.toString(n4).getBytes();
                        byArrayArray[8] = new byte[]{48};
                    } else if (string7.indexOf(",") != -1) {
                        string6 = string7.substring(string7.indexOf("(") + 1, string7.indexOf(","));
                        object3 = string7.substring(string7.indexOf(",") + 1, string7.indexOf(")"));
                        byArrayArray[6] = string6.getBytes();
                        byArrayArray[8] = ((String)object3).getBytes();
                    } else {
                        string6 = "0";
                        if (string7.indexOf("(") != -1) {
                            string6 = string7.substring(string7.indexOf("(") + 1, string7.indexOf(")"));
                        } else if (string7.toLowerCase().equals("tinyint")) {
                            string6 = "1";
                        } else if (string7.toLowerCase().equals("smallint")) {
                            string6 = "6";
                        } else if (string7.toLowerCase().equals("mediumint")) {
                            string6 = "6";
                        } else if (string7.toLowerCase().equals("int")) {
                            string6 = "11";
                        } else if (string7.toLowerCase().equals("integer")) {
                            string6 = "11";
                        } else if (string7.toLowerCase().equals("bigint")) {
                            string6 = "25";
                        } else if (string7.toLowerCase().equals("int24")) {
                            string6 = "25";
                        } else if (string7.toLowerCase().equals("real")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("float")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("decimal")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("numeric")) {
                            string6 = "12";
                        } else if (string7.toLowerCase().equals("double")) {
                            string6 = "22";
                        } else if (string7.toLowerCase().equals("char")) {
                            string6 = "1";
                        } else if (string7.toLowerCase().equals("varchar")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("date")) {
                            string6 = "10";
                        } else if (string7.toLowerCase().equals("time")) {
                            string6 = "8";
                        } else if (string7.toLowerCase().equals("timestamp")) {
                            string6 = "19";
                        } else if (string7.toLowerCase().equals("datetime")) {
                            string6 = "19";
                        } else if (string7.toLowerCase().equals("tinyblob")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("blob")) {
                            string6 = Integer.toString(Math.min(65535, MysqlIO.getMaxBuf()));
                        } else if (string7.toLowerCase().equals("mediumblob")) {
                            string6 = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                        } else if (string7.toLowerCase().equals("longblob")) {
                            string6 = Integer.toString(MysqlIO.getMaxBuf()).compareTo("2147483657") < 0 ? Integer.toString(MysqlIO.getMaxBuf()) : "2147483657";
                        } else if (string7.toLowerCase().equals("tinytext")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("text")) {
                            string6 = "65535";
                        } else if (string7.toLowerCase().equals("mediumtext")) {
                            string6 = Integer.toString(Math.min(16277215, MysqlIO.getMaxBuf()));
                        } else if (string7.toLowerCase().equals("enum")) {
                            string6 = "255";
                        } else if (string7.toLowerCase().equals("set")) {
                            string6 = "255";
                        }
                        byArrayArray[6] = string6.getBytes();
                        byArrayArray[8] = new byte[]{48};
                    }
                } else {
                    byArrayArray[8] = new byte[]{48};
                    byArrayArray[6] = new byte[]{48};
                }
                byArrayArray[7] = Integer.toString(MysqlIO.MAXBUF).getBytes();
                byArrayArray[9] = new byte[]{49, 48};
                string6 = resultSet2.getString("Null");
                if (string6 != null) {
                    if (string6.equals("YES")) {
                        byArrayArray[10] = Integer.toString(1).getBytes();
                        byArrayArray[17] = new String("YES").getBytes();
                    } else {
                        byArrayArray[10] = Integer.toString(0).getBytes();
                        byArrayArray[17] = "NO".getBytes();
                    }
                } else {
                    byArrayArray[10] = Integer.toString(0).getBytes();
                    byArrayArray[17] = "NO".getBytes();
                }
                try {
                    byArrayArray[11] = resultSet2.getString("Extra").getBytes();
                }
                catch (Exception exception) {
                    byArrayArray[11] = new byte[0];
                }
                object3 = resultSet2.getBytes("Default");
                byArrayArray[12] = object3 != null ? (Object)object3 : new byte[0];
                byArrayArray[13] = new byte[]{48};
                byArrayArray[14] = new byte[]{48};
                byArrayArray[15] = byArrayArray[6];
                byArrayArray[16] = Integer.toString(n3++).getBytes();
                vector2.addElement(byArrayArray);
            }
            resultSet2.close();
        }
        object = this.buildResultSet(fieldArray, vector2, this._conn);
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "COLUMN_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
        StringBuffer stringBuffer = new StringBuffer("SELECT c.host, c.db, t.grantor, c.user, c.table_name, c.column_name, c.column_priv from mysql.columns_priv c, mysql.tables_priv t where c.host = t.host and c.db = t.db and c.table_name = t.table_name ");
        stringBuffer.append(" WHERE ");
        if (string != null && string.length() != 0) {
            stringBuffer.append(" c.db='");
            stringBuffer.append(string);
            stringBuffer.append("' AND ");
        }
        stringBuffer.append("c.table_name ='");
        stringBuffer.append(string3);
        stringBuffer.append("' AND c.column_name like '");
        stringBuffer.append(string4);
        ResultSet resultSet = null;
        Vector<byte[][]> vector = new Vector<byte[][]>();
        try {
            resultSet = this._conn.execSQL(stringBuffer.toString(), -1);
            resultSet.setConnection(this._conn);
            while (resultSet.next()) {
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                String string8 = resultSet.getString(4);
                if (string8 == null || string8.length() == 0) {
                    string8 = "%";
                }
                StringBuffer stringBuffer2 = new StringBuffer(string8);
                if (string5 != null) {
                    stringBuffer2.append("@");
                    stringBuffer2.append(string5);
                }
                String string9 = resultSet.getString(6);
                String string10 = resultSet.getString(7);
                if (string10 == null) continue;
                string10 = string10.toUpperCase();
                StringTokenizer stringTokenizer = new StringTokenizer(string10, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken().trim();
                    byte[][] byArrayArray = new byte[][]{this.s2b(string6), null, this.s2b(string3), this.s2b(string9), (byte[])(string7 != null ? this.s2b(string7) : null), this.s2b(stringBuffer2.toString()), this.s2b(string11), null};
                    vector.addElement(byArrayArray);
                }
            }
            Object var20_19 = null;
            if (resultSet == null) return this.buildResultSet(fieldArray, vector, this._conn);
        }
        catch (Throwable throwable) {
            Object var20_20 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            resultSet.close();
            return this.buildResultSet(fieldArray, vector, this._conn);
        }
        catch (Exception exception) {}
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 64), new Field("", "TABLE_SCHEM", 1, 1), new Field("", "TABLE_NAME", 1, 64), new Field("", "GRANTOR", 1, 77), new Field("", "GRANTEE", 1, 77), new Field("", "PRIVILEGE", 1, 64), new Field("", "IS_GRANTABLE", 1, 3)};
        StringBuffer stringBuffer = new StringBuffer("SELECT host,db,table_name,grantor,user,table_priv from mysql.tables_priv ");
        stringBuffer.append(" WHERE ");
        if (string != null && string.length() != 0) {
            stringBuffer.append(" db='");
            stringBuffer.append(string);
            stringBuffer.append("' AND ");
        }
        stringBuffer.append("table_name like '");
        stringBuffer.append(string3);
        stringBuffer.append("'");
        ResultSet resultSet = null;
        Vector<byte[][]> vector = new Vector<byte[][]>();
        try {
            resultSet = this._conn.execSQL(stringBuffer.toString(), -1);
            resultSet.setConnection(this._conn);
            while (resultSet.next()) {
                String string4;
                String string5 = resultSet.getString(1);
                String string6 = resultSet.getString(2);
                String string7 = resultSet.getString(3);
                String string8 = resultSet.getString(4);
                String string9 = resultSet.getString(5);
                if (string9 == null || string9.length() == 0) {
                    string9 = "%";
                }
                StringBuffer stringBuffer2 = new StringBuffer(string9);
                if (string5 != null) {
                    stringBuffer2.append("@");
                    stringBuffer2.append(string5);
                }
                if ((string4 = resultSet.getString(6)) == null) continue;
                string4 = string4.toUpperCase();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    Exception exception2;
                    Object var21_20;
                    String string10 = stringTokenizer.nextToken().trim();
                    java.sql.ResultSet resultSet2 = null;
                    try {
                        resultSet2 = this.getColumns(string, string2, string7, "%");
                        while (resultSet2.next()) {
                            String string11 = resultSet2.getString(4);
                            byte[][] byArrayArray = new byte[8][];
                            byArrayArray[0] = this.s2b(string6);
                            byArrayArray[1] = null;
                            byArrayArray[2] = this.s2b(string7);
                            byArrayArray[3] = (byte[])(string8 != null ? this.s2b(string8) : null);
                            byArrayArray[4] = this.s2b(stringBuffer2.toString());
                            byArrayArray[5] = this.s2b(string10);
                            byArrayArray[6] = null;
                            vector.addElement(byArrayArray);
                        }
                        var21_20 = null;
                        if (resultSet2 == null) continue;
                    }
                    catch (Throwable throwable) {
                        var21_20 = null;
                        if (resultSet2 == null) throw throwable;
                        try {
                            resultSet2.close();
                            throw throwable;
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        resultSet2.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            Object var24_23 = null;
            if (resultSet == null) return this.buildResultSet(fieldArray, vector, this._conn);
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            resultSet.close();
            return this.buildResultSet(fieldArray, vector, this._conn);
        }
        catch (Exception exception) {}
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 32), new Field("", "TYPE_NAME", 1, 32), new Field("", "COLUMN_SIZE", 4, 10), new Field("", "BUFFER_LENGTH", 4, 10), new Field("", "DECIMAL_DIGITS", 4, 10), new Field("", "PSEUDO_COLUMN", 5, 5)};
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + this._quotedId + string + this._quotedId;
            }
        } else {
            string4 = " FROM " + this._quotedId + this._database + this._quotedId;
        }
        if (string3 == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet resultSet = this._conn.execSQL("show columns from " + string3 + string4, -1);
        resultSet.setConnection(this._conn);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            String string5 = resultSet.getString("Key");
            if (string5 == null || !string5.toUpperCase().startsWith("PRI")) continue;
            byte[][] byArrayArray = new byte[8][];
            byArrayArray[0] = Integer.toString(2).getBytes();
            byArrayArray[1] = resultSet.getBytes("Field");
            String string6 = resultSet.getString("Type");
            int n2 = MysqlIO.getMaxBuf();
            int n3 = 0;
            if (string6.indexOf("enum") != -1) {
                String string7 = string6.substring(string6.indexOf("("), string6.indexOf(")"));
                StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    n4 = Math.max(n4, stringTokenizer.nextToken().length() - 2);
                }
                n2 = n4;
                n3 = 0;
                string6 = "enum";
            } else if (string6.indexOf("(") != -1) {
                if (string6.indexOf(",") != -1) {
                    n2 = Integer.parseInt(string6.substring(string6.indexOf("(") + 1, string6.indexOf(",")));
                    n3 = Integer.parseInt(string6.substring(string6.indexOf(",") + 1, string6.indexOf(")")));
                } else {
                    n2 = Integer.parseInt(string6.substring(string6.indexOf("(") + 1, string6.indexOf(")")));
                }
                string6 = string6.substring(string6.indexOf("("));
            }
            byArrayArray[2] = new byte[0];
            byArrayArray[3] = string6.getBytes();
            byArrayArray[4] = Integer.toString(n2 + n3).getBytes();
            byArrayArray[5] = Integer.toString(n2 + n3).getBytes();
            byArrayArray[6] = Integer.toString(n3).getBytes();
            byArrayArray[7] = Integer.toString(1).getBytes();
            vector.addElement(byArrayArray);
        }
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "SCOPE", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "TYPE_NAME", 1, 16), new Field("", "COLUMN_SIZE", 1, 16), new Field("", "BUFFER_LENGTH", 1, 16), new Field("", "DECIMAL_DIGITS", 1, 16), new Field("", "PSEUDO_COLUMN", 5, 5)};
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "COLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 5), new Field("", "PK_NAME", 1, 32)};
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + this._quotedId + string + this._quotedId;
            }
        } else {
            string4 = " FROM " + this._quotedId + this._database + this._quotedId;
        }
        if (string3 == null) {
            throw new SQLException("Table not specified.", "S1009");
        }
        ResultSet resultSet = this._conn.execSQL("show keys from " + string3 + string4, -1);
        resultSet.setConnection(this._conn);
        Vector<byte[][]> vector = new Vector<byte[][]>();
        boolean bl = true;
        while (resultSet.next()) {
            byte[][] byArrayArray;
            String string5 = resultSet.getString("Key_name");
            if (string5 == null || !string5.toUpperCase().startsWith("PRI")) continue;
            byArrayArray = new byte[][]{string == null ? new byte[]{} : string.getBytes(), new byte[0], string3.getBytes(), resultSet.getBytes("Column_name"), this.s2b(resultSet.getString("Seq_in_index")), byArrayArray[3]};
            vector.addElement(byArrayArray);
        }
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this._conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            String string4 = "";
            if (string != null) {
                if (!string.equals("")) {
                    string4 = " from " + string;
                }
            } else {
                string4 = " from " + this._database;
            }
            if (string3 == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            ResultSet resultSet = this._conn.execSQL("show table status " + string4 + " like '" + string3 + "'", -1);
            resultSet.setConnection(this._conn);
            Vector<byte[][]> vector = new Vector<byte[][]>();
            while (resultSet.next()) {
                String string5;
                String string6;
                String string7 = resultSet.getString("Type");
                if (string7 == null || !string7.toLowerCase().equals("innodb") || (string6 = resultSet.getString("Comment")) == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    byte[][] byArrayArray = new byte[14][];
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string8, "() /", false);
                    byArrayArray[4] = string == null ? new byte[]{} : string.getBytes();
                    byArrayArray[5] = null;
                    byArrayArray[6] = string3.getBytes();
                    byArrayArray[7] = this.s2b(stringTokenizer2.nextToken());
                    string5 = stringTokenizer2.nextToken();
                    byArrayArray[0] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[1] = null;
                    byArrayArray[2] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[3] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[8] = Integer.toString(n).getBytes();
                    byArrayArray[9] = Integer.toString(4).getBytes();
                    byArrayArray[10] = Integer.toString(4).getBytes();
                    byArrayArray[11] = null;
                    byArrayArray[12] = null;
                    byArrayArray[13] = Integer.toString(7).getBytes();
                    vector.addElement(byArrayArray);
                    ++n;
                }
            }
            return this.buildResultSet(fieldArray, vector, this._conn);
        }
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this._conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            String string4 = "";
            if (string != null) {
                if (!string.equals("")) {
                    string4 = " FROM " + string;
                }
            } else {
                string4 = " FROM " + this._database;
            }
            if (string3 == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            ResultSet resultSet = this._conn.execSQL("show table status " + string4, -1);
            resultSet.setConnection(this._conn);
            Vector<byte[][]> vector = new Vector<byte[][]>();
            while (resultSet.next()) {
                String string5;
                String string6;
                String string7 = resultSet.getString("Type");
                if (string7 == null || !string7.toLowerCase().equals("innodb") || (string6 = resultSet.getString("Comment")) == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string6, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string8, "() /", false);
                    byte[][] byArrayArray = new byte[14][];
                    byArrayArray[4] = string == null ? new byte[]{} : string.getBytes();
                    byArrayArray[5] = null;
                    byArrayArray[6] = resultSet.getString("Name").getBytes();
                    byArrayArray[7] = this.s2b(stringTokenizer2.nextToken());
                    string5 = stringTokenizer2.nextToken();
                    byArrayArray[0] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[1] = null;
                    string5 = stringTokenizer2.nextToken();
                    if (string5.compareTo(string3) != 0) continue;
                    byArrayArray[2] = this.s2b(string3);
                    byArrayArray[3] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[8] = Integer.toString(n).getBytes();
                    byArrayArray[9] = Integer.toString(4).getBytes();
                    byArrayArray[10] = Integer.toString(4).getBytes();
                    byArrayArray[11] = null;
                    byArrayArray[12] = null;
                    byArrayArray[13] = Integer.toString(7).getBytes();
                    vector.addElement(byArrayArray);
                    ++n;
                }
            }
            return this.buildResultSet(fieldArray, vector, this._conn);
        }
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "PKTABLE_CAT", 1, 255), new Field("", "PKTABLE_SCHEM", 1, 0), new Field("", "PKTABLE_NAME", 1, 255), new Field("", "PKCOLUMN_NAME", 1, 32), new Field("", "FKTABLE_CAT", 1, 255), new Field("", "FKTABLE_SCHEM", 1, 0), new Field("", "FKTABLE_NAME", 1, 255), new Field("", "FKCOLUMN_NAME", 1, 32), new Field("", "KEY_SEQ", 5, 2), new Field("", "UPDATE_RULE", 5, 2), new Field("", "DELETE_RULE", 5, 2), new Field("", "FK_NAME", 1, 0), new Field("", "PK_NAME", 1, 0), new Field("", "DEFERRABILITY", 4, 2)};
        if (this._conn.getIO().versionMeetsMinimum(3, 23, 0)) {
            String string7 = "";
            if (string4 != null) {
                if (!string4.equals("")) {
                    string7 = " FROM " + string4;
                }
            } else {
                string7 = " FROM " + this._database;
            }
            if (string3 == null) {
                throw new SQLException("Table not specified.", "S1009");
            }
            ResultSet resultSet = this._conn.execSQL("show table status " + string7, -1);
            resultSet.setConnection(this._conn);
            Vector<byte[][]> vector = new Vector<byte[][]>();
            while (resultSet.next()) {
                String string8;
                String string9;
                String string10 = resultSet.getString("Type");
                if (string10 == null || !string10.toLowerCase().equals("innodb") || (string9 = resultSet.getString("Comment")) == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string9, ";", false);
                if (stringTokenizer.hasMoreTokens()) {
                    string8 = stringTokenizer.nextToken();
                }
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string11 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string11, "() /", false);
                    byte[][] byArrayArray = new byte[14][];
                    byArrayArray[4] = string4 == null ? null : string4.getBytes();
                    byArrayArray[5] = string5 == null ? null : string5.getBytes();
                    string8 = resultSet.getString("Name");
                    if (string8.compareTo(string6) != 0) continue;
                    byArrayArray[6] = string8.getBytes();
                    byArrayArray[7] = this.s2b(stringTokenizer2.nextToken());
                    string8 = stringTokenizer2.nextToken();
                    byArrayArray[0] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[1] = string2 == null ? null : string2.getBytes();
                    string8 = stringTokenizer2.nextToken();
                    if (string8.compareTo(string3) != 0) continue;
                    byArrayArray[2] = this.s2b(string3);
                    byArrayArray[3] = this.s2b(stringTokenizer2.nextToken());
                    byArrayArray[8] = Integer.toString(n).getBytes();
                    byArrayArray[9] = Integer.toString(4).getBytes();
                    byArrayArray[10] = Integer.toString(4).getBytes();
                    byArrayArray[11] = null;
                    byArrayArray[12] = null;
                    byArrayArray[13] = Integer.toString(7).getBytes();
                    vector.addElement(byArrayArray);
                    ++n;
                }
            }
            return this.buildResultSet(fieldArray, vector, this._conn);
        }
        return this.buildResultSet(fieldArray, new Vector(), this._conn);
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Field[] fieldArray = new Field[]{new Field("", "TYPE_NAME", 1, 32), new Field("", "DATA_TYPE", 5, 5), new Field("", "PRECISION", 4, 10), new Field("", "LITERAL_PREFIX", 1, 4), new Field("", "LITERAL_SUFFIX", 1, 4), new Field("", "CREATE_PARAMS", 1, 32), new Field("", "NULLABLE", 5, 5), new Field("", "CASE_SENSITIVE", 1, 3), new Field("", "SEARCHABLE", 5, 3), new Field("", "UNSIGNED_ATTRIBUTE", 1, 3), new Field("", "FIXED_PREC_SCALE", 1, 3), new Field("", "AUTO_INCREMENT", 1, 3), new Field("", "LOCAL_TYPE_NAME", 1, 32), new Field("", "MINIMUM_SCALE", 5, 5), new Field("", "MAXIMUM_SCALE", 5, 5), new Field("", "SQL_DATA_TYPE", 4, 10), new Field("", "SQL_DATETIME_SUB", 4, 10), new Field("", "NUM_PREC_RADIX", 4, 10)};
        byte[][] byArrayArray = null;
        Vector<byte[][]> vector = new Vector<byte[][]>();
        byArrayArray = new byte[][]{this.s2b("BIT"), Integer.toString(-7).getBytes(), this.s2b("1"), this.s2b(""), this.s2b(""), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BIT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("BOOL"), Integer.toString(-7).getBytes(), this.s2b("1"), this.s2b(""), this.s2b(""), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BOOL"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TINYINT"), Integer.toString(-6).getBytes(), this.s2b("3"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("TINYINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("BIGINT"), Integer.toString(-5).getBytes(), this.s2b("19"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("BIGINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("LONG VARBINARY"), Integer.toString(-4).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONG VARBINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("MEDIUMBLOB"), Integer.toString(-4).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("MEDIUMBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("LONGBLOB"), Integer.toString(-4).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONGBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("BLOB"), Integer.toString(-4).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TINYBLOB"), Integer.toString(-4).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TINYBLOB"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("VARBINARY"), Integer.toString(-3).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("VARBINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("BINARY"), Integer.toString(-2).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("true"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("BINARY"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("LONG VARCHAR"), Integer.toString(-1).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONG VARCHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("MEDIUMTEXT"), Integer.toString(-1).getBytes(), this.s2b("16777215"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("MEDIUMTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("LONGTEXT"), Integer.toString(-1).getBytes(), Integer.toString(Integer.MAX_VALUE).getBytes(), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("LONGTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TEXT"), Integer.toString(-1).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TINYTEXT"), Integer.toString(-1).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TINYTEXT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("CHAR"), Integer.toString(1).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("CHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("NUMERIC"), Integer.toString(2).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M[,D])] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("NUMERIC"), this.s2b("308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DECIMAL"), Integer.toString(3).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M[,D])] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DECIMAL"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("INTEGER"), Integer.toString(4).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("INTEGER"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("INT"), Integer.toString(4).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("INT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("MEDIUMINT"), Integer.toString(4).getBytes(), this.s2b("7"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("MEDIUMINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("SMALLINT"), Integer.toString(5).getBytes(), this.s2b("5"), this.s2b(""), this.s2b(""), this.s2b("[(M)] [UNSIGNED] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("true"), this.s2b("false"), this.s2b("true"), this.s2b("SMALLINT"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DOUBLE"), Integer.toString(6).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("FLOAT"), Integer.toString(7).getBytes(), this.s2b("10"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("FLOAT"), this.s2b("-38"), this.s2b("38"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DOUBLE"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DOUBLE PRECISION"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("DOUBLE PRECISION"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("REAL"), Integer.toString(8).getBytes(), this.s2b("17"), this.s2b(""), this.s2b(""), this.s2b("[(M,D)] [ZEROFILL]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("true"), this.s2b("REAL"), this.s2b("-308"), this.s2b("308"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("VARCHAR"), Integer.toString(12).getBytes(), this.s2b("255"), this.s2b("'"), this.s2b("'"), this.s2b("(M)"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("VARCHAR"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("ENUM"), Integer.toString(12).getBytes(), this.s2b("65535"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("ENUM"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("SET"), Integer.toString(12).getBytes(), this.s2b("64"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("SET"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DATE"), Integer.toString(91).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATE"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TIME"), Integer.toString(92).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIME"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("DATETIME"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b(""), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("DATETIME"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        byArrayArray = new byte[][]{this.s2b("TIMESTAMP"), Integer.toString(93).getBytes(), this.s2b("0"), this.s2b("'"), this.s2b("'"), this.s2b("[(M)]"), Integer.toString(1).getBytes(), this.s2b("false"), Integer.toString(3).getBytes(), this.s2b("false"), this.s2b("false"), this.s2b("false"), this.s2b("TIMESTAMP"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("0"), this.s2b("10")};
        vector.addElement(byArrayArray);
        return this.buildResultSet(fieldArray, vector, this._conn);
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        Object object;
        String string4 = "";
        if (string != null) {
            if (!string.equals("")) {
                string4 = " FROM " + this._quotedId + string + this._quotedId;
            }
        } else {
            string4 = " FROM " + this._quotedId + this._database + this._quotedId;
        }
        ResultSet resultSet = this._conn.execSQL("SHOW INDEX FROM " + string3 + string4, -1);
        resultSet.setConnection(this._conn);
        Field[] fieldArray = new Field[]{new Field("", "TABLE_CAT", 1, 255), new Field("", "TABLE_SCHEM", 1, 0), new Field("", "TABLE_NAME", 1, 255), new Field("", "NON_UNIQUE", 1, 3), new Field("", "INDEX_QUALIFIER", 1, 1), new Field("", "INDEX_NAME", 1, 32), new Field("", "TYPE", 1, 32), new Field("", "ORDINAL_POSITION", 5, 5), new Field("", "COLUMN_NAME", 1, 32), new Field("", "ASC_OR_DESC", 1, 1), new Field("", "CARDINALITY", 1, 32), new Field("", "PAGES", 4, 10), new Field("", "FILTER_CONDITION", 1, 32)};
        Vector<byte[][]> vector = new Vector<byte[][]>();
        while (resultSet.next()) {
            object = new byte[14][];
            object[0] = string == null ? new byte[]{} : string.getBytes();
            object[1] = new byte[0];
            object[2] = resultSet.getBytes("Table");
            object[3] = resultSet.getInt("Non_unique") != 0 ? this.s2b("true") : this.s2b("false");
            object[4] = new byte[0];
            object[5] = resultSet.getBytes("Key_name");
            object[6] = Integer.toString(3).getBytes();
            object[7] = resultSet.getBytes("Seq_in_index");
            object[8] = resultSet.getBytes("Column_name");
            object[9] = resultSet.getBytes("Collation");
            object[10] = resultSet.getBytes("Cardinality");
            object[11] = this.s2b("0");
            object[12] = null;
            vector.addElement((byte[][])object);
        }
        object = this.buildResultSet(fieldArray, vector, this._conn);
        return object;
    }

    private byte[] s2b(String string) {
        return string.getBytes();
    }

    protected abstract java.sql.ResultSet buildResultSet(Field[] var1, Vector var2, Connection var3);
}

