/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.cache;

import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.Deployer;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.cache.DeploymentCacheMBean;
import org.jboss.deployment.cache.DeploymentStore;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanProxyInstance;
import org.jboss.system.MissingAttributeException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.NullArgumentException;

public class DeploymentCache
extends ServiceMBeanSupport
implements Deployer,
DeploymentCacheMBean {
    protected Deployer deployer;
    protected DeploymentStore store;

    public void setDeployer(ObjectName deployerName) {
        if (deployerName == null) {
            throw new NullArgumentException("deployerName");
        }
        this.deployer = (Deployer)MBeanProxyExt.create((Class)Deployer.class, (ObjectName)deployerName, (MBeanServer)this.server);
    }

    public ObjectName getDeployer() {
        return ((MBeanProxyInstance)this.deployer).getMBeanProxyObjectName();
    }

    public void setStore(ObjectName storeName) {
        if (storeName == null) {
            throw new NullArgumentException("storeName");
        }
        this.store = (DeploymentStore)MBeanProxyExt.create((Class)DeploymentStore.class, (ObjectName)storeName, (MBeanServer)this.server);
    }

    public ObjectName getStore() {
        return ((MBeanProxyInstance)this.store).getMBeanProxyObjectName();
    }

    protected boolean isInvalid(URL orig, URL stored) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        long omod = orig.openConnection().getLastModified();
        long smod = stored.openConnection().getLastModified();
        if (trace) {
            this.log.trace((Object)("Modfication times (orig, stored): " + omod + ", " + smod));
        }
        return omod > smod;
    }

    public void deploy(URL url) throws DeploymentException {
        try {
            URL storedURL = this.store.get(url);
            if (storedURL != null) {
                if (this.isInvalid(url, storedURL)) {
                    this.log.info((Object)("Cached deployment is invalid; refreshing store for URL: " + url));
                    storedURL = this.store.put(url);
                } else {
                    this.log.debug((Object)("Using cached deployment URL: " + storedURL));
                }
            } else {
                this.log.info((Object)("Deployment not in cache; adding URL to store: " + url));
                storedURL = this.store.put(url);
            }
            this.deployer.deploy(storedURL);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public void undeploy(URL url) throws DeploymentException {
        try {
            URL storedURL = this.store.get(url);
            if (storedURL != null) {
                this.deployer.undeploy(storedURL);
            } else {
                this.log.debug((Object)("Not found in store; ignoring URL: " + url));
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public boolean isDeployed(URL url) {
        try {
            URL storedURL = this.store.get(url);
            return storedURL != null && this.deployer.isDeployed(url);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
        if (this.deployer == null) {
            throw new MissingAttributeException("Deployer");
        }
        if (this.store == null) {
            throw new MissingAttributeException("Store");
        }
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
        this.deployer = null;
        this.store = null;
    }
}

