/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.GifRenderer;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.Java2Dresource;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceRenderer;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.HtmlColor;
import org.ajax4jsf.framework.util.HtmlDimensions;
import org.richfaces.component.UISeparator;

public class BevelSeparatorImage
extends Java2Dresource {
    public BevelSeparatorImage() {
        this.setRenderer((ResourceRenderer)new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return this.calculateDimensions(this.getDataToStore(facesContext, data));
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.calculateDimensions(this.restoreData(resourceContext));
    }

    protected Dimension calculateDimensions(Object data) {
        return new Dimension(1, ((SeparatorData)data).getHeight());
    }

    protected void paint(ResourceContext context, Graphics2D g2d) {
        SeparatorData stored = (SeparatorData)this.restoreData(context);
        Color bg = new Color(stored.getBgColor());
        Color grad = new Color(stored.getGradColor());
        float[] grads = grad.getRGBComponents(null);
        int level3D = stored.getLevel3D();
        Dimension dim = this.calculateDimensions(stored);
        float height = (float)dim.getHeight();
        float width = (float)dim.getWidth();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, width, height);
        g2d.setColor(bg);
        g2d.fill(rect);
        if (level3D > 0) {
            g2d.translate(0.0, (double)height / 18.0);
            float verticalOpacity = (float)(level3D + 1) * 0.1f;
            if (verticalOpacity < 0.0f) {
                verticalOpacity = 0.0f;
            } else if (verticalOpacity > 1.0f) {
                verticalOpacity = 1.0f;
            }
            g2d.setPaint(new GradientPaint(width / 2.0f, 0.0f, new Color(grads[0], grads[1], grads[2], verticalOpacity), width / 2.0f, height / 2.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f)));
            g2d.fill(rect);
            verticalOpacity = (float)(level3D - 1) * 0.1f;
            if (verticalOpacity < 0.0f) {
                verticalOpacity = 0.0f;
            } else if (verticalOpacity > 1.0f) {
                verticalOpacity = 1.0f;
            }
            g2d.setPaint(new GradientPaint(width / 2.0f, height / 2.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), width / 2.0f, height * 0.75f, new Color(grads[0], grads[1], grads[2], verticalOpacity), true));
            Shape currentClip = g2d.getClip();
            Rectangle2D.Double clipRect = new Rectangle2D.Double(0.0, height / 2.0f, width * 2.0f, height);
            g2d.setClip(clipRect);
            g2d.fill(rect);
            g2d.setClip(currentClip);
        }
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        SeparatorData separatorData = new SeparatorData();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        String tmp = ((UISeparator)((Object)data)).getHeight();
        separatorData.setHeight(HtmlDimensions.decode((String)(tmp == null ? "6" : tmp)).intValue());
        tmp = (String)skin.getParameter(context, "interfaceLevel3D");
        separatorData.setLevel3D(HtmlDimensions.decode((String)(tmp == null ? "5" : tmp)).intValue());
        tmp = (String)skin.getParameter(context, "headerBackgroundColor");
        separatorData.setBgColor(HtmlColor.decode((String)(tmp == null ? "#4169E1" : tmp)).getRGB());
        tmp = (String)skin.getParameter(context, "overAllBackground");
        separatorData.setGradColor(HtmlColor.decode((String)(tmp == null ? "#FFFFFF" : tmp)).getRGB());
        return separatorData;
    }

    protected static class SeparatorData
    implements Serializable {
        private static final long serialVersionUID = -6368074056069548706L;
        private int height;
        private int level3D;
        private int bgColor;
        private int gradColor;

        protected SeparatorData() {
        }

        public int getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(int bgColor) {
            this.bgColor = bgColor;
        }

        public int getGradColor() {
            return this.gradColor;
        }

        public void setGradColor(int gradColor) {
            this.gradColor = gradColor;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getLevel3D() {
            return this.level3D;
        }

        public void setLevel3D(int level3D) {
            this.level3D = level3D;
        }
    }
}

