/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.ajax.repeat.Range;
import org.richfaces.component.LastElementAware;
import org.richfaces.component.TreeDataModel;
import org.richfaces.component.TreeNode;
import org.richfaces.component.TreeNodeImpl;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.state.TreeRange;

public class CacheableTreeDataModel
extends TreeDataModel
implements StateHolder {
    private TreeDataModel treeDataModel;

    public boolean isLeaf() {
        TreeRowKey rowKey = (TreeRowKey)this.getRowKey();
        TreeNode treeNode = this.locateTreeNode(rowKey);
        if (treeNode != null && !treeNode.isLeaf()) {
            return false;
        }
        treeNode = this.treeDataModel.locateTreeNode(rowKey);
        if (treeNode != null) {
            return treeNode.isLeaf();
        }
        return false;
    }

    public CacheableTreeDataModel(TreeDataModel model) {
        this.setWrappedData(new TreeNodeImpl());
        this.setTreeDataModel(model);
    }

    public void walkModel(FacesContext context, DataVisitor visitor, TreeRange range, TreeRowKey key, Object argument, boolean last) throws IOException {
        this.treeDataModel.walkModel(context, new Visitor(visitor), range, key, argument, last);
    }

    public void setTreeDataModel(TreeDataModel treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    public TreeDataModel getTreeDataModel() {
        return this.treeDataModel;
    }

    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, TreeRowKey rowKey, Object argument, boolean last) throws IOException {
        TreeNode cachedTreeNode = this.locateTreeNode(rowKey);
        TreeNode treeNode = this.treeDataModel.locateTreeNode(rowKey);
        if (treeNode != null) {
            if (cachedTreeNode == null || cachedTreeNode.isLeaf() && !treeNode.isLeaf()) {
                this.treeDataModel.walk(context, new Visitor(dataVisitor), range, rowKey, argument, last);
            } else {
                super.walk(context, dataVisitor, range, rowKey, argument, last);
            }
        }
    }

    public void setRowData(Object object) {
        this.locateTreeNode((TreeRowKey)this.getRowKey()).setData(object);
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.setWrappedData(_state[0]);
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.getWrappedData()};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        if (newTransientValue) {
            throw new IllegalArgumentException("ReplaceableTreeDataModel shouldn't be transient!");
        }
    }

    public void resetSub(TreeRowKey key) {
        TreeNode node = this.locateTreeNode(key);
        Iterator iterator = node.getChildren();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    private final class Visitor
    implements DataVisitor,
    LastElementAware {
        private final DataVisitor visitor;

        private Visitor(DataVisitor visitor) {
            this.visitor = visitor;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            TreeRowKey treeRowKey = (TreeRowKey)rowKey;
            CacheableTreeDataModel.this.treeDataModel.setRowKey(treeRowKey);
            CacheableTreeDataModel.this.locateTreeNode(treeRowKey, true).setData(CacheableTreeDataModel.this.treeDataModel.getRowData());
            if (this.visitor != null) {
                this.visitor.process(context, rowKey, argument);
            }
        }

        public void resetLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).resetLastElement();
            }
        }

        public void setLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).setLastElement();
            }
        }
    }
}

