/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.util;

import com.icesoft.faces.component.util.UserRoleAware;
import com.icesoft.faces.renderkit.dom_html_basic.FormRenderer;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.PropertyNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomComponentUtils {
    private static final String HIDDEN_COMMAND_INPUTS_SET_ATTR = FormRenderer.class.getName() + ".HIDDEN_COMMAND_INPUTS_SET";
    public static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_link_hidden_";
    public static final String FOOTER_CLASS_ATTR = "footerClass";
    public static final String HEADER_CLASS_ATTR = "headerClass";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EMPTY_STRING = new String();
    private static final String HIDDEN_TREE_NAV_FIELD_NAME = "_idtn";
    private static final String HIDDEN_TREE_ACTION_FIELD_NAME = "_idta";
    private static final Log log = LogFactory.getLog((Class)CustomComponentUtils.class);

    public static void restoreAncestorState(UIComponent uiComponent) {
        uiComponent.setId(uiComponent.getId());
        uiComponent = uiComponent.getParent();
        if (uiComponent != null) {
            CustomComponentUtils.restoreAncestorState(uiComponent);
        }
    }

    public static void restoreDescendentState(UIComponent uiComponent) {
        uiComponent.setId(uiComponent.getId());
        Iterator it = uiComponent.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent next = (UIComponent)it.next();
            CustomComponentUtils.restoreDescendentState(next);
        }
    }

    public static String getStringValue(FacesContext facesContext, UIComponent component) {
        try {
            Object submittedValue;
            if (!(component instanceof ValueHolder)) {
                throw new IllegalArgumentException("Component : " + CustomComponentUtils.getPathToComponent(component) + "is not a ValueHolder");
            }
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                if (submittedValue instanceof String) {
                    return (String)submittedValue;
                }
                throw new IllegalArgumentException("Expected submitted value of type String for component : " + CustomComponentUtils.getPathToComponent(component));
            }
            Object value = ((ValueHolder)component).getValue();
            Converter converter = ((ValueHolder)component).getConverter();
            if (converter == null && value != null) {
                if (value instanceof String) {
                    return (String)value;
                }
                try {
                    converter = facesContext.getApplication().createConverter(value.getClass());
                }
                catch (FacesException e) {
                    log.error((Object)("No converter for class " + value.getClass().getName() + " found (component id=" + component.getId() + ")."), (Throwable)e);
                }
            }
            if (converter == null) {
                if (value == null) {
                    return "";
                }
                return value.toString();
            }
            return converter.getAsString(facesContext, component, value);
        }
        catch (PropertyNotFoundException ex) {
            log.error((Object)("Property not found - called by component : " + CustomComponentUtils.getPathToComponent(component)), (Throwable)ex);
            throw ex;
        }
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        CustomComponentUtils.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, (Object)intBuf);
        if (component != null) {
            CustomComponentUtils.getPathToComponent(component.getParent(), buf);
        }
    }

    public static void addHiddenCommandParameter(UIComponent form, String paramName) {
        HashSet<String> set = (HashSet<String>)form.getAttributes().get(HIDDEN_COMMAND_INPUTS_SET_ATTR);
        if (set == null) {
            set = new HashSet<String>();
            form.getAttributes().put(HIDDEN_COMMAND_INPUTS_SET_ATTR, set);
        }
        set.add(paramName);
    }

    public static String getHiddenCommandLinkFieldName(String formName) {
        return formName + ':' + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    public static String getHiddenTreeExpandFieldName(String componentId, String formName) {
        return formName + ':' + componentId + HIDDEN_TREE_NAV_FIELD_NAME;
    }

    public static String getHiddenTreeActionFieldName(String componentId, String formName) {
        return formName + ':' + componentId + HIDDEN_TREE_ACTION_FIELD_NAME;
    }

    public static String getFormName(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((UIForm)parent).getClientId(context);
        }
        return "this";
    }

    public static String[] splitShortString(String str, char separator) {
        int len;
        if (str == null || (len = str.length()) == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int lastTokenIndex = 0;
        int pos = str.indexOf(separator);
        while (pos >= 0) {
            ++lastTokenIndex;
            pos = str.indexOf(separator, pos + 1);
        }
        String[] list = new String[lastTokenIndex + 1];
        int oldPos = 0;
        int pos2 = str.indexOf(separator);
        int i = 0;
        while (pos2 >= 0) {
            list[i++] = CustomComponentUtils.substring(str, oldPos, pos2);
            oldPos = pos2 + 1;
            pos2 = str.indexOf(separator, oldPos);
        }
        list[lastTokenIndex] = CustomComponentUtils.substring(str, oldPos, len);
        return list;
    }

    public static String substring(String str, int begin, int end) {
        if (begin == end) {
            return "";
        }
        return str.substring(begin, end);
    }

    public static String[] trim(String[] strings) {
        if (strings == null) {
            return null;
        }
        int len = strings.length;
        for (int i = 0; i < len; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static void renderChildren(FacesContext facesContext, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            Iterator it = component.getChildren().iterator();
            while (it.hasNext()) {
                UIComponent child = (UIComponent)it.next();
                CustomComponentUtils.renderChild(facesContext, child);
            }
        }
    }

    public static void renderChild(FacesContext facesContext, UIComponent child) throws IOException {
        if (!child.isRendered()) {
            return;
        }
        child.encodeBegin(facesContext);
        if (child.getRendersChildren()) {
            child.encodeChildren(facesContext);
        } else {
            CustomComponentUtils.renderChildren(facesContext, child);
        }
        child.encodeEnd(facesContext);
    }

    public static boolean isVisibleOnUserRole(UIComponent component) {
        String userRole = component instanceof UserRoleAware ? ((UserRoleAware)component).getVisibleOnUserRole() : (String)component.getAttributes().get("visibleOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnabledOnUserRole(UIComponent component) {
        String userRole = component instanceof UserRoleAware ? ((UserRoleAware)component).getEnabledOnUserRole() : (String)component.getAttributes().get("enabledOnUserRole");
        if (userRole == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        StringTokenizer st = new StringTokenizer(userRole, ",");
        while (st.hasMoreTokens()) {
            if (!facesContext.getExternalContext().isUserInRole(st.nextToken().trim())) continue;
            return true;
        }
        return false;
    }

    public static Object newInstance(Class clazz) throws FacesException {
        try {
            return clazz.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new FacesException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static Class simpleClassForName(String type) {
        try {
            return CustomComponentUtils.classForName(type);
        }
        catch (ClassNotFoundException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static Object newInstance(String type) throws FacesException {
        if (type == null) {
            return null;
        }
        return CustomComponentUtils.newInstance(CustomComponentUtils.simpleClassForName(type));
    }

    public static Class classForName(String type) throws ClassNotFoundException {
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            return Class.forName(type, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ignore) {
            return Class.forName(type, false, CustomComponentUtils.class.getClassLoader());
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return CustomComponentUtils.isTrue(component.getAttributes().get("disabled")) || CustomComponentUtils.isTrue(component.getAttributes().get("readOnly"));
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else if (!CustomComponentUtils.isDisabledOrReadOnly(component)) {
            ((EditableValueHolder)component).setSubmittedValue((Object)EMPTY_STRING);
        }
    }

    public static Date getDateValue(UIComponent component) {
        Object submittedValue;
        if (!(component instanceof ValueHolder)) {
            throw new IllegalArgumentException("Component : " + CustomComponentUtils.getPathToComponent(component) + "is not a ValueHolder");
        }
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            if (submittedValue instanceof Date) {
                return (Date)submittedValue;
            }
            throw new IllegalArgumentException("Expected submitted value of type Date for component : " + CustomComponentUtils.getPathToComponent(component));
        }
        Object value = ((ValueHolder)component).getValue();
        if (value == null || value instanceof Date) {
            return (Date)value;
        }
        throw new IllegalArgumentException("Expected submitted value of type Date for component : " + CustomComponentUtils.getPathToComponent(component));
    }

    public static void copyHtmlInputTextAttributes(HtmlInputText src, HtmlInputText dest) {
        dest.setId(src.getId());
        dest.setImmediate(src.isImmediate());
        dest.setTransient(src.isTransient());
        dest.setAccesskey(src.getAccesskey());
        dest.setAlt(src.getAlt());
        dest.setConverter(src.getConverter());
        dest.setDir(src.getDir());
        dest.setDisabled(src.isDisabled());
        dest.setLang(src.getLang());
        dest.setLocalValueSet(src.isLocalValueSet());
        dest.setMaxlength(src.getMaxlength());
        dest.setOnblur(src.getOnblur());
        dest.setOnchange(src.getOnchange());
        dest.setOnclick(src.getOnclick());
        dest.setOndblclick(src.getOndblclick());
        dest.setOnfocus(src.getOnfocus());
        dest.setOnkeydown(src.getOnkeydown());
        dest.setOnkeypress(src.getOnkeypress());
        dest.setOnkeyup(src.getOnkeyup());
        dest.setOnmousedown(src.getOnmousedown());
        dest.setOnmousemove(src.getOnmousemove());
        dest.setOnmouseout(src.getOnmouseout());
        dest.setOnmouseover(src.getOnmouseover());
        dest.setOnmouseup(src.getOnmouseup());
        dest.setOnselect(src.getOnselect());
        dest.setReadonly(src.isReadonly());
        dest.setRendered(src.isRendered());
        dest.setRequired(src.isRequired());
        dest.setSize(src.getSize());
        dest.setStyle(src.getStyle());
        dest.setStyleClass(src.getStyleClass());
        dest.setTabindex(src.getTabindex());
        dest.setTitle(src.getTitle());
        dest.setValidator(src.getValidator());
    }
}

