/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.panelseries;

import [Ljava.lang.Object;;
import com.icesoft.faces.component.panelseries.ChildState;
import com.icesoft.faces.component.tree.TreeDataModel;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.component.html.HtmlForm;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.jstl.sql.Result;
import javax.swing.tree.TreeModel;

public class UISeries
extends HtmlDataTable {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.series";
    public static final String RENDERER_TYPE = "com.icesoft.faces.seriesRenderer";
    protected transient DataModel dataModel = null;
    private int rowIndex = -1;
    protected Map savedChildren = new HashMap();
    private String var = null;

    public UISeries() {
        this.setRendererType(RENDERER_TYPE);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        FacesContext facesContext = this.getFacesContext();
        this.saveChildrenState(facesContext);
        this.processCurrentRowData(facesContext, rowIndex);
        this.restoreChildrenState(facesContext);
    }

    private void processCurrentRowData(FacesContext facesContext, int rowIndex) {
        this.rowIndex = rowIndex;
        DataModel model = this.getDataModel();
        model.setRowIndex(rowIndex);
        if (this.var != null) {
            Map requestMap = facesContext.getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.loadRowToRequestMap(requestMap, false);
            } else if (this.isRowAvailable()) {
                this.loadRowToRequestMap(requestMap, true);
            } else {
                this.loadRowToRequestMap(requestMap, false);
            }
        }
    }

    private void loadRowToRequestMap(Map requestMap, boolean loadRow) {
        if (loadRow) {
            requestMap.put(this.var, this.getRowData());
        } else {
            requestMap.remove(this.var);
        }
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setValue(Object value) {
        this.dataModel = null;
        super.setValue(value);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if ("value".equals(name)) {
            this.dataModel = null;
        } else if ("var".equals(name) || "rowIndex".equals(name)) {
            throw new IllegalArgumentException();
        }
        super.setValueBinding(name, binding);
    }

    public String getClientId(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        String baseClientId = super.getClientId(context);
        if (this.getRowIndex() >= 0) {
            if (!baseClientId.endsWith(":" + this.getRowIndex())) {
                return baseClientId + ':' + this.getRowIndex();
            }
            return baseClientId;
        }
        return baseClientId;
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new RowEvent((UIComponent)this, event, this.getRowIndex()));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof RowEvent)) {
            super.broadcast(event);
            return;
        }
        ((RowEvent)event).broadcast();
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.dataModel = null;
        if (!this.keepSaved(context)) {
            this.savedChildren = new HashMap();
        }
        super.encodeBegin(context);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.dataModel = null;
        if (null == this.savedChildren || !this.keepSaved(context)) {
            this.savedChildren = new HashMap();
        }
        this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.isNestedWithinUIData()) {
            this.dataModel = null;
        }
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.isNestedWithinUIData()) {
            this.dataModel = null;
        }
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
    }

    private DataModel getDataModel() {
        if (null != this.dataModel) {
            return this.dataModel;
        }
        Object currentValue = this.getValue();
        this.dataModel = null == currentValue ? new ListDataModel(Collections.EMPTY_LIST) : (currentValue instanceof DataModel ? (DataModel)currentValue : (currentValue instanceof List ? new ListDataModel((List)currentValue) : (Object;.class.isAssignableFrom(currentValue.getClass()) ? new ArrayDataModel((Object[])currentValue) : (currentValue instanceof ResultSet ? new ResultSetDataModel((ResultSet)currentValue) : (currentValue instanceof Result ? new ResultDataModel((Result)currentValue) : (currentValue instanceof TreeModel ? new TreeDataModel((TreeModel)currentValue) : new ScalarDataModel(currentValue)))))));
        return this.dataModel;
    }

    protected void iterate(FacesContext facesContext, PhaseId phase) {
        this.setRowIndex(-1);
        int rowsProcessed = 0;
        int currentRowIndex = this.getFirst() - 1;
        int displayedRows = this.getRows();
        while (displayedRows <= 0 || ++rowsProcessed <= displayedRows) {
            this.setRowIndex(++currentRowIndex);
            if (!this.isRowAvailable()) break;
            Iterator children = this.getFacetsAndChildren();
            while (children.hasNext()) {
                UIComponent child = (UIComponent)children.next();
                if (phase == PhaseId.APPLY_REQUEST_VALUES) {
                    child.processDecodes(facesContext);
                    continue;
                }
                if (phase == PhaseId.PROCESS_VALIDATIONS) {
                    child.processValidators(facesContext);
                    continue;
                }
                if (phase == PhaseId.UPDATE_MODEL_VALUES) {
                    child.processUpdates(facesContext);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        this.setRowIndex(-1);
    }

    private boolean keepSaved(FacesContext facesContext) {
        Iterator childIds = this.savedChildren.keySet().iterator();
        while (childIds.hasNext()) {
            String childId = (String)childIds.next();
            Iterator childMessages = facesContext.getMessages(childId);
            while (childMessages.hasNext()) {
                FacesMessage childMessage = (FacesMessage)childMessages.next();
                if (childMessage.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) < 0) continue;
                return true;
            }
        }
        return this.isNestedWithinUIData();
    }

    private boolean isNestedWithinUIData() {
        UISeries parent = this;
        while (null != (parent = parent.getParent())) {
            if (!(parent instanceof UIData)) continue;
            return true;
        }
        return false;
    }

    protected void restoreChildrenState(FacesContext facesContext) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            this.restoreChildState(facesContext, child);
        }
    }

    protected void restoreChildState(FacesContext facesContext, UIComponent component) {
        String id = component.getId();
        if (!this.isValid(id)) {
            return;
        }
        component.setId(id);
        this.restoreChild(facesContext, component);
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            this.restoreChildState(facesContext, (UIComponent)children.next());
        }
    }

    protected void saveChild(FacesContext facesContext, UIComponent component) {
        String clientId;
        Boolean isThisFormSubmitted;
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId2 = component.getClientId(facesContext);
            ChildState state = (ChildState)this.savedChildren.get(clientId2);
            if (state == null) {
                state = new ChildState();
                this.savedChildren.put(clientId2, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        } else if (component instanceof HtmlForm && (isThisFormSubmitted = (Boolean)this.savedChildren.get(clientId = component.getClientId(facesContext))) == null) {
            isThisFormSubmitted = new Boolean(((HtmlForm)component).isSubmitted());
            this.savedChildren.put(clientId, isThisFormSubmitted);
        }
    }

    protected void restoreChild(FacesContext facesContext, UIComponent component) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(facesContext);
            ChildState state = (ChildState)this.savedChildren.get(clientId);
            if (state == null) {
                state = new ChildState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        } else if (component instanceof HtmlForm) {
            String clientId = component.getClientId(facesContext);
            Boolean isThisFormSubmitted = (Boolean)this.savedChildren.get(clientId);
            if (isThisFormSubmitted == null) {
                isThisFormSubmitted = Boolean.FALSE;
            }
            ((HtmlForm)component).setSubmitted(isThisFormSubmitted.booleanValue());
        }
    }

    protected void saveChildrenState(FacesContext facesContext) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            this.saveChildState(facesContext, child);
        }
    }

    protected void saveChildState(FacesContext facesContext, UIComponent component) {
        this.saveChild(facesContext, component);
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            this.saveChildState(facesContext, (UIComponent)children.next());
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), new Integer(this.rowIndex), this.savedChildren, this.var};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.rowIndex = (Integer)values[1];
        this.savedChildren = (Map)values[2];
        this.var = (String)values[3];
    }

    private boolean isValid(String id) {
        if (id == null) {
            return false;
        }
        return Character.isLetter(id.charAt(0)) || id.charAt(0) == '_';
    }

    class RowEvent
    extends FacesEvent {
        private FacesEvent event;
        private int eventRowIndex;

        public RowEvent(UIComponent component, FacesEvent event, int eventRowIndex) {
            super(component);
            this.event = null;
            this.eventRowIndex = -1;
            this.event = event;
            this.eventRowIndex = eventRowIndex;
        }

        public FacesEvent getFacesEvent() {
            return this.event;
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return false;
        }

        public void processListener(FacesListener listener) {
            throw new IllegalStateException();
        }

        public PhaseId getPhaseId() {
            return this.event.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.event.setPhaseId(phaseId);
        }

        public void broadcast() {
            int oldRowIndex = UISeries.this.getRowIndex();
            UISeries.this.setRowIndex(this.eventRowIndex);
            this.event.getComponent().broadcast(this.event);
            UISeries.this.setRowIndex(oldRowIndex);
        }
    }
}

