/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.InputFile;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpSession;

public class ProgressOutputStream
extends OutputStream
implements Runnable {
    OutputStream originalStream = null;
    InputFile inputFile = null;
    boolean saved = false;
    double bytesWritten = -1.0;
    double requestSize = -1.0;
    private HttpSession session = null;

    public ProgressOutputStream(OutputStream out, InputFile inputFile, int requestSize, HttpSession session) {
        this.originalStream = out;
        this.inputFile = inputFile;
        this.requestSize = requestSize / 1024;
        this.session = session;
        new Thread((Runnable)this, "fileupload").start();
    }

    public void write(int b) throws IOException {
        this.originalStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.originalStream.write(b, off, len);
        this.bytesWritten += (double)len;
    }

    boolean isSaved() {
        return this.saved;
    }

    void setSaved(boolean saved) {
        this.saved = saved;
        if (saved) {
            this.inputFile.getFileInfo().setPercent(100);
            this.inputFile.fireEvent();
        }
    }

    public void run() {
        while (!this.isSaved()) {
            this.session.getId();
            int percent = (int)Math.abs(this.bytesWritten / 1024.0 / this.requestSize * 100.0);
            this.inputFile.getFileInfo().setPercent(percent);
            this.inputFile.setStatus(1);
            this.inputFile.fireEvent();
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

