/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.inputfile.InputFile;
import com.icesoft.faces.component.inputfile.ProgressOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MultipartStream;

public class DiskFileUpload
extends org.apache.commons.fileupload.DiskFileUpload {
    InputFile inputFile = null;
    HttpSession session = null;
    String fileName = null;
    private static Logger log = Logger.getLogger(DiskFileUpload.class.getName());

    DiskFileUpload(HttpSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List parseRequest(HttpServletRequest req) throws FileUploadException {
        if (null == req) {
            throw new NullPointerException("req parameter");
        }
        if (this.inputFile != null) {
            this.inputFile.setStatus(0);
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = req.getHeader("Content-type");
        if (null == contentType || !contentType.startsWith("multipart/")) {
            throw new FileUploadBase.InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = req.getContentLength();
        ProgressOutputStream pos = null;
        try {
            int boundaryIndex = contentType.indexOf("boundary=");
            if (boundaryIndex < 0) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            byte[] boundary = contentType.substring(boundaryIndex + 9).getBytes();
            ServletInputStream input = req.getInputStream();
            MultipartStream multi = new MultipartStream((InputStream)input, boundary);
            multi.setHeaderEncoding(this.getHeaderEncoding());
            boolean nextPart = multi.skipPreamble();
            while (nextPart) {
                Map headers = this.parseHeaders(multi.readHeaders());
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    FileUploadException exception;
                    FileItem item;
                    String subContentType = this.getHeader(headers, "Content-type");
                    if (subContentType != null && subContentType.startsWith("multipart/mixed")) {
                        byte[] subBoundary = subContentType.substring(subContentType.indexOf("boundary=") + 9).getBytes();
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders());
                            if (this.getFileName(headers) != null) {
                                FileItem item2 = this.createItem(headers, false);
                                OutputStream os = item2.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else if (this.getFileName(headers) != null) {
                        item = this.createItem(headers, false);
                        OutputStream os = item.getOutputStream();
                        pos = new ProgressOutputStream(os, this.inputFile, requestSize, this.session);
                        try {
                            multi.readBodyData((OutputStream)pos);
                        }
                        finally {
                            os.close();
                        }
                        items.add(item);
                        this.inputFile.getFileInfo().setSize(item.getSize());
                        if (item.getSize() == 0L) {
                            this.inputFile.setStatus(3);
                            this.inputFile.getFileInfo().setFileName(this.getFileName());
                            exception = new FileUploadException("This is not a valid file");
                            this.inputFile.getFileInfo().setException((Exception)((Object)exception));
                            throw exception;
                        }
                        pos.setSaved(true);
                    } else {
                        item = this.createItem(headers, true);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                        if (item.getFieldName().equalsIgnoreCase("fileName")) {
                            this.fileName = item.getString();
                            nextPart = multi.readBoundary();
                            continue;
                        }
                        items.add(item);
                        this.registerCompoponent(item.getString());
                        if (this.inputFile == null) {
                            if (log.isLoggable(Level.WARNING)) {
                                log.warning("DiskFileUpload. The InputFile was null. Upload failed.");
                            }
                            throw new FileUploadException("File not found");
                        }
                        if (this.inputFile.getFileInfo() == null) {
                            throw new NullPointerException("Input File File Info is null");
                        }
                        this.inputFile.getFileInfo().reset();
                        if (this.getSizeMax() >= 0L && (long)requestSize > this.getSizeMax()) {
                            this.inputFile.setStatus(4);
                            exception = new FileUploadBase.SizeLimitExceededException("the request was rejected because it's size exceeds allowed range");
                            this.inputFile.getFileInfo().setFileName(this.getFileName());
                            this.inputFile.getFileInfo().setSize(requestSize);
                            this.inputFile.getFileInfo().setException((Exception)((Object)exception));
                            throw exception;
                        }
                        if (requestSize == -1) {
                            this.inputFile.setStatus(5);
                            exception = new FileUploadBase.UnknownSizeException("the request was rejected because it's size is unknown");
                            this.inputFile.getFileInfo().setFileName(this.getFileName());
                            this.inputFile.getFileInfo().setException((Exception)((Object)exception));
                            throw exception;
                        }
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage());
        }
        catch (FileUploadException fileExc) {
            throw fileExc;
        }
        finally {
            if (pos != null) {
                pos.setSaved(true);
            }
        }
        return items;
    }

    void registerCompoponent(String componentId) {
        if (this.session.getAttribute(componentId) != null) {
            this.inputFile = (InputFile)this.session.getAttribute(componentId);
            this.inputFile.fireEvent();
        }
    }

    InputFile getInputFile() {
        return this.inputFile;
    }

    void setInputFile(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    String getFileName() {
        if (this.fileName == null) {
            return this.fileName;
        }
        String FILE_SEPARATOR = System.getProperty("file.separator");
        int fileSeparatorIndex = this.fileName.lastIndexOf(FILE_SEPARATOR);
        if (fileSeparatorIndex < 0) {
            fileSeparatorIndex = this.fileName.lastIndexOf("\\");
        }
        if (fileSeparatorIndex > 0) {
            return this.fileName.substring(fileSeparatorIndex + 1);
        }
        return this.fileName;
    }
}

