/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext.renderkit;

import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.RowSelector;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.panelseries.UISeries;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableRenderer
extends com.icesoft.faces.renderkit.dom_html_basic.TableRenderer {
    private static final String SELECTED_ROWS = "sel_rows";

    public String getComponentStyleClass(UIComponent uiComponent) {
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (styleClass == null) {
            styleClass = "iceDataTblOutline";
        }
        return styleClass;
    }

    public String getHeaderClass(UIComponent component) {
        String headerClass = (String)component.getAttributes().get("headerClass");
        if (headerClass == null) {
            headerClass = "iceTblHeader";
        }
        return headerClass;
    }

    public String getFooterClass(UIComponent component) {
        String footerClass = (String)component.getAttributes().get("footerClass");
        if (footerClass == null) {
            footerClass = "iceTblFooter";
        }
        return footerClass;
    }

    public String[] getRowStyles(UIComponent uiComponent) {
        if (this.getRowStyleClasses(uiComponent).length <= 0) {
            String[] rowStyles = new String[]{"iceTblRow1", "iceTblRow2"};
            return rowStyles;
        }
        return this.getRowStyleClasses(uiComponent);
    }

    public void writeColStyles(String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, Element td, int colNumber) {
        if (columnStyles.length > 0) {
            if (columnStylesMaxIndex >= 0) {
                td.setAttribute("class", columnStyles[columnStyleIndex]);
            }
        } else {
            td.setAttribute("class", "column" + colNumber++);
        }
    }

    protected void renderFacet(FacesContext facesContext, UIComponent uiComponent, DOMContext domContext, boolean header) throws IOException {
        String facetClass;
        String element;
        String tag;
        String facet;
        if (header) {
            facet = "header";
            tag = "thead";
            element = "th";
            facetClass = this.getHeaderClass(uiComponent);
        } else {
            facet = "footer";
            tag = "tfoot";
            element = "td";
            facetClass = this.getFooterClass(uiComponent);
        }
        UISeries uiData = (UISeries)uiComponent;
        uiData.setRowIndex(-1);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            root = header ? (Element)root.getFirstChild().getFirstChild() : (Element)root.getChildNodes().item(1).getFirstChild();
        }
        UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)uiData, (String)facet);
        boolean childHeaderFacetExists = this.childColumnHasFacetWithName((UIComponent)uiData, facet);
        Element thead = null;
        if (headerFacet != null || childHeaderFacetExists) {
            thead = domContext.createElement(tag);
            root.appendChild(thead);
        }
        if (headerFacet != null && headerFacet.isRendered()) {
            this.resetFacetChildId(headerFacet);
            Element tr = domContext.createElement("tr");
            thead.appendChild(tr);
            Element th = domContext.createElement(element);
            tr.appendChild(th);
            if (facetClass != null) {
                th.setAttribute("class", facetClass);
            }
            th.setAttribute("colspan", String.valueOf(this.getNumberOfChildColumns((UIComponent)uiData)));
            th.setAttribute("scope", "colgroup");
            domContext.setCursorParent((Node)th);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)th);
            TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)headerFacet);
            if (this.isScrollable(uiComponent)) {
                tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
            }
        }
        StringTokenizer columnWitdths = this.getColumnWidths((UIComponent)uiData);
        if (childHeaderFacetExists) {
            Element tr = domContext.createElement("tr");
            thead.appendChild(tr);
            List childList = this.getRenderedChildColumnsList((UIComponent)uiData);
            Iterator childColumns = childList.iterator();
            String width = null;
            int columnIndex = 1;
            while (childColumns.hasNext()) {
                UIComponent nextColumn = (UIComponent)childColumns.next();
                width = columnWitdths != null && columnWitdths.hasMoreTokens() ? columnWitdths.nextToken() : null;
                if (nextColumn instanceof UIColumn) {
                    this.processUIColumnHeader(facesContext, uiComponent, (UIColumn)nextColumn, tr, domContext, facet, element, facetClass, width, columnIndex);
                    ++columnIndex;
                    continue;
                }
                if (!(nextColumn instanceof UIColumns)) continue;
                columnIndex = this.processUIColumnsHeader(facesContext, uiComponent, (UIColumns)nextColumn, tr, domContext, facet, element, facetClass, width, columnIndex);
            }
            if (header && this.isScrollable(uiComponent)) {
                tr.appendChild(this.scrollBarSpacer(domContext, facesContext));
            }
        }
        domContext.setCursorParent((Node)root);
    }

    private void processUIColumnHeader(FacesContext facesContext, UIComponent uiComponent, UIColumn nextColumn, Element tr, DOMContext domContext, String facet, String element, String facetClass, String width, int columnIndex) throws IOException {
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        Element th = domContext.createElement(element);
        tr.appendChild(th);
        if (facet.equalsIgnoreCase("header")) {
            facetClass = facetClass + " " + htmlDataTable.getHeaderClassAtIndex(columnIndex);
        }
        th.setAttribute("class", facetClass);
        if (width != null) {
            th.setAttribute("style", "width:" + width + ";overflow:hidden;");
        }
        th.setAttribute("colgroup", "col");
        UIComponent nextFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, (String)facet);
        if (nextFacet != null) {
            this.resetFacetChildId(nextFacet);
            domContext.setCursorParent((Node)th);
            domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)th);
            TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextFacet);
        }
    }

    private int processUIColumnsHeader(FacesContext facesContext, UIComponent uiComponent, UIColumns nextColumn, Element tr, DOMContext domContext, String facet, String element, String facetClass, String width, int columnIndex) throws IOException {
        HtmlDataTable htmlDataTable = (HtmlDataTable)uiComponent;
        int rowIndex = nextColumn.getFirst();
        nextColumn.setRowIndex(rowIndex);
        while (nextColumn.isRowAvailable()) {
            UIComponent headerFacet = TableRenderer.getFacetByName((UIComponent)nextColumn, (String)facet);
            if (headerFacet != null) {
                Node oldParent = domContext.getCursorParent();
                Element th = domContext.createElement(element);
                tr.appendChild(th);
                if (facet.equalsIgnoreCase("header")) {
                    th.setAttribute("class", facetClass + " " + htmlDataTable.getHeaderClassAtIndex(columnIndex));
                } else {
                    th.setAttribute("class", facetClass);
                }
                if (width != null) {
                    th.setAttribute("style", "width:" + width + ";");
                }
                th.setAttribute("colgroup", "col");
                domContext.setCursorParent((Node)th);
                domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)th);
                TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)headerFacet);
                domContext.setCursorParent(oldParent);
            }
            ++columnIndex;
            nextColumn.setRowIndex(++rowIndex);
        }
        nextColumn.setRowIndex(-1);
        return columnIndex;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element root = (Element)domContext.getRootNode();
        if (this.isScrollable(uiComponent)) {
            root = (Element)root.getChildNodes().item(1).getFirstChild();
        }
        DOMContext.removeChildrenByTagName((Element)root, (String)"tbody");
        Element tBody = domContext.createElement("tbody");
        root.appendChild(tBody);
        HtmlDataTable uiData = (HtmlDataTable)uiComponent;
        int rowIndex = uiData.getFirst();
        uiData.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiData.getRows();
        int countOfRowsDisplayed = 0;
        String[] rowStyles = this.getRowStyles(uiComponent);
        int rowStyleIndex = 0;
        int rowStylesMaxIndex = rowStyles.length - 1;
        RowSelector rowSelector = TableRenderer.getRowSelector(uiComponent);
        boolean rowSelectorFound = rowSelector != null;
        String rowSelectionFunctionName = null;
        if (rowSelectorFound) {
            Element rowSelectedField = domContext.createElement("input");
            String tableId = uiComponent.getClientId(facesContext);
            String id = TableRenderer.getSelectedRowParameterName(tableId);
            rowSelectedField.setAttribute("id", id);
            rowSelectedField.setAttribute("name", id);
            rowSelectedField.setAttribute("type", "hidden");
            root.appendChild(rowSelectedField);
            rowSelectionFunctionName = "ice_tableRowClicked" + this.rowSelectorNumber(facesContext);
            String scriptSrc = "this['" + rowSelectionFunctionName + "'] = function (id){\n";
            scriptSrc = scriptSrc + " var fld = $('" + id + "');fld.value = id;var nothingEvent = new Object();\n";
            scriptSrc = scriptSrc + " var form = Ice.util.findForm(fld);iceSubmit(null,fld,nothingEvent);};";
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)scriptSrc);
            Element scriptNode = domContext.createElement("script");
            scriptNode.setAttribute("language", "javascript");
            scriptNode.appendChild(domContext.createTextNode(scriptSrc));
            root.appendChild(scriptNode);
        }
        String[] columnStyles = this.getColumnStyleClasses(uiComponent);
        int columnStyleIndex = 0;
        int columnStylesMaxIndex = columnStyles.length - 1;
        while (uiData.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay)) {
            String selectedClass = null;
            Iterator childs = uiData.getChildren().iterator();
            Element tr = domContext.createElement("tr");
            if (rowSelectorFound) {
                tr.setAttribute("onclick", rowSelectionFunctionName + "('" + uiData.getRowIndex() + "');");
            }
            String id = uiComponent.getClientId(facesContext);
            tr.setAttribute("id", id);
            if (rowSelectorFound) {
                if (Boolean.TRUE.equals(rowSelector.getValue())) {
                    selectedClass = rowSelector.getSelectedClass() != null ? rowSelector.getSelectedClass() : "iceRowSelSelected";
                }
                String mouseOverClass = "iceRowSelMouseOver";
                if (rowSelector.getMouseOverClass() != null) {
                    mouseOverClass = rowSelector.getMouseOverClass();
                }
                StringTokenizer st = new StringTokenizer(mouseOverClass);
                StringBuffer omov = new StringBuffer();
                StringBuffer omot = new StringBuffer();
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    omov.append("Element.addClassName($('" + id + "'), '" + t + "');");
                    omot.append("Element.removeClassName($('" + id + "'), '" + t + "');");
                }
                tr.setAttribute("onmouseover", omov.toString());
                tr.setAttribute("onmouseout", omot.toString());
            }
            domContext.setCursorParent((Node)tBody);
            tBody.appendChild(tr);
            if (selectedClass != null) {
                tr.setAttribute("class", selectedClass);
            } else if (rowStylesMaxIndex >= 0) {
                tr.setAttribute("class", rowStyles[rowStyleIndex]);
            }
            if (rowStylesMaxIndex >= 0 && ++rowStyleIndex > rowStylesMaxIndex) {
                rowStyleIndex = 0;
            }
            int colNumber = 1;
            StringTokenizer columnWitdths = this.getColumnWidths((UIComponent)uiData);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (!nextChild.isRendered()) continue;
                if (nextChild instanceof UIColumn) {
                    Element td = domContext.createElement("td");
                    this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, colNumber++);
                    if (this.isScrollable(uiComponent) && columnWitdths != null && columnWitdths.hasMoreTokens()) {
                        String width = columnWitdths.nextToken();
                        td.setAttribute("style", "width:" + width + ";overflow:hidden;");
                    }
                    tr.appendChild(td);
                    if (++columnStyleIndex > columnStylesMaxIndex) {
                        columnStyleIndex = 0;
                    }
                    Node oldCursorParent = domContext.getCursorParent();
                    domContext.setCursorParent((Node)td);
                    domContext.streamWrite(facesContext, uiComponent, domContext.getRootNode(), (Node)td);
                    TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextChild);
                    domContext.setCursorParent(oldCursorParent);
                    continue;
                }
                if (!(nextChild instanceof UIColumns)) continue;
                String width = null;
                if (this.isScrollable(uiComponent) && columnWitdths != null && columnWitdths.hasMoreTokens()) {
                    width = columnWitdths.nextToken();
                }
                this.encodeColumns(facesContext, nextChild, domContext, tr, columnStyles, columnStylesMaxIndex, columnStyleIndex, colNumber, width);
                colNumber = uiData.getColNumber();
            }
            ++countOfRowsDisplayed;
            uiData.setRowIndex(++rowIndex);
        }
        uiData.setRowIndex(-1);
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void encodeColumns(FacesContext facesContext, UIComponent columns, DOMContext domContext, Node tr, String[] columnStyles, int columnStylesMaxIndex, int columnStyleIndex, int colNumber, String width) throws IOException {
        UIColumns uiList = (UIColumns)columns;
        int rowIndex = uiList.getFirst();
        uiList.setRowIndex(rowIndex);
        int numberOfRowsToDisplay = uiList.getRows();
        domContext.setCursorParent(tr);
        Node oldCursorParent = domContext.getCursorParent();
        for (int countOfRowsDisplayed = 0; uiList.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay); ++countOfRowsDisplayed) {
            Iterator childs = columns.getChildren().iterator();
            Element td = domContext.createElement("td");
            if (width != null) {
                td.setAttribute("style", "width:" + width + ";overfolw:hidden;");
            }
            domContext.setCursorParent(oldCursorParent);
            tr.appendChild(td);
            while (childs.hasNext()) {
                UIComponent nextChild = (UIComponent)childs.next();
                if (!nextChild.isRendered()) continue;
                domContext.setCursorParent((Node)td);
                this.writeColStyles(columnStyles, columnStylesMaxIndex, columnStyleIndex, td, colNumber++);
                if (++columnStyleIndex > columnStylesMaxIndex) {
                    columnStyleIndex = 0;
                }
                TableRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)nextChild);
                domContext.setCursorParent(oldCursorParent);
            }
            uiList.setRowIndex(++rowIndex);
        }
        ((HtmlDataTable)uiList.getParent()).setColNumber(colNumber);
        uiList.setRowIndex(-1);
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if ((!(kid instanceof UIColumn) || !kid.isRendered()) && !(kid instanceof UIColumns)) continue;
            results.add(kid);
        }
        return results;
    }

    protected boolean childColumnHasFacetWithName(UIComponent component, String facetName) {
        Iterator childColumns = this.getRenderedChildColumnsIterator(component);
        while (childColumns.hasNext()) {
            UIComponent nextChildColumn = (UIComponent)childColumns.next();
            if (TableRenderer.getFacetByName((UIComponent)nextChildColumn, (String)facetName) == null) continue;
            return true;
        }
        return false;
    }

    public static String getSelectedRowParameterName(String dataTableId) {
        int i = dataTableId.lastIndexOf(":");
        dataTableId = dataTableId.substring(0, i);
        return dataTableId + SELECTED_ROWS;
    }

    public static RowSelector getRowSelector(UIComponent comp) {
        if (comp instanceof RowSelector) {
            return (RowSelector)comp;
        }
        Iterator iter = comp.getChildren().iterator();
        while (iter.hasNext()) {
            RowSelector rs;
            UIComponent kid = (UIComponent)iter.next();
            if (kid instanceof HtmlDataTable || (rs = TableRenderer.getRowSelector(kid)) == null) continue;
            return rs;
        }
        return null;
    }

    private int rowSelectorNumber(FacesContext context) {
        Map m = context.getExternalContext().getRequestMap();
        String key = RowSelector.class.getName() + "-Selector";
        Integer I = (Integer)m.get(key);
        int i = 0;
        if (I != null) {
            i = I;
            ++i;
        }
        I = new Integer(i);
        m.put(key, I);
        return i;
    }
}

