/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJTask;
import org.apache.tools.ant.types.FileSet;

public class VAJImport
extends VAJTask {
    protected Vector filesets = new Vector();
    protected boolean importSources = true;
    protected boolean importResources = true;
    protected boolean importClasses = false;
    protected String importProject = null;
    protected boolean useDefaultExcludes = true;

    public void setProject(String projectName) {
        this.importProject = projectName;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setImportClasses(boolean importClasses) {
        this.importClasses = importClasses;
    }

    public void setImportResources(boolean importResources) {
        this.importResources = importResources;
    }

    public void setImportSources(boolean importSources) {
        this.importSources = importSources;
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void execute() throws BuildException {
        if (this.filesets.size() == 0) {
            throw new BuildException("At least one fileset is required!");
        }
        if (this.importProject == null || "".equals(this.importProject)) {
            throw new BuildException("The VisualAge for Java Project name is required!");
        }
        Enumeration e = this.filesets.elements();
        while (e.hasMoreElements()) {
            this.importFileset((FileSet)e.nextElement());
        }
    }

    protected void importFileset(FileSet fileset) {
        DirectoryScanner ds = fileset.getDirectoryScanner(this.project);
        if (ds.getIncludedFiles().length == 0) {
            return;
        }
        String[] includes = null;
        String[] excludes = null;
        try {
            Class<?> directoryScanner = ds.getClass();
            Field includesField = directoryScanner.getDeclaredField("includes");
            includesField.setAccessible(true);
            includes = (String[])includesField.get(ds);
            Field excludesField = directoryScanner.getDeclaredField("excludes");
            excludesField.setAccessible(true);
            excludes = (String[])excludesField.get(ds);
        }
        catch (NoSuchFieldException nsfe) {
            throw new BuildException("DirectoryScanner.includes or .excludes missing" + nsfe.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new BuildException("Access to DirectoryScanner.includes or .excludes not allowed");
        }
        this.getUtil().importFiles(this.importProject, ds.getBasedir(), includes, excludes, this.importClasses, this.importResources, this.importSources, this.useDefaultExcludes);
    }
}

