/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.util.Hashtable;
import org.apache.tools.ant.taskdefs.optional.ejb.GenericDeploymentTool;

public class JbossDeploymentTool
extends GenericDeploymentTool {
    protected static final String JBOSS_DD = "jboss.xml";
    protected static final String JBOSS_CMPD = "jaws.xml";
    private String jarSuffix = ".jar";

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
        File jbossDD = new File(this.getConfig().descriptorDir, ddPrefix + JBOSS_DD);
        if (!jbossDD.exists()) {
            this.log("Unable to locate jboss deployment descriptor. It was expected to be in " + jbossDD.getPath(), 1);
            return;
        }
        ejbFiles.put("META-INF/jboss.xml", jbossDD);
        File jbossCMPD = new File(this.getConfig().descriptorDir, ddPrefix + JBOSS_CMPD);
        if (jbossCMPD.exists()) {
            ejbFiles.put("META-INF/jaws.xml", jbossCMPD);
        }
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.getDestDir(), baseName + this.jarSuffix);
    }

    static {
        JBOSS_DD = JBOSS_DD;
        JBOSS_CMPD = JBOSS_CMPD;
    }
}

