/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import javax.management.JMException;
import javax.management.MBeanServer;
import org.jboss.logging.Logger;
import org.jboss.wsf.framework.management.DefaultEndpointRegistry;
import org.jboss.wsf.framework.management.ManagedEndpoint;
import org.jboss.wsf.framework.management.ManagedEndpointRegistryMBean;
import org.jboss.wsf.spi.deployment.Endpoint;

public class ManagedEndpointRegistry
extends DefaultEndpointRegistry
implements ManagedEndpointRegistryMBean {
    private static final Logger log = Logger.getLogger(ManagedEndpointRegistry.class);
    private MBeanServer mbeanServer;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public void register(Endpoint endpoint) {
        super.register(endpoint);
        try {
            ManagedEndpoint managedEndpoint = new ManagedEndpoint(endpoint);
            this.getMbeanServer().registerMBean(managedEndpoint, endpoint.getName());
        }
        catch (JMException jMException) {
            log.error((Object)"Cannot register endpoint with JMX server", (Throwable)jMException);
        }
    }

    public void unregister(Endpoint endpoint) {
        super.unregister(endpoint);
        try {
            this.getMbeanServer().unregisterMBean(endpoint.getName());
        }
        catch (JMException jMException) {
            log.error((Object)"Cannot unregister endpoint with JMX server", (Throwable)jMException);
        }
    }
}

