/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEndpointRegistry
implements EndpointRegistry {
    private static final Logger log = Logger.getLogger(DefaultEndpointRegistry.class);
    private Map<ObjectName, Endpoint> endpoints = new HashMap<ObjectName, Endpoint>();

    public Endpoint getEndpoint(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("Endpoint name cannot be null");
        }
        if (!this.isRegistered(objectName)) {
            throw new IllegalStateException("Endpoint not registered: " + objectName);
        }
        Endpoint endpoint = this.endpoints.get(objectName);
        return endpoint;
    }

    public Endpoint resolve(EndpointResolver endpointResolver) {
        return endpointResolver.query(this.endpoints.values().iterator());
    }

    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("Endpoint name cannot be null");
        }
        return this.endpoints.get(objectName) != null;
    }

    public Set<ObjectName> getEndpoints() {
        return this.endpoints.keySet();
    }

    public void register(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        ObjectName objectName = endpoint.getName();
        if (objectName == null) {
            throw new IllegalStateException("Endpoint name cannot be null for: " + endpoint);
        }
        if (this.isRegistered(objectName)) {
            throw new IllegalStateException("Endpoint already registered: " + objectName);
        }
        log.info((Object)("register: " + objectName));
        this.endpoints.put(objectName, endpoint);
    }

    public void unregister(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint cannot be null");
        }
        ObjectName objectName = endpoint.getName();
        if (!this.isRegistered(objectName)) {
            throw new IllegalStateException("Endpoint not registered: " + objectName);
        }
        log.info((Object)("remove: " + objectName));
        this.endpoints.remove(objectName);
    }
}

