/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.management;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Set;
import javax.management.ObjectName;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointMetrics;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class ContextServlet
extends HttpServlet {
    protected final Logger log = Logger.getLogger(ContextServlet.class);
    protected EndpointRegistry epRegistry;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        this.epRegistry = ((EndpointRegistryFactory)sPIProvider.getSPI(EndpointRegistryFactory.class)).getEndpointRegistry();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        httpServletResponse.setContentType("text/html");
        printWriter.print("<html>");
        this.setupHTMLResponseHeader(printWriter);
        URL uRL = new URL(httpServletRequest.getRequestURL().toString());
        printWriter.print("<body>");
        printWriter.print("<div class='pageHeader'>JBossWS/Services</div>");
        printWriter.print("<div class='pageSection'>");
        printWriter.print("<fieldset>");
        printWriter.print("<legend><b>Registered Service Endpoints</b></legend>");
        printWriter.print("<table>");
        Set set = this.epRegistry.getEndpoints();
        if (set.isEmpty()) {
            printWriter.print("<tr>");
            printWriter.print("\t<td><h3>There are currently no endpoints deployed</h3></td>");
            printWriter.print("</tr>");
        }
        for (ObjectName objectName : set) {
            Endpoint endpoint = this.epRegistry.getEndpoint(objectName);
            printWriter.print("<tr>");
            printWriter.print("\t<td>Endpoint Name</td>");
            printWriter.print("\t<td>" + endpoint.getName() + "</td>");
            printWriter.print("</tr>");
            printWriter.print("<tr>");
            printWriter.print("\t<td>Endpoint Address</td>");
            printWriter.print("\t<td><a href='" + endpoint.getAddress() + "?wsdl'>" + endpoint.getAddress() + "?wsdl</a></td>");
            printWriter.print("</tr>");
            printWriter.print("<tr>");
            printWriter.print("\t<td colspan=2>");
            printWriter.print("\t");
            printWriter.print("");
            EndpointMetrics endpointMetrics = endpoint.getEndpointMetrics();
            if (endpointMetrics != null) {
                printWriter.print("<table class='metrics'>");
                printWriter.print("<tr>");
                printWriter.print(" <td>StartTime</td>");
                printWriter.print(" <td>StopTime</td>");
                printWriter.print(" <td></td>");
                printWriter.print("</tr>");
                printWriter.print("<tr>");
                printWriter.print(" <td>" + endpointMetrics.getStartTime() + "</td>");
                String string = endpointMetrics.getStopTime() != null ? endpointMetrics.getStopTime().toString() : "";
                printWriter.print(" <td>" + string + "</td>");
                printWriter.print(" <td></td>");
                printWriter.print("</tr>");
                printWriter.print("<tr>");
                printWriter.print(" <td>RequestCount</td>");
                printWriter.print(" <td>ResponseCount</td>");
                printWriter.print(" <td>FaultCount</td>");
                printWriter.print("</tr>");
                printWriter.print("<tr>");
                printWriter.print(" <td>" + endpointMetrics.getRequestCount() + "</td>");
                printWriter.print(" <td>" + endpointMetrics.getResponseCount() + "</td>");
                printWriter.print(" <td>" + endpointMetrics.getFaultCount() + "</td>");
                printWriter.print("</tr>");
                printWriter.print("<tr>");
                printWriter.print(" <td>MinProcessingTime</td>");
                printWriter.print(" <td>MaxProcessingTime</td>");
                printWriter.print(" <td>AvgProcessingTime</td>");
                printWriter.print("</tr>");
                printWriter.print("<tr>");
                printWriter.print(" <td>" + endpointMetrics.getMinProcessingTime() + "</td>");
                printWriter.print(" <td>" + endpointMetrics.getMaxProcessingTime() + "</td>");
                printWriter.print(" <td>" + endpointMetrics.getAverageProcessingTime() + "</td>");
                printWriter.print("</tr>");
                printWriter.print("");
                printWriter.print("");
                printWriter.print("</table>");
                printWriter.print("");
            }
            printWriter.print("\t</td>");
            printWriter.print("</tr>");
            printWriter.print("<tr><td colspan='3'>&nbsp;</td></tr>");
        }
        printWriter.print("</table>");
        printWriter.print("");
        printWriter.print("</fieldset>");
        printWriter.print("</div>");
        printWriter.print("</body>");
        printWriter.print("</html>");
        printWriter.close();
    }

    private void setupHTMLResponseHeader(PrintWriter printWriter) {
        SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
        ServerConfig serverConfig = ((ServerConfigFactory)sPIProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
        printWriter.println("<head>");
        printWriter.println("<meta http-equiv='Content-Type content='text/html; charset=iso-8859-1'>");
        printWriter.println("<title>JBossWS / " + serverConfig.getImplementationVersion() + "</title>");
        printWriter.println("<link rel='stylesheet' href='./styles.css'>");
        printWriter.println("</head>");
    }
}

