/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.SecurityHandler;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;

public class WebAppGeneratorDeploymentAspect
extends DeploymentAspect {
    private SecurityHandler securityHandlerEJB21;
    private SecurityHandler securityHandlerEJB3;

    public void setSecurityHandlerEJB21(SecurityHandler securityHandler) {
        this.securityHandlerEJB21 = securityHandler;
    }

    public void setSecurityHandlerEJB3(SecurityHandler securityHandler) {
        this.securityHandlerEJB3 = securityHandler;
    }

    public void create(Deployment deployment) {
        String string = deployment.getType().toString();
        if (string.endsWith("EJB21")) {
            URL uRL = this.generatWebDeployment((ArchiveDeployment)deployment, this.securityHandlerEJB21);
            deployment.setProperty("org.jboss.ws.webapp.url", (Object)uRL);
        } else if (string.endsWith("EJB3")) {
            URL uRL = this.generatWebDeployment((ArchiveDeployment)deployment, this.securityHandlerEJB3);
            deployment.setProperty("org.jboss.ws.webapp.url", (Object)uRL);
        } else {
            URL uRL = this.generatWebDeployment((ArchiveDeployment)deployment, null);
            deployment.setProperty("org.jboss.ws.webapp.url", (Object)uRL);
        }
    }

    private URL generatWebDeployment(ArchiveDeployment archiveDeployment, SecurityHandler securityHandler) {
        Document document = this.createWebAppDescriptor((Deployment)archiveDeployment, securityHandler);
        Document document2 = this.createJBossWebAppDescriptor((Deployment)archiveDeployment, securityHandler);
        File file = null;
        try {
            SPIProvider sPIProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig serverConfig = ((ServerConfigFactory)sPIProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            File file2 = new File(serverConfig.getServerTempDir().getCanonicalPath() + "/deploy");
            String string = archiveDeployment.getCanonicalName().replace('/', '-');
            file = File.createTempFile(string, ".war", file2);
            file.delete();
            File file3 = new File(file, "WEB-INF");
            file3.mkdirs();
            File file4 = new File(file3, "web.xml");
            FileWriter fileWriter = new FileWriter(file4);
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            XMLWriter xMLWriter = new XMLWriter((Writer)fileWriter, outputFormat);
            xMLWriter.write(document);
            xMLWriter.close();
            File file5 = new File(file3, "jboss-web.xml");
            fileWriter = new FileWriter(file5);
            xMLWriter = new XMLWriter((Writer)fileWriter, outputFormat);
            xMLWriter.write(document2);
            xMLWriter.close();
            return file.toURL();
        }
        catch (IOException iOException) {
            throw new WSFDeploymentException("Failed to create webservice.war", (Throwable)iOException);
        }
    }

    private Document createWebAppDescriptor(Deployment deployment, SecurityHandler securityHandler) {
        Object object3;
        Object object22;
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("web-app");
        for (Object object22 : deployment.getService().getEndpoints()) {
            object3 = element.addElement("servlet");
            object3.addElement("servlet-name").addText(object22.getShortName());
            object3.addElement("servlet-class").addText(object22.getTargetBeanName());
        }
        ArrayList arrayList = new ArrayList();
        for (Object object3 : deployment.getService().getEndpoints()) {
            Element element2 = element.addElement("servlet-mapping");
            element2.addElement("servlet-name").addText(object3.getShortName());
            element2.addElement("url-pattern").addText(object3.getURLPattern());
        }
        object22 = null;
        for (Element element2 : deployment.getService().getEndpoints()) {
            Element element3;
            Element element4;
            Element element5;
            EJBArchiveMetaData eJBArchiveMetaData;
            String string = element2.getShortName();
            Boolean bl = null;
            String string2 = null;
            String string3 = null;
            WebContext webContext = element2.getTargetBeanClass().getAnnotation(WebContext.class);
            if (webContext != null) {
                if (webContext.authMethod().length() > 0) {
                    string3 = webContext.authMethod();
                }
                if (webContext.transportGuarantee().length() > 0) {
                    string2 = webContext.transportGuarantee();
                }
                if (webContext.secureWSDLAccess()) {
                    bl = webContext.secureWSDLAccess();
                }
            }
            if ((eJBArchiveMetaData = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class)) != null && eJBArchiveMetaData.getBeanByEjbName(string) != null && (element5 = (element4 = eJBArchiveMetaData.getBeanByEjbName(string)).getSecurityMetaData()) != null) {
                string3 = element5.getAuthMethod();
                string2 = element5.getTransportGuarantee();
                bl = element5.getSecureWSDLAccess();
            }
            if (string3 == null && string2 == null) continue;
            element4 = element.addElement("security-constraint");
            element5 = element4.addElement("web-resource-collection");
            element5.addElement("web-resource-name").addText(string);
            element5.addElement("url-pattern").addText(element2.getURLPattern());
            if (Boolean.TRUE.equals(bl)) {
                element5.addElement("http-method").addText("GET");
            }
            element5.addElement("http-method").addText("POST");
            if (string3 != null) {
                if (object22 == null) {
                    object22 = string3;
                }
                element3 = element4.addElement("auth-constraint").addElement("role-name").addText("*");
            }
            if (string2 == null) continue;
            element3 = element4.addElement("user-data-constraint");
            element3.addElement("transport-guarantee").addText(string2);
        }
        if (object22 != null && securityHandler != null) {
            object3 = element.addElement("login-config");
            object3.addElement("auth-method").addText((String)object22);
            object3.addElement("realm-name").addText("EJBServiceEndpointServlet Realm");
            securityHandler.addSecurityRoles(element, deployment);
        }
        return document;
    }

    private Document createJBossWebAppDescriptor(Deployment deployment, SecurityHandler securityHandler) {
        String string;
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("jboss-web");
        if (securityHandler != null) {
            securityHandler.addSecurityDomain(element, deployment);
        }
        if ((string = deployment.getService().getContextRoot()) == null) {
            throw new WSFDeploymentException("Cannot obtain context root");
        }
        element.addElement("context-root").addText(string);
        return document;
    }
}

