/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class URLPatternDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment deployment) {
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            String string = endpoint.getURLPattern();
            if (string != null) continue;
            string = this.getExplicitPattern(deployment, endpoint);
            if (string == null) {
                string = this.getImplicitPattern(deployment, endpoint);
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            endpoint.setURLPattern(string);
        }
    }

    protected String getExplicitPattern(Deployment deployment, Endpoint endpoint) {
        WebContext webContext;
        Class clazz;
        String string;
        String string2 = null;
        JSEArchiveMetaData jSEArchiveMetaData = (JSEArchiveMetaData)deployment.getAttachment(JSEArchiveMetaData.class);
        if (jSEArchiveMetaData != null) {
            string = endpoint.getShortName();
            string2 = (String)jSEArchiveMetaData.getServletMappings().get(string);
            if (string2 == null) {
                throw new IllegalStateException("Cannot obtain servlet mapping for: " + string);
            }
        }
        if ((string = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class)) != null && string.getBeanByEjbName(endpoint.getShortName()) != null) {
            clazz = string.getBeanByEjbName(endpoint.getShortName());
            string2 = clazz.getPortComponentURI();
        }
        if (string2 == null && (webContext = (clazz = endpoint.getTargetBeanClass()).getAnnotation(WebContext.class)) != null && webContext.urlPattern().length() > 0) {
            string2 = webContext.urlPattern();
        }
        return string2;
    }

    protected String getImplicitPattern(Deployment deployment, Endpoint endpoint) {
        String string = endpoint.getShortName();
        return string;
    }
}

