/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public class EndpointNameDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment deployment) {
        String string = deployment.getService().getContextRoot();
        if (string == null || !string.startsWith("/")) {
            throw new IllegalStateException("Context root expected to start with leading slash: " + string);
        }
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            EJBMetaData eJBMetaData;
            StringBuilder stringBuilder = new StringBuilder("jboss.ws:");
            stringBuilder.append("context=" + string.substring(1) + ",");
            stringBuilder.append("endpoint=" + endpoint.getShortName());
            EJBArchiveMetaData eJBArchiveMetaData = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class);
            if (eJBArchiveMetaData != null && (eJBMetaData = eJBArchiveMetaData.getBeanByEjbName(endpoint.getShortName())) instanceof MDBMetaData) {
                String string2 = ((MDBMetaData)eJBMetaData).getDestinationJndiName();
                stringBuilder.append(",jms=" + string2);
            }
            endpoint.setName(ObjectNameFactory.create((String)stringBuilder.toString()));
        }
    }
}

