/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;

public class EndpointLifecycleDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment deployment) {
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            this.getLifecycleHandler(endpoint, true).create(endpoint);
        }
    }

    public void start(Deployment deployment) {
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            this.getLifecycleHandler(endpoint, true).start(endpoint);
        }
    }

    public void stop(Deployment deployment) {
        Service service = deployment.getService();
        if (service != null) {
            for (Endpoint endpoint : service.getEndpoints()) {
                LifecycleHandler lifecycleHandler = this.getLifecycleHandler(endpoint, false);
                if (lifecycleHandler == null) continue;
                lifecycleHandler.stop(endpoint);
            }
        }
    }

    public void destroy(Deployment deployment) {
        Service service = deployment.getService();
        if (service != null) {
            for (Endpoint endpoint : service.getEndpoints()) {
                LifecycleHandler lifecycleHandler = this.getLifecycleHandler(endpoint, false);
                if (lifecycleHandler == null) continue;
                lifecycleHandler.destroy(endpoint);
            }
        }
    }

    private LifecycleHandler getLifecycleHandler(Endpoint endpoint, boolean bl) {
        LifecycleHandler lifecycleHandler = endpoint.getLifecycleHandler();
        if (lifecycleHandler == null && bl) {
            throw new IllegalStateException("LifecycleHandler not initialised");
        }
        return lifecycleHandler;
    }
}

