/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.LifecycleHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationHandler;
import org.jboss.wsf.spi.invocation.InvocationHandlerFactory;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.RequestHandler;
import org.jboss.wsf.spi.invocation.RequestHandlerFactory;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;

public class EndpointHandlerDeploymentAspect
extends DeploymentAspect {
    private SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();

    public void create(Deployment deployment) {
        for (Endpoint endpoint : deployment.getService().getEndpoints()) {
            endpoint.setRequestHandler(this.getRequestHandler(deployment));
            endpoint.setLifecycleHandler(this.getLifecycleHandler(deployment));
            InvocationHandler invocationHandler = this.getInvocationHandler(endpoint);
            if (invocationHandler == null) continue;
            endpoint.setInvocationHandler(invocationHandler);
        }
    }

    private RequestHandler getRequestHandler(Deployment deployment) {
        return ((RequestHandlerFactory)this.spiProvider.getSPI(RequestHandlerFactory.class)).newRequestHandler();
    }

    private LifecycleHandler getLifecycleHandler(Deployment deployment) {
        return ((LifecycleHandlerFactory)this.spiProvider.getSPI(LifecycleHandlerFactory.class)).newLifecylceHandler();
    }

    private InvocationHandler getInvocationHandler(Endpoint endpoint) {
        InvocationType invocationType;
        Deployment deployment = endpoint.getService().getDeployment();
        String string = deployment.getType().toString();
        EJBArchiveMetaData eJBArchiveMetaData = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class);
        if (eJBArchiveMetaData != null && (invocationType = eJBArchiveMetaData.getBeanByEjbName(endpoint.getShortName())) instanceof MDBMetaData) {
            string = "JAXRPC_MDB21";
        }
        invocationType = InvocationType.valueOf((String)string);
        InvocationHandler invocationHandler = ((InvocationHandlerFactory)this.spiProvider.getSPI(InvocationHandlerFactory.class)).newInvocationHandler(invocationType);
        return invocationHandler;
    }
}

