/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentAspectManagerImpl
implements DeploymentAspectManager {
    private static final Logger log = Logger.getLogger(DeploymentAspectManagerImpl.class);
    private String name;
    private DeploymentAspectManager parent;
    private List<DeploymentAspect> sortedAspects = new ArrayList<DeploymentAspect>();
    private long deploymentCount;

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DeploymentAspectManager getParent() {
        return this.parent;
    }

    public void setParent(DeploymentAspectManager deploymentAspectManager) {
        this.parent = deploymentAspectManager;
    }

    public List<DeploymentAspect> getDeploymentAspects() {
        return Collections.unmodifiableList(this.sortedAspects);
    }

    public void setDeploymentAspects(List<DeploymentAspect> list) {
        if (this.deploymentCount > 0L) {
            throw new IllegalStateException("Cannot add deployment aspects");
        }
        this.sortedAspects.clear();
        this.sortedAspects.addAll(list);
    }

    public void deploy(Deployment deployment) {
        DeploymentAspect deploymentAspect;
        int n;
        HashSet hashSet = new HashSet();
        for (n = 0; n < this.getDeploymentAspects().size(); ++n) {
            deploymentAspect = this.getDeploymentAspects().get(n);
            this.logInvocation(deploymentAspect, "Create");
            deploymentAspect.create(deployment);
            hashSet.addAll(deploymentAspect.getProvidesAsSet());
        }
        deployment.setState(Deployment.DeploymentState.CREATED);
        for (n = 0; n < this.getDeploymentAspects().size(); ++n) {
            deploymentAspect = this.getDeploymentAspects().get(n);
            try {
                this.logInvocation(deploymentAspect, "Start");
                deploymentAspect.start(deployment);
                continue;
            }
            catch (RuntimeException runtimeException) {
                while (n-- >= 0) {
                    this.failsafeDestroy(deploymentAspect, deployment);
                }
                throw runtimeException;
            }
        }
        deployment.setState(Deployment.DeploymentState.STARTED);
        ++this.deploymentCount;
    }

    public void undeploy(Deployment deployment) {
        DeploymentAspect deploymentAspect;
        int n;
        for (n = this.getDeploymentAspects().size(); 0 < n; --n) {
            deploymentAspect = this.getDeploymentAspects().get(n - 1);
            this.failsafeStop(deploymentAspect, deployment);
        }
        deployment.setState(Deployment.DeploymentState.STOPPED);
        for (n = this.getDeploymentAspects().size(); 0 < n; --n) {
            deploymentAspect = this.getDeploymentAspects().get(n - 1);
            this.failsafeDestroy(deploymentAspect, deployment);
        }
        deployment.setState(Deployment.DeploymentState.DESTROYED);
    }

    private void failsafeStop(DeploymentAspect deploymentAspect, Deployment deployment) {
        try {
            this.logInvocation(deploymentAspect, "Stop");
            deploymentAspect.stop(deployment);
        }
        catch (RuntimeException runtimeException) {
            WSFDeploymentException.rethrow((Throwable)runtimeException);
        }
    }

    private void failsafeDestroy(DeploymentAspect deploymentAspect, Deployment deployment) {
        try {
            this.logInvocation(deploymentAspect, "Destroy");
            deploymentAspect.destroy(deployment);
        }
        catch (RuntimeException runtimeException) {
            WSFDeploymentException.rethrow((Throwable)runtimeException);
        }
    }

    private void logInvocation(DeploymentAspect deploymentAspect, String string) {
        String string2 = deploymentAspect.getClass().getName();
        string2 = string2.substring(string2.lastIndexOf(".") + 1);
        log.debug((Object)(string2 + ":" + string));
    }
}

