/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;

public class ContextRootDeploymentAspect
extends DeploymentAspect {
    public void create(Deployment deployment) {
        String string = deployment.getService().getContextRoot();
        if (string == null) {
            string = this.getExplicitContextRoot(deployment);
            if (string == null) {
                string = this.getImplicitContextRoot((ArchiveDeployment)deployment);
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            deployment.getService().setContextRoot(string);
        }
    }

    protected String getExplicitContextRoot(Deployment deployment) {
        String string = null;
        JSEArchiveMetaData jSEArchiveMetaData = (JSEArchiveMetaData)deployment.getAttachment(JSEArchiveMetaData.class);
        if (jSEArchiveMetaData != null) {
            string = jSEArchiveMetaData.getContextRoot();
        }
        if (string == null) {
            for (Endpoint endpoint : deployment.getService().getEndpoints()) {
                Class clazz = endpoint.getTargetBeanClass();
                WebContext webContext = clazz.getAnnotation(WebContext.class);
                if (webContext == null || webContext.contextRoot().length() <= 0) continue;
                if (string != null && !string.equals(webContext.contextRoot())) {
                    throw new IllegalStateException("Context root must be the same for all deployed endpoints");
                }
                string = webContext.contextRoot();
            }
        }
        EJBArchiveMetaData eJBArchiveMetaData = (EJBArchiveMetaData)deployment.getAttachment(EJBArchiveMetaData.class);
        if (string == null && eJBArchiveMetaData != null) {
            string = eJBArchiveMetaData.getWebServiceContextRoot();
        }
        return string;
    }

    protected String getImplicitContextRoot(ArchiveDeployment archiveDeployment) {
        String string = archiveDeployment.getSimpleName();
        String string2 = string.substring(0, string.length() - 4);
        if (archiveDeployment.getParent() != null) {
            string = archiveDeployment.getParent().getSimpleName();
            string2 = string.substring(0, string.length() - 4) + "-" + string2;
        }
        return string2;
    }
}

