/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.ClassIterator;
import xjavadoc.MethodIterator;
import xjavadoc.XClass;
import xjavadoc.XCollections;
import xjavadoc.XDoc;
import xjavadoc.XJavaDoc;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class RelationTagsHandler
extends EjbTagsHandler {
    protected static Map relationMap = new HashMap();
    protected static RelationHolder currentRelation;
    static /* synthetic */ Class class$xdoclet$modules$ejb$dd$RelationTagsHandler;
    static /* synthetic */ Class class$xdoclet$modules$ejb$XDocletModulesEjbMessages;

    public void ifLeftCascadeDelete(String template) throws XDocletException {
        if (currentRelation.isLeftCascadeDelete()) {
            this.generate(template);
        }
    }

    public void ifRightCascadeDelete(String template) throws XDocletException {
        if (currentRelation.isRightCascadeDelete()) {
            this.generate(template);
        }
    }

    public String leftEJBName() throws XDocletException {
        if (currentRelation.getLeft() != null) {
            return EjbTagsHandler.getEjbNameFor(currentRelation.getLeft());
        }
        String name = RelationTagsHandler.getTagValue((int)1, (XDoc)currentRelation.getRightMethod().getDoc(), (String)"ejb:relation", (String)"target-ejb", null, null, (boolean)true, (boolean)(currentRelation.isBidirectional() ^ true));
        return name;
    }

    public String rightEJBName() throws XDocletException {
        if (currentRelation.getRight() != null) {
            return EjbTagsHandler.getEjbNameFor(currentRelation.getRight());
        }
        String name = RelationTagsHandler.getTagValue((int)1, (XDoc)currentRelation.getLeftMethod().getDoc(), (String)"ejb:relation", (String)"target-ejb", null, null, (boolean)true, (boolean)(currentRelation.isBidirectional() ^ true));
        return name;
    }

    public void ifHasRelationships(String template) throws XDocletException {
        Collection classes = XJavaDoc.getInstance().getSourceClasses();
        boolean hasRelationships = false;
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz = i.next();
            RelationTagsHandler.setCurrentClass((XClass)clazz);
            Collection methods = clazz.getMethods();
            MethodIterator j = XCollections.methodIterator((Collection)methods);
            while (j.hasNext()) {
                XMethod method = j.next();
                RelationTagsHandler.setCurrentMethod((XMethod)method);
                XTag relation = method.getDoc().getTag("ejb:relation");
                if (relation == null) continue;
                hasRelationships = true;
                break;
            }
            if (hasRelationships) break;
        }
        if (hasRelationships) {
            this.generate(template);
        }
    }

    public String relationName() throws XDocletException {
        return currentRelation.getName();
    }

    public void forAllRelationships(String template) throws XDocletException {
        Class clazz = class$xdoclet$modules$ejb$dd$RelationTagsHandler;
        if (clazz == null) {
            clazz = class$xdoclet$modules$ejb$dd$RelationTagsHandler = RelationTagsHandler.class$("[Lxdoclet.modules.ejb.dd.RelationTagsHandler;", false);
        }
        Log log = LogUtil.getLog((Class)clazz, (String)"forAllRelationships");
        Collection classes = XJavaDoc.getInstance().getSourceClasses();
        relationMap.clear();
        ClassIterator i = XCollections.classIterator((Collection)classes);
        while (i.hasNext()) {
            XClass clazz2 = i.next();
            RelationTagsHandler.setCurrentClass((XClass)clazz2);
            Collection methods = clazz2.getMethods();
            MethodIterator j = XCollections.methodIterator((Collection)methods);
            while (j.hasNext()) {
                XMethod method = j.next();
                RelationTagsHandler.setCurrentMethod((XMethod)method);
                XTag relationTag = method.getDoc().getTag("ejb:relation");
                if (relationTag == null) continue;
                String relationName = relationTag.getAttributeValue("name");
                if (relationName == null) {
                    Class clazz3 = class$xdoclet$modules$ejb$XDocletModulesEjbMessages;
                    if (clazz3 == null) {
                        clazz3 = class$xdoclet$modules$ejb$XDocletModulesEjbMessages = RelationTagsHandler.class$("[Lxdoclet.modules.ejb.XDocletModulesEjbMessages;", false);
                    }
                    throw new XDocletException(Translator.getString((Class)clazz3, (String)"RELATION_MUST_HAVE_NAME", (String[])new String[]{RelationTagsHandler.getCurrentClass().getName()}));
                }
                RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
                if (relationHolder != null && relationHolder.getLeft() != null && relationHolder.getRight() != null) {
                    String leftSignature = relationHolder.getLeftMethod().getContainingClass().getQualifiedName() + '.' + relationHolder.getLeftMethod();
                    String rightSignature = relationHolder.getRightMethod().getContainingClass().getQualifiedName() + '.' + relationHolder.getRightMethod();
                    String currentSignature = method.getContainingClass().getQualifiedName() + '.' + method;
                    Class clazz4 = class$xdoclet$modules$ejb$XDocletModulesEjbMessages;
                    if (clazz4 == null) {
                        clazz4 = class$xdoclet$modules$ejb$XDocletModulesEjbMessages = RelationTagsHandler.class$("[Lxdoclet.modules.ejb.XDocletModulesEjbMessages;", false);
                    }
                    throw new XDocletException(Translator.getString((Class)clazz4, (String)"RELATION_TOO_MANY_NAMES", (String[])new String[]{relationName, leftSignature, rightSignature, currentSignature}));
                }
                if (relationHolder == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Created new relationship for " + clazz2 + '.' + method));
                    }
                    relationHolder = new RelationHolder();
                    relationHolder.left = clazz2;
                    relationHolder.leftMethod = method;
                    relationMap.put(relationName, relationHolder);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added " + clazz2 + " to relationship: " + relationHolder));
                }
                relationHolder.right = clazz2;
                relationHolder.rightMethod = method;
            }
        }
        Iterator relations = relationMap.entrySet().iterator();
        while (relations.hasNext()) {
            Map.Entry entry = relations.next();
            RelationHolder relationHolder = (RelationHolder)entry.getValue();
            if (relationHolder.isLeftMany() && !relationHolder.isRightMany()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Swapping left -> right in attempt to make 1-n be 1-n (rather than n-1)");
                }
                relationHolder.swap();
            }
            if (relationHolder.isBidirectional() || !relationHolder.isOne2Many() || relationHolder.getLeftMethod() != null) continue;
            relationHolder.swap();
        }
        Iterator relationNameIterator = relationMap.keySet().iterator();
        while (relationNameIterator.hasNext()) {
            String relationName = (String)relationNameIterator.next();
            RelationHolder relationHolder = (RelationHolder)relationMap.get(relationName);
            RelationTagsHandler.setCurrentClass((XClass)relationHolder.getLeft());
            RelationTagsHandler.setCurrentMethod((XMethod)relationHolder.getLeftMethod());
            currentRelation = relationHolder;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generating template for Relation: " + currentRelation));
            }
            this.generate(template);
        }
    }

    public void ifIsLeftMany(String template) throws XDocletException {
        if (currentRelation.isLeftMany()) {
            this.generate(template);
        }
    }

    public void ifIsRightMany(String template) throws XDocletException {
        if (currentRelation.isRightMany()) {
            this.generate(template);
        }
    }

    public String leftFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor((XMethod)currentRelation.getLeftMethod());
    }

    public String rightFieldName() throws XDocletException {
        return MethodTagsHandler.getPropertyNameFor((XMethod)currentRelation.getRightMethod());
    }

    public String leftFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor((XMethod)currentRelation.getLeftMethod());
    }

    public String rightFieldType() throws XDocletException {
        return MethodTagsHandler.getMethodTypeFor((XMethod)currentRelation.getRightMethod());
    }

    public void ifIsNotACollection(String template) throws XDocletException {
        if (!this.isSetOrCollection(MethodTagsHandler.getMethodTypeFor((XMethod)RelationTagsHandler.getCurrentMethod()))) {
            this.generate(template);
        }
    }

    public String relationComment() {
        return "<!-- " + currentRelation.toString() + " -->";
    }

    public void ifIsOne2One(String template) throws XDocletException {
        if (currentRelation.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2One(String template) throws XDocletException {
        if (!currentRelation.isOne2One()) {
            this.generate(template);
        }
    }

    public void ifIsOne2Many(String template) throws XDocletException {
        if (currentRelation.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsOne2Many(String template) throws XDocletException {
        if (!currentRelation.isOne2Many()) {
            this.generate(template);
        }
    }

    public void ifIsMany2Many(String template) throws XDocletException {
        if (currentRelation.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifNotIsMany2Many(String template) throws XDocletException {
        if (!currentRelation.isMany2Many()) {
            this.generate(template);
        }
    }

    public void ifIsBidirectional(String template) throws XDocletException {
        if (currentRelation.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifIsUnidirectional(String template) throws XDocletException {
        if (!currentRelation.isBidirectional()) {
            this.generate(template);
        }
    }

    public void ifHasLeftRoleName(String template) throws XDocletException {
        if (this.leftRoleName() != null) {
            this.generate(template);
        }
    }

    public void ifHasRightRoleName(String template) throws XDocletException {
        if (this.rightRoleName() != null) {
            this.generate(template);
        }
    }

    public void ifLeftNavigable(String template) throws XDocletException {
        if (currentRelation.isLeftNavigable()) {
            this.generate(template);
        }
    }

    public void ifRightNavigable(String template) throws XDocletException {
        if (currentRelation.isRightNavigable()) {
            this.generate(template);
        }
    }

    public String leftRoleName() throws XDocletException {
        return currentRelation.getLeftRoleName();
    }

    public String rightRoleName() throws XDocletException {
        return currentRelation.getRightRoleName();
    }

    public String leftMultiplicity() throws XDocletException {
        return currentRelation.getLeftMultiplicity();
    }

    public String rightMultiplicity() throws XDocletException {
        return currentRelation.getRightMultiplicity();
    }

    protected boolean isSetOrCollection(String type) {
        boolean bl = false;
        if (type.equals("java.util.Collection") || type.equals("java.util.Set")) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RelationHolder {
        private static final String ONE = "One";
        private static final String MANY = "Many";
        private XClass left;
        private XMethod leftMethod;
        private XClass right;
        private XMethod rightMethod;

        public boolean isBidirectional() {
            boolean bl = false;
            if (this.getRightMethod() != null && this.getLeftMethod() != null) {
                bl = true;
            }
            return bl;
        }

        public boolean isOne2One() throws XDocletException {
            boolean bl = false;
            if (!this.isLeftMany() && !this.isRightMany()) {
                bl = true;
            }
            return bl;
        }

        public boolean isOne2Many() throws XDocletException {
            boolean bl = false;
            if (!this.isLeftMany() && this.isRightMany()) {
                bl = true;
            }
            return bl;
        }

        public boolean isMany2Many() throws XDocletException {
            boolean bl = false;
            if (this.isLeftMany() && this.isRightMany()) {
                bl = true;
            }
            return bl;
        }

        public String getLeftMultiplicity() throws XDocletException {
            return this.isLeftMany() ? MANY : ONE;
        }

        public String getRightMultiplicity() throws XDocletException {
            return this.isRightMany() ? MANY : ONE;
        }

        public XClass getLeft() {
            return this.left;
        }

        public XMethod getLeftMethod() {
            return this.leftMethod;
        }

        public XClass getRight() {
            return this.right;
        }

        public XMethod getRightMethod() {
            return this.rightMethod;
        }

        public boolean isRightNavigable() {
            boolean bl = false;
            if (this.getRightMethod() != null) {
                bl = true;
            }
            return bl;
        }

        public boolean isLeftNavigable() {
            boolean bl = false;
            if (this.getLeftMethod() != null) {
                bl = true;
            }
            return bl;
        }

        public String getLeftRoleName() throws XDocletException {
            String result = null;
            result = this.getLeftMethod() != null ? this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "role-name", false) : this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "target-role-name", false);
            return result;
        }

        public String getRightRoleName() throws XDocletException {
            String result = null;
            result = this.getRightMethod() != null ? this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "role-name", false) : this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "target-role-name", false);
            return result;
        }

        public boolean isLeftMany() throws XDocletException {
            boolean result;
            if (this.getLeftMethod() != null) {
                result = RelationTagsHandler.this.isSetOrCollection(this.getLeftMethod().getReturnType().getQualifiedName());
            } else {
                String targetMultiple = this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "target-multiple", false);
                result = TypeConversionUtil.stringToBoolean((String)targetMultiple, (boolean)false);
            }
            return result;
        }

        public boolean isRightMany() throws XDocletException {
            boolean result;
            if (this.getRightMethod() != null) {
                result = RelationTagsHandler.this.isSetOrCollection(this.getRightMethod().getReturnType().getQualifiedName());
            } else {
                String targetMultiple = this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "target-multiple", false);
                result = TypeConversionUtil.stringToBoolean((String)targetMultiple, (boolean)false);
            }
            return result;
        }

        public boolean isLeftCascadeDelete() throws XDocletException {
            boolean result = this.getLeftMethod() != null ? this.isCascadeDelete(this.getLeftMethod(), "cascade-delete") : this.isCascadeDelete(this.getRightMethod(), "target-cascade-delete");
            return result;
        }

        public boolean isRightCascadeDelete() throws XDocletException {
            boolean result = this.getRightMethod() != null ? this.isCascadeDelete(this.getRightMethod(), "cascade-delete") : this.isCascadeDelete(this.getLeftMethod(), "target-cascade-delete");
            return result;
        }

        public String getName() throws XDocletException {
            String result = null;
            result = this.getRightMethod() != null ? this.getRightMethod().getDoc().getTagAttributeValue("ejb:relation", "name", false) : this.getLeftMethod().getDoc().getTagAttributeValue("ejb:relation", "name", false);
            return result;
        }

        public void swap() {
            XClass c = this.right;
            XMethod m = this.rightMethod;
            this.right = this.left;
            this.rightMethod = this.leftMethod;
            this.left = c;
            this.leftMethod = m;
        }

        public int hashCode() {
            int result = 17;
            if (this.getLeft() != null) {
                result = 37 * result + this.getLeft().hashCode();
            }
            if (this.getLeftMethod() != null) {
                result = 37 * result + this.getLeftMethod().hashCode();
            }
            if (this.getRight() != null) {
                result = 37 * result + this.getRight().hashCode();
            }
            if (this.getRightMethod() != null) {
                result = 37 * result + this.getRightMethod().hashCode();
            }
            return result;
        }

        public String toString() {
            return "RelationHolder left=" + this.getLeft() + '.' + this.getLeftMethod() + " right=" + this.getRight() + '.' + this.getRightMethod();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationHolder)) {
                return false;
            }
            RelationHolder other = this;
            boolean bl = false;
            if ((this.getLeft() == null ? other.getLeft() == null : this.getLeft().equals(other.getLeft())) && (this.getLeftMethod() == null ? other.getLeftMethod() == null : this.getLeftMethod().equals(other.getLeftMethod())) && (this.getRight() == null ? other.getRight() == null : this.getRight().equals(other.getRight())) && (this.getRightMethod() == null ? other.getRightMethod() == null : this.getRightMethod().equals(other.getRightMethod()))) {
                bl = true;
            }
            return bl;
        }

        private final boolean isCascadeDelete(XMethod method, String tag) throws XDocletException {
            String cd = null;
            cd = RelationTagsHandler.getTagValue((int)1, (XDoc)method.getDoc(), (String)"ejb:relation", (String)tag, (String)"yes,no,true,false", (String)"no", (boolean)false, (boolean)false);
            return TypeConversionUtil.stringToBoolean((String)cd, (boolean)false);
        }

        static /* synthetic */ XClass access$0(RelationHolder relationHolder) {
            return relationHolder.left;
        }

        static /* synthetic */ XMethod access$2(RelationHolder relationHolder) {
            return relationHolder.leftMethod;
        }

        static /* synthetic */ XClass access$4(RelationHolder relationHolder) {
            return relationHolder.right;
        }

        static /* synthetic */ XMethod access$6(RelationHolder relationHolder) {
            return relationHolder.rightMethod;
        }
    }
}

