/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.classloading.plugins.PackageInfo;
import org.jboss.classloading.plugins.WrappingClassLoader;
import org.jboss.logging.Logger;

public class ClassLoading {
    private static final Logger log = Logger.getLogger((Class)ClassLoading.class);
    private static final Map primitives = new HashMap();
    private static Set systemPackages;

    public static Class loadClass(ClassLoader cl, String name) throws Exception {
        return ClassLoading.loadClass(false, null, cl, name);
    }

    public static Class loadClass(boolean trace, String ctx, ClassLoader cl, String name) throws Exception {
        if (trace) {
            log.trace((Object)("Loading " + ctx + " class=" + name + " classloader=" + cl));
        }
        Class<?> clazz = (Class<?>)primitives.get(name);
        try {
            if (clazz == null) {
                clazz = cl.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            clazz = Class.forName(name);
        }
        if (trace) {
            log.trace((Object)("Loaded " + ctx + " " + clazz + " classloader=" + clazz.getClassLoader()));
        }
        return clazz;
    }

    public static Set getClassLoaderSpecificPackages(ClassLoader cl) {
        Set packages = ClassLoading.getClassLoaderPackages(cl);
        packages.removeAll(ClassLoading.getSystemPackages());
        return packages;
    }

    public static Set getSystemPackages() {
        if (systemPackages == null) {
            systemPackages = ClassLoading.getClassLoaderPackages(ClassLoader.getSystemClassLoader());
        }
        return systemPackages;
    }

    public static Set getClassLoaderPackages(ClassLoader cl) {
        PackageInfo info = cl instanceof PackageInfo ? (PackageInfo)((Object)cl) : new WrappingClassLoader(cl);
        Package[] pkgs = info.getPackages();
        HashSet<String> packages = new HashSet<String>();
        for (int i = 0; i < pkgs.length; ++i) {
            packages.add(pkgs[i].getName());
        }
        return packages;
    }

    public static String getPackageName(String className) {
        int dot = className.lastIndexOf(47);
        if (dot != -1) {
            return className.substring(0, dot);
        }
        return "";
    }

    static {
        primitives.put("byte", Byte.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
    }
}

