/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;

public class Task {
    private String description;
    private TimePeriod duration;
    private Double percentComplete;
    private List subtasks;

    public Task(String description, TimePeriod duration) {
        this.description = description;
        this.duration = duration;
        this.percentComplete = null;
        this.subtasks = new ArrayList();
    }

    public Task(String description, Date start, Date end) {
        this(description, new SimpleTimePeriod(start, end));
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TimePeriod getDuration() {
        return this.duration;
    }

    public void setDuration(TimePeriod duration) {
        this.duration = duration;
    }

    public Double getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(double percent) {
        this.setPercentComplete(new Double(percent));
    }

    public void setPercentComplete(Double percent) {
        this.percentComplete = percent;
    }

    public void addSubtask(Task subtask) {
        this.subtasks.add(subtask);
    }

    public void removeSubtask(Task subtask) {
        this.subtasks.remove(subtask);
    }

    public int getSubtaskCount() {
        return this.subtasks.size();
    }

    public Task getSubtask(int index) {
        return (Task)this.subtasks.get(index);
    }
}

