/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.XYDataItem;
import org.jfree.data.XYDataPair;
import org.jfree.util.ObjectUtils;

public class XYSeries
extends Series
implements Cloneable,
Serializable {
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;

    public XYSeries(String name) {
        this(name, true, true);
    }

    public XYSeries(String name, boolean autoSort, boolean allowDuplicateXValues) {
        super(name);
        this.data = new ArrayList();
        this.autoSort = autoSort;
        this.allowDuplicateXValues = allowDuplicateXValues;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int maximum) {
        this.maximumItemCount = maximum;
    }

    public void add(XYDataItem item) {
        this.add(item, true);
    }

    public void add(XYDataItem item, boolean notify) {
        if (item == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        int index = Collections.binarySearch(this.data, item);
        if (index < 0) {
            if (this.autoSort) {
                this.data.add(-index - 1, item);
            } else {
                this.data.add(item);
            }
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else if (this.allowDuplicateXValues) {
            if (this.autoSort) {
                this.data.add(index, item);
            } else {
                this.data.add(item);
            }
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        } else {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
        if (notify) {
            this.fireSeriesChanged();
        }
    }

    public void add(double x, double y) {
        this.add(new Double(x), (Number)new Double(y), true);
    }

    public void add(double x, double y, boolean notify) {
        this.add(new Double(x), (Number)new Double(y), notify);
    }

    public void add(double x, Number y) {
        this.add(new Double(x), y);
    }

    public void add(double x, Number y, boolean notify) {
        this.add(new Double(x), y, notify);
    }

    public void add(Number x, Number y) {
        this.add(x, y, true);
    }

    public void add(Number x, Number y, boolean notify) {
        if (x == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        XYDataItem item = new XYDataItem(x, y);
        this.add(item, notify);
    }

    public void delete(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.data.remove(start);
        }
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int index) {
        return (XYDataItem)this.data.remove(index);
    }

    public XYDataItem remove(Number x) {
        return this.remove(this.indexOf(x));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int index) {
        return (XYDataItem)this.data.get(index);
    }

    public Number getXValue(int index) {
        return this.getDataItem(index).getX();
    }

    public Number getYValue(int index) {
        return this.getDataItem(index).getY();
    }

    public void update(int index, Number y) {
        XYDataItem item = this.getDataItem(index);
        item.setY(y);
        this.fireSeriesChanged();
    }

    public int indexOf(Number x) {
        return Collections.binarySearch(this.data, new XYDataItem(x, null));
    }

    public Object clone() throws CloneNotSupportedException {
        XYSeries clone = this.createCopy(0, this.getItemCount() - 1);
        return clone;
    }

    public XYSeries createCopy(int start, int end) throws CloneNotSupportedException {
        XYSeries copy = (XYSeries)super.clone();
        copy.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int index = start; index <= end; ++index) {
                XYDataItem item = (XYDataItem)this.data.get(index);
                XYDataItem clone = (XYDataItem)item.clone();
                try {
                    copy.add(clone);
                    continue;
                }
                catch (SeriesException e) {
                    System.err.println("XYSeries.createCopy(): unable to add cloned data pair.");
                }
            }
        }
        return copy;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof XYSeries)) {
            return false;
        }
        XYSeries s = (XYSeries)object;
        if (this.maximumItemCount != s.maximumItemCount) {
            return false;
        }
        if (this.autoSort != s.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != s.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtils.equal((Object)this.data, (Object)s.data);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.data != null ? ((Object)this.data).hashCode() : 0);
        result = 29 * result + this.maximumItemCount;
        result = 29 * result + (this.autoSort ? 1 : 0);
        result = 29 * result + (this.allowDuplicateXValues ? 1 : 0);
        return result;
    }

    public XYSeries(String name, boolean allowDuplicateXValues) {
        this(name, true, allowDuplicateXValues);
    }

    public XYDataPair getDataPair(int index) {
        return (XYDataPair)this.data.get(index);
    }
}

