/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.ant.util.graph.Edge;
import org.jboss.ant.util.graph.Graph;
import org.jboss.ant.util.graph.Vertex;
import org.jboss.ant.util.graph.Visitor;

public class GraphTestCase
extends TestCase {
    Vertex a = new Vertex("A");
    Vertex b = new Vertex("B");
    Vertex c = new Vertex("C");
    Vertex d = new Vertex("D");
    Vertex e = new Vertex("E");
    Vertex f = new Vertex("F");
    Vertex g = new Vertex("G");
    Vertex h = new Vertex("H");
    Vertex i = new Vertex("I");

    public void testDFS() throws Exception {
        Graph graph = this.buildGraph1();
        final ArrayList order = new ArrayList();
        Visitor visitor = new Visitor(){

            public void visit(Graph g, Vertex v) {
                System.out.println("visit " + v.getName());
                order.add(v);
            }

            public void visit(Graph g, Vertex v, Edge e) {
            }
        };
        graph.depthFirstSearch(this.a, visitor);
        Assert.assertTrue((String)("Visted count == 8(" + order.size() + ")"), (order.size() == 8 ? 1 : 0) != 0);
        int n = 0;
        while (n < order.size()) {
            Vertex v = (Vertex)order.get(n);
            System.out.println(v);
            Assert.assertTrue((String)(String.valueOf(v.getName()) + " is visited"), (boolean)v.visited());
            ++n;
        }
        String[] names = new String[]{"A", "B", "C", "H", "G", "I", "E", "F"};
        int n2 = 0;
        while (n2 < order.size()) {
            Vertex v = (Vertex)order.get(n2);
            Assert.assertTrue((String)("#" + n2 + " is " + names[n2] + "(" + v.getName() + ")"), (boolean)v.getName().equals(names[n2]));
            ++n2;
        }
    }

    public void testBFS() throws Exception {
        Graph graph = this.buildGraph1();
        final ArrayList order = new ArrayList();
        Visitor visitor = new Visitor(){

            public void visit(Graph g, Vertex v) {
                System.out.println("visit " + v.getName());
                order.add(v);
            }

            public void visit(Graph g, Vertex v, Edge e) {
            }
        };
        graph.breadthFirstSearch(this.a, visitor);
        Assert.assertTrue((String)("Visted count == 8(" + order.size() + ")"), (order.size() == 8 ? 1 : 0) != 0);
        int n = 0;
        while (n < order.size()) {
            Vertex v = (Vertex)order.get(n);
            System.out.println(v);
            Assert.assertTrue((String)(String.valueOf(v.getName()) + " is visited"), (boolean)v.visited());
            ++n;
        }
        String[] names = new String[]{"A", "B", "F", "C", "G", "E", "I", "H"};
        int n2 = 0;
        while (n2 < order.size()) {
            Vertex v = (Vertex)order.get(n2);
            Assert.assertTrue((String)("#" + n2 + " is " + names[n2] + "(" + v.getName() + ")"), (boolean)v.getName().equals(names[n2]));
            ++n2;
        }
    }

    public void testCycleDection() {
        Graph g = new Graph();
        Vertex v0 = new Vertex("V0");
        Vertex v1 = new Vertex("V1");
        Vertex v2 = new Vertex("V2");
        g.addVertex(v0);
        g.addVertex(v1);
        g.addVertex(v2);
        g.addEdge(v0, v1, 0);
        g.addEdge(v1, v2, 0);
        g.addEdge(v2, v0, 0);
        Edge[] cycleEdges = g.findCycles();
        Assert.assertTrue((String)"There is a cycle", (cycleEdges.length == 1 ? 1 : 0) != 0);
        int n = 0;
        while (n < cycleEdges.length) {
            System.out.println(cycleEdges[n]);
            ++n;
        }
        Edge e = cycleEdges[0];
        Vertex vx = e.getFrom();
        Vertex vy = e.getTo();
        Assert.assertTrue((String)"Cycle edge is V2->V0", (vx.getName().equals("V2") && vy.getName().equals("V0") ? 1 : 0) != 0);
    }

    private Graph buildGraph1() {
        Graph graph = new Graph();
        Assert.assertTrue((String)"Added A", (boolean)graph.addVertex(this.a));
        Assert.assertTrue((String)"Added B", (boolean)graph.addVertex(this.b));
        Assert.assertTrue((String)"Added C", (boolean)graph.addVertex(this.c));
        Assert.assertTrue((String)"Added D", (boolean)graph.addVertex(this.d));
        Assert.assertTrue((String)"Added E", (boolean)graph.addVertex(this.e));
        Assert.assertTrue((String)"Added F", (boolean)graph.addVertex(this.f));
        Assert.assertTrue((String)"Added G", (boolean)graph.addVertex(this.g));
        Assert.assertTrue((String)"Added H", (boolean)graph.addVertex(this.h));
        Assert.assertTrue((String)"Added I", (boolean)graph.addVertex(this.i));
        Assert.assertTrue((String)"Added A -> B", (boolean)graph.addEdge(this.a, this.b, 0));
        Assert.assertTrue((String)"Added A -> F", (boolean)graph.addEdge(this.a, this.f, 0));
        Assert.assertTrue((String)"Added B -> C", (boolean)graph.addEdge(this.b, this.c, 0));
        Assert.assertTrue((String)"Added B -> G", (boolean)graph.addEdge(this.b, this.g, 0));
        Assert.assertTrue((String)"Added C -> H", (boolean)graph.addEdge(this.c, this.h, 0));
        Assert.assertTrue((String)"Added D -> E", (boolean)graph.addEdge(this.d, this.e, 0));
        Assert.assertTrue((String)"Added D -> H", (boolean)graph.addEdge(this.d, this.h, 0));
        Assert.assertTrue((String)"Added F -> E", (boolean)graph.addEdge(this.f, this.e, 0));
        Assert.assertTrue((String)"Added F -> I", (boolean)graph.addEdge(this.f, this.i, 0));
        Assert.assertTrue((String)"Added G -> A", (boolean)graph.addEdge(this.g, this.a, 0));
        Assert.assertTrue((String)"Added H -> G", (boolean)graph.addEdge(this.h, this.g, 0));
        Assert.assertTrue((String)"Added H -> I", (boolean)graph.addEdge(this.h, this.i, 0));
        Assert.assertTrue((String)"Added I -> E", (boolean)graph.addEdge(this.i, this.e, 0));
        Assert.assertTrue((String)"Added I -> G", (boolean)graph.addEdge(this.i, this.g, 0));
        Assert.assertTrue((String)"Graph has 9 verticies", (graph.size() == 9 ? 1 : 0) != 0);
        return graph;
    }
}

