/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.parser;

import java.io.IOException;
import org.apache.batik.parser.DefaultTransformListHandler;
import org.apache.batik.parser.NumberParser;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.TransformListHandler;

public class TransformListParser
extends NumberParser {
    protected TransformListHandler transformListHandler = DefaultTransformListHandler.INSTANCE;

    public void setTransformListHandler(TransformListHandler handler) {
        this.transformListHandler = handler;
    }

    public TransformListHandler getTransformListHandler() {
        return this.transformListHandler;
    }

    protected void doParse() throws ParseException, IOException {
        this.transformListHandler.startTransformList();
        block14: while (true) {
            try {
                this.current = this.reader.read();
                block1 : switch (this.current) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: 
                    case 44: {
                        break;
                    }
                    case 109: {
                        this.parseMatrix();
                        break;
                    }
                    case 114: {
                        this.parseRotate();
                        break;
                    }
                    case 116: {
                        this.parseTranslate();
                        break;
                    }
                    case 115: {
                        this.current = this.reader.read();
                        switch (this.current) {
                            case 99: {
                                this.parseScale();
                                break block1;
                            }
                            case 107: {
                                this.parseSkew();
                                break block1;
                            }
                        }
                        this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                        this.skipTransform();
                        break;
                    }
                    case -1: {
                        break block14;
                    }
                    default: {
                        this.reportError("character.unexpected", new Object[]{new Integer(this.current)});
                        this.skipTransform();
                        break;
                    }
                }
            }
            catch (ParseException e) {
                this.errorHandler.error(e);
                this.skipTransform();
            }
        }
        this.skipSpaces();
        if (this.current != -1) {
            this.reportError("end.of.stream.expected", new Object[]{new Integer(this.current)});
        }
        this.transformListHandler.endTransformList();
    }

    protected void parseMatrix() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 114) {
            this.reportError("character.expected", new Object[]{new Character('r'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 105) {
            this.reportError("character.expected", new Object[]{new Character('i'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 120) {
            this.reportError("character.expected", new Object[]{new Character('x'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float a = this.parseFloat();
        this.skipCommaSpaces();
        float b = this.parseFloat();
        this.skipCommaSpaces();
        float c = this.parseFloat();
        this.skipCommaSpaces();
        float d = this.parseFloat();
        this.skipCommaSpaces();
        float e = this.parseFloat();
        this.skipCommaSpaces();
        float f = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.transformListHandler.matrix(a, b, c, d, e, f);
    }

    protected void parseRotate() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 111) {
            this.reportError("character.expected", new Object[]{new Character('o'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float theta = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.rotate(theta);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float cx = this.parseFloat();
        this.skipCommaSpaces();
        float cy = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.transformListHandler.rotate(theta, cx, cy);
    }

    protected void parseTranslate() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 114) {
            this.reportError("character.expected", new Object[]{new Character('r'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 110) {
            this.reportError("character.expected", new Object[]{new Character('n'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 115) {
            this.reportError("character.expected", new Object[]{new Character('s'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 108) {
            this.reportError("character.expected", new Object[]{new Character('l'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportError("character.expected", new Object[]{new Character('t'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float tx = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.translate(tx);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float ty = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.transformListHandler.translate(tx, ty);
    }

    protected void parseScale() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportError("character.expected", new Object[]{new Character('a'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 108) {
            this.reportError("character.expected", new Object[]{new Character('l'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float sx = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.scale(sx);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float sy = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.transformListHandler.scale(sx, sy);
    }

    protected void parseSkew() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportError("character.expected", new Object[]{new Character('e'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 119) {
            this.reportError("character.expected", new Object[]{new Character('w'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        boolean skewX = false;
        switch (this.current) {
            case 88: {
                skewX = true;
            }
            case 89: {
                break;
            }
            default: {
                this.reportError("character.expected", new Object[]{new Character('X'), new Integer(this.current)});
                this.skipTransform();
                return;
            }
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportError("character.expected", new Object[]{new Character('('), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float sk = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportError("character.expected", new Object[]{new Character(')'), new Integer(this.current)});
            this.skipTransform();
            return;
        }
        if (skewX) {
            this.transformListHandler.skewX(sk);
        } else {
            this.transformListHandler.skewY(sk);
        }
    }

    protected void skipTransform() throws IOException {
        block3: while (true) {
            this.current = this.reader.read();
            switch (this.current) {
                case 41: {
                    break block3;
                }
                default: {
                    if (this.current != -1) continue block3;
                    break block3;
                }
            }
            break;
        }
    }
}

