/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.BasicDeclarationPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.PrinterHelper;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class MethodDeclarationPrinter
extends BasicDeclarationPrinter {
    private static final Printer INSTANCE = new MethodDeclarationPrinter();

    protected MethodDeclarationPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        JavaNode n = (JavaNode)node;
        this.addCommentIfNeeded(n, out);
        super.print(node, out);
        AST modifiers = node.getFirstChild();
        if (this.isPartOfInterface(n)) {
            PrinterHelper.removeAbstractModifier(modifiers);
        }
        PrinterFactory.create(modifiers).print(modifiers, out);
        AST type = modifiers.getNextSibling();
        PrinterFactory.create(type).print(type, out);
        out.print(" ", 153);
        AST identifier = type.getNextSibling();
        PrinterFactory.create(identifier).print(identifier, out);
        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_METHOD_DEF_PAREN, false)) {
            out.print(" ", 153);
        }
        Marker marker = out.state.markers.add(out.line, out.column);
        AST lparen = identifier.getNextSibling();
        PrinterFactory.create(lparen).print(lparen, out);
        AST parameters = lparen.getNextSibling();
        PrinterFactory.create(parameters).print(parameters, out);
        AST rparen = parameters.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        AST child = rparen.getNextSibling();
        while (child != null) {
            switch (child.getType()) {
                case 11: 
                case 55: {
                    out.state.markers.remove(marker);
                }
            }
            PrinterFactory.create(child).print(child, out);
            child = child.getNextSibling();
        }
        out.state.newlineBeforeLeftBrace = false;
        out.state.parametersWrapped = false;
        out.last = 13;
    }

    private boolean isPartOfInterface(JavaNode node) {
        return node.getParent().getParent().getType() == 19;
    }
}

