/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ForPrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new ForPrinter();

    protected ForPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = 1;
        offset = settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true) ? out.print("for ", 94) : out.print("for", 94);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        Marker marker = out.state.markers.add();
        AST forInit = lparen.getNextSibling();
        AST firstSemi = forInit.getNextSibling();
        AST forCond = firstSemi.getNextSibling();
        AST secondSemi = forCond.getNextSibling();
        AST forIter = secondSemi.getNextSibling();
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        boolean firstWrap = false;
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                AST child;
                TestNodeWriter tester = out.testers.get();
                AST c = child = forInit.getFirstChild();
                while (c != null) {
                    PrinterFactory.create(c).print(c, tester);
                    c = c.getNextSibling();
                }
                child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                }
                if ((child = forIter.getFirstChild()) != null) {
                    PrinterFactory.create(child).print(child, tester);
                }
                if (out.column + tester.length > lineLength) {
                    firstWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForInit(forInit, firstWrap, out);
        boolean wrapAll = settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean spaceAfterSemi = settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true);
        out.continuation = settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        boolean secondWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                secondWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 3 : 2);
                }
                if (out.column + tester.length > lineLength) {
                    secondWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForCond(forCond, secondWrap, out);
        boolean thirdWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                thirdWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forIter.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 5 : 3);
                }
                if (out.column + tester.length > lineLength) {
                    thirdWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForIter(forIter, thirdWrap, out);
        out.continuation = false;
        if ((firstWrap || secondWrap || thirdWrap) && settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
            if (!out.newline) {
                out.printNewline();
                if (indentDeep) {
                    out.print(out.getString(marker.column - 1 - out.getIndentLength()), 153);
                }
            }
            out.print(AbstractPrinter.EMPTY_STRING, 153);
        }
        AST rparen = forIter.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        out.state.markers.remove(marker);
        if (out.mode == 1) {
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.last = 94;
        AST body = rparen.getNextSibling();
        switch (body.getType()) {
            case 11: {
                PrinterFactory.create(body).print(body, out);
                break;
            }
            default: {
                if (settings.getBoolean(ConventionKeys.BRACE_INSERT_FOR, false)) {
                    out.printLeftBrace(settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    PrinterFactory.create(body).print(body, out);
                    out.printRightBrace();
                    break;
                }
                out.printNewline();
                out.indent();
                PrinterFactory.create(body).print(body, out);
                out.unindent();
            }
        }
        out.last = 8;
    }

    private void printForCond(AST node, boolean wrap, NodeWriter out) throws IOException {
        out.print(";", 39);
        if (node.getFirstChild() == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 39);
        }
        AST child = node.getFirstChild();
        while (child != null) {
            PrinterFactory.create(child).print(child, out);
            child = child.getNextSibling();
        }
    }

    private void printForInit(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST child;
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        }
        if ((child = node.getFirstChild()) != null) {
            this.printVariableDefs(node, out);
        }
    }

    private void printForIter(AST node, boolean wrap, NodeWriter out) throws IOException {
        out.print(";", 39);
        AST elist = node.getFirstChild();
        if (elist == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 39);
        }
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        AST element = elist.getFirstChild();
        while (element != null) {
            switch (element.getType()) {
                case 82: {
                    out.print(comma, 82);
                    break;
                }
                default: {
                    PrinterFactory.create(element).print(element, out);
                }
            }
            element = element.getNextSibling();
        }
    }

    private void printVariableDef(AST node, NodeWriter out, boolean printType) throws IOException {
        switch (node.getType()) {
            case 38: {
                boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
                String comma = spaceAfterComma ? ", " : ",";
                AST param = node.getFirstChild();
                while (param != null) {
                    PrinterFactory.create(param).print(param, out);
                    if (param.getNextSibling() != null) {
                        out.print(comma, 82);
                    }
                    param = param.getNextSibling();
                }
                return;
            }
        }
        AST mod = node.getFirstChild();
        AST type = mod.getNextSibling();
        if (printType) {
            PrinterFactory.create(type).print(type, out);
        }
        AST ident = type.getNextSibling();
        if (out.last != 82) {
            out.print(" ", out.last);
        }
        PrinterFactory.create(ident).print(ident, out);
        AST assign = ident.getNextSibling();
        if (assign != null) {
            switch (assign.getType()) {
                case 55: {
                    break;
                }
                default: {
                    PrinterFactory.create(assign).print(assign, out);
                }
            }
        }
    }

    private void printVariableDefs(AST node, NodeWriter out) throws IOException {
        AST child = node.getFirstChild();
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        switch (child.getType()) {
            case 14: {
                this.printVariableDef(child, out, true);
                child = child.getNextSibling();
                while (child != null) {
                    out.print(comma, 82);
                    this.printVariableDef(child, out, false);
                    child = child.getNextSibling();
                }
                break;
            }
            case 38: {
                AST var = child.getFirstChild();
                while (var != null) {
                    switch (child.getType()) {
                        case 82: {
                            out.print(comma, 82);
                            break;
                        }
                        default: {
                            PrinterFactory.create(var).print(var, out);
                        }
                    }
                    var = var.getNextSibling();
                }
                break;
            }
        }
    }
}

