/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.jms.TopicConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.remoting.messaging.JMSConnectionProvider;
import org.jboss.seam.remoting.messaging.RemoteSubscriber;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.remoting.messaging.subscriptionRegistry")
public class SubscriptionRegistry {
    private static final String DEFAULT_CONNECTION_PROVIDER = "org.jboss.seam.remoting.messaging.JBossConnectionProvider";
    private static final Log log = LogFactory.getLog(SubscriptionRegistry.class);
    private String connectionProvider;
    private volatile TopicConnection topicConnection;
    private Object monitor = new Object();
    private Map<String, RemoteSubscriber> subscriptions = new HashMap<String, RemoteSubscriber>();

    public static SubscriptionRegistry instance() {
        SubscriptionRegistry registry = (SubscriptionRegistry)Component.getInstance(SubscriptionRegistry.class, true);
        if (registry == null) {
            throw new IllegalStateException("No SubscriptionRegistry exists");
        }
        return registry;
    }

    public void setConnectionProvider(String connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicConnection getTopicConnection() throws Exception {
        if (this.topicConnection == null) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.topicConnection == null) {
                    String providerName = this.connectionProvider != null ? this.connectionProvider : DEFAULT_CONNECTION_PROVIDER;
                    try {
                        Class<?> providerClass = Class.forName(providerName);
                        JMSConnectionProvider provider = (JMSConnectionProvider)providerClass.newInstance();
                        this.topicConnection = provider.createConnection();
                        this.topicConnection.start();
                    }
                    catch (ClassNotFoundException ex) {
                        log.error((Object)String.format("Topic connection provider class [%s] not found", providerName));
                        throw ex;
                    }
                    catch (InstantiationException ex) {
                        log.error((Object)String.format("Failed to create connection provider [%s]", providerName));
                        throw ex;
                    }
                }
            }
        }
        return this.topicConnection;
    }

    public RemoteSubscriber subscribe(String topicName) {
        RemoteSubscriber sub = new RemoteSubscriber(UUID.randomUUID().toString(), topicName);
        try {
            sub.subscribe(this.getTopicConnection());
            this.subscriptions.put(sub.getToken(), sub);
            return sub;
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public RemoteSubscriber getSubscription(String token) {
        return this.subscriptions.get(token);
    }
}

