/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.event.PhaseId;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.WebRemote;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.remoting.BaseRequestHandler;
import org.jboss.seam.remoting.RequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceGenerator
extends BaseRequestHandler
implements RequestHandler {
    private static final Log log = LogFactory.getLog(InterfaceGenerator.class);
    private static Map<Class, List<Field>> accessibleFields = new HashMap<Class, List<Field>>();
    private Map<String, byte[]> interfaceCache = new HashMap<String, byte[]>();
    private ServletContext servletContext;

    @Override
    public void setServletContext(ServletContext ctx) {
        this.servletContext = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession(true);
            Lifecycle.setPhaseId(PhaseId.INVOKE_APPLICATION);
            Lifecycle.setServletRequest((ServletRequest)request);
            Lifecycle.beginRequest(this.servletContext, session);
            String[] componentNames = request.getQueryString().split("&");
            Component[] components = new Component[componentNames.length];
            for (int i = 0; i < componentNames.length; ++i) {
                components[i] = Component.forName(componentNames[i]);
                if (components[i] != null) continue;
                log.error((Object)String.format("Component not found: [%s]", componentNames[i]));
                throw new ServletException("Invalid request - component not found.");
            }
            this.generateComponentInterface(components, (OutputStream)response.getOutputStream());
        }
        finally {
            Lifecycle.setServletRequest(null);
            Lifecycle.setPhaseId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateComponentInterface(Component[] components, OutputStream out) throws IOException {
        HashSet<Type> types = new HashSet<Type>();
        for (Component c : components) {
            if (!this.interfaceCache.containsKey(c.getName())) {
                Map<String, byte[]> map = this.interfaceCache;
                synchronized (map) {
                    if (!this.interfaceCache.containsKey(c.getName())) {
                        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                        this.appendComponentSource(bOut, c, types);
                        this.interfaceCache.put(c.getName(), bOut.toByteArray());
                    }
                }
            }
            out.write(this.interfaceCache.get(c.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getAccessibleFields(Class cls) {
        if (cls.getName().contains("EnhancerByCGLIB")) {
            cls = cls.getSuperclass();
        }
        if (!accessibleFields.containsKey(cls)) {
            Map<Class, List<Field>> map = accessibleFields;
            synchronized (map) {
                if (!accessibleFields.containsKey(cls)) {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (Field f : cls.getDeclaredFields()) {
                        if (Modifier.isTransient(f.getModifiers()) || Modifier.isStatic(f.getModifiers())) continue;
                        String fieldName = f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
                        String getterName = String.format("get%s", fieldName);
                        String setterName = String.format("set%s", fieldName);
                        Method getMethod = null;
                        Method setMethod = null;
                        try {
                            getMethod = cls.getMethod(getterName, new Class[0]);
                        }
                        catch (SecurityException ex) {
                        }
                        catch (NoSuchMethodException ex) {
                            getterName = String.format("is%s", fieldName);
                            try {
                                getMethod = cls.getMethod(getterName, new Class[0]);
                            }
                            catch (NoSuchMethodException ex2) {
                                // empty catch block
                            }
                        }
                        try {
                            setMethod = cls.getMethod(setterName, f.getType());
                        }
                        catch (SecurityException ex) {
                        }
                        catch (NoSuchMethodException ex) {
                            // empty catch block
                        }
                        if (!Modifier.isPublic(f.getModifiers()) && (getMethod == null || !Modifier.isPublic(getMethod.getModifiers())) && (setMethod == null || !Modifier.isPublic(setMethod.getModifiers()))) continue;
                        fields.add(f);
                    }
                    accessibleFields.put(cls, fields);
                }
            }
        }
        return accessibleFields.get(cls);
    }

    private void appendComponentSource(OutputStream out, Component component, Set<Type> types) throws IOException {
        StringBuilder componentSrc = new StringBuilder();
        Class<?> type = null;
        if ((component.getType().equals((Object)ComponentType.STATEFUL_SESSION_BEAN) || component.getType().equals((Object)ComponentType.STATELESS_SESSION_BEAN)) && component.getLocalInterfaces().size() > 0) {
            type = component.getLocalInterfaces().iterator().next();
        } else {
            if (component.getType().equals((Object)ComponentType.ENTITY_BEAN)) {
                this.appendTypeSource(out, component.getBeanClass(), types);
                return;
            }
            if (component.getType().equals((Object)ComponentType.JAVA_BEAN)) {
                for (Method m : component.getBeanClass().getDeclaredMethods()) {
                    if (m.getAnnotation(WebRemote.class) == null) continue;
                    type = component.getBeanClass();
                    break;
                }
                if (type == null) {
                    this.appendTypeSource(out, component.getBeanClass(), types);
                    return;
                }
            } else {
                type = component.getBeanClass();
            }
        }
        if (types.contains(type)) {
            return;
        }
        types.add(type);
        componentSrc.append("Seam.Remoting.type.");
        componentSrc.append(component.getName());
        componentSrc.append(" = function() {\n");
        componentSrc.append("  this.__callback = new Object();\n");
        for (Method m : type.getDeclaredMethods()) {
            int i;
            if (m.getAnnotation(WebRemote.class) == null) continue;
            this.appendTypeSource(out, m.getGenericReturnType(), types);
            componentSrc.append("  Seam.Remoting.type.");
            componentSrc.append(component.getName());
            componentSrc.append(".prototype.");
            componentSrc.append(m.getName());
            componentSrc.append(" = function(");
            for (i = 0; i < m.getGenericParameterTypes().length; ++i) {
                this.appendTypeSource(out, m.getGenericParameterTypes()[i], types);
                if (i > 0) {
                    componentSrc.append(", ");
                }
                componentSrc.append("p");
                componentSrc.append(i);
            }
            if (m.getGenericParameterTypes().length > 0) {
                componentSrc.append(", ");
            }
            componentSrc.append("callback) {\n");
            componentSrc.append("    Seam.Remoting.execute(this, \"");
            componentSrc.append(m.getName());
            componentSrc.append("\", [");
            for (i = 0; i < m.getParameterTypes().length; ++i) {
                if (i > 0) {
                    componentSrc.append(", ");
                }
                componentSrc.append("p");
                componentSrc.append(i);
            }
            componentSrc.append("], callback);\n");
            componentSrc.append("  }\n");
        }
        componentSrc.append("}\n");
        componentSrc.append("Seam.Remoting.type.");
        componentSrc.append(component.getName());
        componentSrc.append(".__name = \"");
        componentSrc.append(component.getName());
        componentSrc.append("\";\n\n");
        componentSrc.append("Seam.Component.register(Seam.Remoting.type.");
        componentSrc.append(component.getName());
        componentSrc.append(");\n\n");
        out.write(componentSrc.toString().getBytes());
    }

    private void appendTypeSource(OutputStream out, Type type, Set<Type> types) throws IOException {
        if (type instanceof Class) {
            Class classType = (Class)type;
            if (classType.isArray()) {
                this.appendTypeSource(out, classType.getComponentType(), types);
                return;
            }
            if (classType.getName().startsWith("java.") || types.contains(type) || classType.isPrimitive()) {
                return;
            }
            types.add(type);
            this.appendClassSource(out, classType, types);
        } else if (type instanceof ParameterizedType) {
            for (Type t : ((ParameterizedType)type).getActualTypeArguments()) {
                this.appendTypeSource(out, t, types);
            }
        }
    }

    private void appendClassSource(OutputStream out, Class classType, Set<Type> types) throws IOException {
        if (classType.isEnum()) {
            return;
        }
        StringBuilder typeSource = new StringBuilder();
        String componentName = Seam.getComponentName(classType);
        if (componentName == null) {
            componentName = classType.getName();
        }
        String typeName = componentName.replace('.', '$');
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(" = function() {\n");
        StringBuilder fields = new StringBuilder();
        StringBuilder accessors = new StringBuilder();
        StringBuilder mutators = new StringBuilder();
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Field f : InterfaceGenerator.getAccessibleFields(classType)) {
            this.appendTypeSource(out, f.getType(), types);
            if (f.getGenericType() instanceof ParameterizedType) {
                for (Type t : ((ParameterizedType)f.getGenericType()).getActualTypeArguments()) {
                    if (!(t instanceof Class)) continue;
                    this.appendTypeSource(out, (Class)t, types);
                }
            }
            String fieldName = f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
            String getterName = String.format("get%s", fieldName);
            String setterName = String.format("set%s", fieldName);
            Method getMethod = null;
            Method setMethod = null;
            try {
                getMethod = classType.getMethod(getterName, new Class[0]);
            }
            catch (SecurityException ex) {
            }
            catch (NoSuchMethodException ex) {
                getterName = String.format("is%s", fieldName);
                try {
                    getMethod = classType.getMethod(getterName, new Class[0]);
                }
                catch (NoSuchMethodException ex2) {
                    // empty catch block
                }
            }
            try {
                setMethod = classType.getMethod(setterName, f.getType());
            }
            catch (SecurityException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (!Modifier.isPublic(f.getModifiers()) && (getMethod == null || !Modifier.isPublic(getMethod.getModifiers())) && (setMethod == null || !Modifier.isPublic(setMethod.getModifiers()))) continue;
            metadata.put(f.getName(), this.getFieldType(f.getType()));
            fields.append("  this.");
            fields.append(f.getName());
            fields.append(" = null;\n");
            if (getMethod != null) {
                accessors.append("  Seam.Remoting.type.");
                accessors.append(typeName);
                accessors.append(".prototype.");
                accessors.append(getMethod.getName());
                accessors.append(" = function() { return this.");
                accessors.append(f.getName());
                accessors.append("; }\n");
            }
            if (setMethod == null) continue;
            mutators.append("  Seam.Remoting.type.");
            mutators.append(typeName);
            mutators.append(".prototype.");
            mutators.append(setMethod.getName());
            mutators.append(" = function(");
            mutators.append(f.getName());
            mutators.append(") { this.");
            mutators.append(f.getName());
            mutators.append(" = ");
            mutators.append(f.getName());
            mutators.append("; }\n");
        }
        typeSource.append((CharSequence)fields);
        typeSource.append((CharSequence)accessors);
        typeSource.append((CharSequence)mutators);
        typeSource.append("}\n\n");
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(".__name = \"");
        typeSource.append(componentName);
        typeSource.append("\";\n");
        typeSource.append("Seam.Remoting.type.");
        typeSource.append(typeName);
        typeSource.append(".__metadata = [\n");
        for (String key : metadata.keySet()) {
            typeSource.append("  {field: \"");
            typeSource.append(key);
            typeSource.append("\", type: \"");
            typeSource.append((String)metadata.get(key));
            typeSource.append("\"},\n");
        }
        typeSource.append("];\n\n");
        if (classType.isAnnotationPresent(Name.class)) {
            typeSource.append("Seam.Component.register(Seam.Remoting.type.");
        } else {
            typeSource.append("Seam.Remoting.registerType(Seam.Remoting.type.");
        }
        typeSource.append(typeName);
        typeSource.append(");\n\n");
        out.write(typeSource.toString().getBytes());
    }

    private String getFieldType(Class type) {
        if (type.equals(String.class) || type.isEnum()) {
            return "str";
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return "number";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "date";
        }
        if (Map.class.isAssignableFrom(type)) {
            return "map";
        }
        if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            return "bag";
        }
        return "bean";
    }
}

