/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ejb;

import java.io.Serializable;
import javax.ejb.AroundInvoke;
import javax.ejb.InvocationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.interceptors.SeamInvocationContext;

public class SeamInterceptor
implements Serializable {
    private static final Log log = LogFactory.getLog(SeamInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        if (!this.getUnproxiedClass(invocation.getBean()).isAnnotationPresent(Name.class)) {
            return invocation.proceed();
        }
        if (Contexts.isEventContextActive() || Contexts.isApplicationContextActive()) {
            return this.aroundInvokeInContexts(invocation);
        }
        Lifecycle.beginCall();
        try {
            Object object = this.aroundInvokeInContexts(invocation);
            return object;
        }
        finally {
            Lifecycle.endCall();
        }
    }

    public Object aroundInvokeInContexts(InvocationContext invocation) throws Exception {
        Component component = this.getSeamComponent(invocation.getBean());
        if (this.isProcessInterceptors(component)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("intercepted: " + invocation.getMethod().getName()));
            }
            return new SeamInvocationContext(invocation, component).proceed();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("not intercepted: " + invocation.getMethod().getName()));
        }
        return invocation.proceed();
    }

    private boolean isProcessInterceptors(Component component) {
        return component != null && component.getInterceptionType().isActive();
    }

    private Component getSeamComponent(Object bean) {
        String componentName = Seam.getComponentName(this.getUnproxiedClass(bean));
        return Component.forName(componentName);
    }

    private Class getUnproxiedClass(Object bean) {
        Class<?> clazz = bean.getClass();
        if (clazz.getName().contains("CGLIB")) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }
}

