/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Manager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.PAGE)
@Name(value="switcher")
@Intercept(value=InterceptionType.NEVER)
public class Switcher
implements Serializable {
    private List<SelectItem> selectItems;
    private String conversationIdOrOutcome;
    private String resultingConversationIdOrOutcome;

    @Create
    public void createSelectItems() {
        Map<String, ConversationEntry> map = Manager.instance().getConversationIdEntryMap();
        TreeSet<ConversationEntry> orderedEntries = new TreeSet<ConversationEntry>();
        orderedEntries.addAll(map.values());
        this.selectItems = new ArrayList<SelectItem>(map.size());
        for (ConversationEntry entry : orderedEntries) {
            if (!entry.isDisplayable() || Seam.isSessionInvalid()) continue;
            this.selectItems.add(new SelectItem((Object)entry.getId(), entry.getDescription()));
        }
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    private String getLongRunningConversationId() {
        if (Manager.instance().isLongRunningConversation()) {
            return Manager.instance().getCurrentConversationId();
        }
        LinkedList<String> stack = Manager.instance().getCurrentConversationIdStack();
        return stack.size() == 1 ? null : (String)stack.get(1);
    }

    public String getConversationIdOrOutcome() {
        return this.resultingConversationIdOrOutcome == null ? this.getLongRunningConversationId() : this.resultingConversationIdOrOutcome;
    }

    public void setConversationIdOrOutcome(String selectedId) {
        this.conversationIdOrOutcome = selectedId;
    }

    public String select() {
        String actualOutcome;
        boolean isOutcome;
        Manager manager = Manager.instance();
        boolean bl = isOutcome = this.conversationIdOrOutcome == null || !Character.isDigit(this.conversationIdOrOutcome.charAt(0));
        if (isOutcome) {
            manager.initializeTemporaryConversation();
            this.resultingConversationIdOrOutcome = this.conversationIdOrOutcome;
            actualOutcome = this.conversationIdOrOutcome;
        } else {
            boolean success = manager.swapConversation(this.conversationIdOrOutcome);
            if (success) {
                this.resultingConversationIdOrOutcome = manager.getCurrentConversationId();
                Manager.instance().redirect(manager.getCurrentConversationViewId());
                actualOutcome = "org.jboss.seam.switch";
            } else {
                actualOutcome = null;
            }
        }
        Lifecycle.resumeConversation(FacesContext.getCurrentInstance().getExternalContext());
        return actualOutcome;
    }
}

