/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.Template;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.pages")
public class Pages {
    private static final Log log = LogFactory.getLog(Pages.class);
    private Map<String, String> descriptionByViewId = new HashMap<String, String>();
    private Map<String, Integer> timeoutsByViewId = new HashMap<String, Integer>();
    private Map<String, MethodBinding> actionsByViewId = new HashMap<String, MethodBinding>();
    private Map<String, String> outcomesByViewId = new HashMap<String, String>();
    private SortedSet<String> wildcardViewIds = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String x, String y) {
            if (x.length() < y.length()) {
                return -1;
            }
            if (x.length() > y.length()) {
                return 1;
            }
            return x.compareTo(y);
        }
    });

    @Create
    public void initialize() throws DocumentException {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/pages.xml");
        if (stream == null) {
            log.info((Object)"no pages.xml file found");
        } else {
            log.info((Object)"reading pages.xml");
            SAXReader saxReader = new SAXReader();
            saxReader.setMergeAdjacentText(true);
            Document doc = saxReader.read(stream);
            List elements = doc.getRootElement().elements("page");
            for (Element page : elements) {
                String action;
                String timeoutString;
                String description;
                String viewId = page.attributeValue("view-id");
                if (viewId.endsWith("*")) {
                    this.wildcardViewIds.add(viewId);
                }
                if ((description = page.getTextTrim()) != null && description.length() > 0) {
                    this.descriptionByViewId.put(viewId, description);
                }
                if ((timeoutString = page.attributeValue("timeout")) != null) {
                    this.timeoutsByViewId.put(viewId, Integer.parseInt(timeoutString));
                }
                if ((action = page.attributeValue("action")) == null) continue;
                if (action.startsWith("#{")) {
                    MethodBinding methodBinding = FacesContext.getCurrentInstance().getApplication().createMethodBinding(action, null);
                    this.actionsByViewId.put(viewId, methodBinding);
                    continue;
                }
                this.outcomesByViewId.put(viewId, action);
            }
        }
    }

    public boolean hasDescription(String viewId) {
        return this.descriptionByViewId.containsKey(viewId);
    }

    public String getDescription(String viewId) {
        return Template.render(this.descriptionByViewId.get(viewId));
    }

    public Integer getTimeout(String viewId) {
        return this.timeoutsByViewId.get(viewId);
    }

    public boolean callAction() {
        boolean result = false;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        if (viewId != null) {
            for (String wildcard : this.wildcardViewIds) {
                if (!viewId.startsWith(wildcard.substring(0, wildcard.length() - 1))) continue;
                result = this.callAction(facesContext, wildcard) || result;
            }
        }
        result = this.callAction(facesContext, viewId) || result;
        return result;
    }

    private boolean callAction(FacesContext facesContext, String viewId) {
        MethodBinding methodBinding;
        String outcome;
        boolean result = false;
        String fromAction = outcome = this.outcomesByViewId.get(viewId);
        if (outcome == null && (methodBinding = this.actionsByViewId.get(viewId)) != null) {
            fromAction = methodBinding.getExpressionString();
            result = true;
            outcome = (String)methodBinding.invoke(facesContext, null);
        }
        if (outcome != null) {
            facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, fromAction, outcome);
        }
        return result;
    }

    public static Pages instance() {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No active application context");
        }
        return (Pages)Component.getInstance(Pages.class, ScopeType.APPLICATION, true);
    }
}

