/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.ejb3.embedded.EJB3StandaloneBootstrap;
import org.jboss.ejb3.embedded.EJB3StandaloneDeployer;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup
@Name(value="org.jboss.seam.core.ejb")
public class Ejb {
    private static final Log log = LogFactory.getLog(Ejb.class);
    private EJB3StandaloneDeployer deployer;

    @Create
    public void startup() throws Exception {
        log.info((Object)"starting the embedded EJB container");
        EJB3StandaloneBootstrap.boot(null);
        this.deploy("META-INF/jboss-beans.xml");
        this.deploy("jboss-beans.xml");
        this.deployer = EJB3StandaloneBootstrap.createDeployer();
        this.deployer.getArchivesByResource().add("seam.properties");
        this.deployer.setJndiProperties(Naming.getInitialContextProperties());
        this.deployer.create();
        this.deployer.start();
    }

    private void deploy(String name) {
        if (Thread.currentThread().getContextClassLoader().getResource(name) != null) {
            EJB3StandaloneBootstrap.deployXmlResource((String)name);
        }
    }

    @Destroy
    public void shutdown() throws Exception {
        log.info((Object)"stopping the embedded EJB container");
        this.deployer.stop();
        this.deployer.destroy();
        this.deployer = null;
        EJB3StandaloneBootstrap.shutdown();
    }
}

