/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.util.Naming;

public class StatelessContext
implements Context {
    public ScopeType getType() {
        return ScopeType.STATELESS;
    }

    public Object get(String name) {
        try {
            return Naming.getInitialContext().lookup(name);
        }
        catch (NamingException ne) {
            return null;
        }
    }

    public void set(String name, Object value) {
        try {
            InitialContext initialContext = Naming.getInitialContext();
            initialContext.bind(name, value);
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("could not bind: " + name, ne);
        }
    }

    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    public void remove(String name) {
        try {
            Naming.getInitialContext().unbind(name);
        }
        catch (NamingException ne) {
            throw new IllegalArgumentException("could not unbind: " + name, ne);
        }
    }

    public String[] getNames() {
        throw new UnsupportedOperationException();
    }

    public Object get(Class clazz) {
        return this.get(Seam.getComponentName(clazz));
    }

    public void flush() {
    }
}

