/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import com.sun.media.jai.codec.FileCacheSeekableStream;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import java.net.URL;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.pdf.PDFColor;

public class JAIImage
extends AbstractFopImage {
    public JAIImage(URL href) throws FopImageException {
        super(href);
    }

    public JAIImage(URL href, ImageReader imgReader) throws FopImageException {
        super(href, imgReader);
    }

    protected void loadImage() throws FopImageException {
        try {
            InputStream inputStream = this.m_href.openStream();
            FileCacheSeekableStream seekableInput = new FileCacheSeekableStream(inputStream);
            RenderedOp imageOp = JAI.create((String)"stream", (Object)seekableInput);
            this.m_height = imageOp.getHeight();
            this.m_width = imageOp.getWidth();
            ColorModel cm = imageOp.getColorModel();
            this.m_bitsPerPixel = 8;
            this.m_colorSpace = new ColorSpace(2);
            BufferedImage imageData = imageOp.getAsBufferedImage();
            int[] tmpMap = imageData.getRGB(0, 0, this.m_width, this.m_height, null, 0, this.m_width);
            if (cm.hasAlpha()) {
                int transparencyType = cm.getTransparency();
                if (transparencyType == 1) {
                    this.m_isTransparent = false;
                } else if (transparencyType == 2) {
                    if (cm instanceof IndexColorModel) {
                        this.m_isTransparent = false;
                        byte[] alphas = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] reds = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] greens = new byte[((IndexColorModel)cm).getMapSize()];
                        byte[] blues = new byte[((IndexColorModel)cm).getMapSize()];
                        ((IndexColorModel)cm).getAlphas(alphas);
                        ((IndexColorModel)cm).getReds(reds);
                        ((IndexColorModel)cm).getGreens(greens);
                        ((IndexColorModel)cm).getBlues(blues);
                        for (int i = 0; i < ((IndexColorModel)cm).getMapSize(); ++i) {
                            if ((alphas[i] & 0xFF) != 0) continue;
                            this.m_isTransparent = true;
                            this.m_transparentColor = new PDFColor(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                            break;
                        }
                    } else {
                        this.m_isTransparent = false;
                    }
                } else {
                    this.m_isTransparent = false;
                }
            } else {
                this.m_isTransparent = false;
            }
            this.m_bitmapsSize = this.m_width * this.m_height * 3;
            this.m_bitmaps = new byte[this.m_bitmapsSize];
            for (int i = 0; i < this.m_height; ++i) {
                for (int j = 0; j < this.m_width; ++j) {
                    int p = tmpMap[i * this.m_width + j];
                    int r = p >> 16 & 0xFF;
                    int g = p >> 8 & 0xFF;
                    int b = p & 0xFF;
                    this.m_bitmaps[3 * (i * this.m_width + j)] = (byte)(r & 0xFF);
                    this.m_bitmaps[3 * (i * this.m_width + j) + 1] = (byte)(g & 0xFF);
                    this.m_bitmaps[3 * (i * this.m_width + j) + 2] = (byte)(b & 0xFF);
                }
            }
        }
        catch (Exception ex) {
            throw new FopImageException("Error while loading image " + this.m_href.toString() + " : " + ex.getClass() + " - " + ex.getMessage());
        }
    }
}

