/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.pagination.LayoutMasterSet;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fo.pagination.SubSequenceSpecifier;

public class PageSequenceMaster
extends FObj {
    private LayoutMasterSet layoutMasterSet;
    private ArrayList subSequenceSpecifiers;
    private SubSequenceSpecifier currentSubSequence;
    private int currentSubSequenceNumber;
    private String masterName;

    public static FObj.Maker maker() {
        return new Maker();
    }

    protected PageSequenceMaster(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (parent.getName().equals("fo:layout-master-set")) {
            this.layoutMasterSet = (LayoutMasterSet)parent;
            this.masterName = this.properties.get("master-name").getString();
            if (this.masterName == null) {
                this.log.warn("page-sequence-master does not have a page-master-name and so is being ignored");
            } else {
                this.layoutMasterSet.addPageSequenceMaster(this.masterName, this);
            }
        } else {
            throw new FOPException("fo:page-sequence-master must be child of fo:layout-master-set, not " + parent.getName(), systemId, line, column);
        }
        this.subSequenceSpecifiers = new ArrayList();
        this.currentSubSequenceNumber = -1;
        this.currentSubSequence = null;
    }

    protected void addSubsequenceSpecifier(SubSequenceSpecifier pageMasterReference) {
        this.subSequenceSpecifiers.add(pageMasterReference);
    }

    protected SubSequenceSpecifier getNextSubSequence() {
        ++this.currentSubSequenceNumber;
        if (this.currentSubSequenceNumber >= 0 && this.currentSubSequenceNumber < this.subSequenceSpecifiers.size()) {
            return (SubSequenceSpecifier)this.subSequenceSpecifiers.get(this.currentSubSequenceNumber);
        }
        return null;
    }

    public void reset() {
        this.currentSubSequenceNumber = -1;
        this.currentSubSequence = null;
        for (int i = 0; i < this.subSequenceSpecifiers.size(); ++i) {
            ((SubSequenceSpecifier)this.subSequenceSpecifiers.get(i)).reset();
        }
    }

    public SimplePageMaster getNextSimplePageMaster(boolean oddPage, boolean blankPage) throws FOPException {
        boolean firstPage = false;
        if (this.currentSubSequence == null) {
            this.currentSubSequence = this.getNextSubSequence();
            if (this.currentSubSequence == null) {
                throw new FOPException("no subsequences in page-sequence-master '" + this.masterName + "'", this.systemId, this.line, this.column);
            }
            firstPage = true;
        }
        String pageMasterName = this.currentSubSequence.getNextPageMasterName(oddPage, firstPage, blankPage);
        boolean canRecover = true;
        while (pageMasterName == null) {
            SubSequenceSpecifier nextSubSequence = this.getNextSubSequence();
            firstPage = true;
            if (nextSubSequence == null) {
                if (!canRecover) {
                    throw new FOPException("subsequences exhausted in page-sequence-master '" + this.masterName + "', cannot recover", this.systemId, this.line, this.column);
                }
                this.log.warn("subsequences exhausted in page-sequence-master '" + this.masterName + "', use previous subsequence");
                this.currentSubSequence.reset();
                canRecover = false;
            } else {
                this.currentSubSequence = nextSubSequence;
            }
            pageMasterName = this.currentSubSequence.getNextPageMasterName(oddPage, firstPage, blankPage);
        }
        SimplePageMaster pageMaster = this.layoutMasterSet.getSimplePageMaster(pageMasterName);
        if (pageMaster == null) {
            throw new FOPException("No simple-page-master matching '" + pageMasterName + "' in page-sequence-master '" + this.masterName + "'", this.systemId, this.line, this.column);
        }
        return pageMaster;
    }

    public String getName() {
        return "fo:page-sequence-master";
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new PageSequenceMaster(parent, propertyList, systemId, line, column);
        }
    }
}

