/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.util.ArrayList;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.ColumnArea;

public abstract class AbstractFlow
extends FObj {
    protected PageSequence pageSequence;
    private Area area;
    private ArrayList markerSnapshot;
    protected String _flowName;
    private int contentWidth;
    private int _status = 2;

    protected AbstractFlow(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!parent.getName().equals("fo:page-sequence")) {
            throw new FOPException("flow must be child of page-sequence, not " + parent.getName(), systemId, line, column);
        }
        this.pageSequence = (PageSequence)parent;
    }

    public String getFlowName() {
        return this._flowName;
    }

    public int layout(Area area) throws FOPException {
        return this.layout(area, null);
    }

    public int layout(Area area, Region region) throws FOPException {
        if (this.marker == -1000) {
            this.marker = 0;
        }
        BodyAreaContainer bac = (BodyAreaContainer)area;
        boolean prevChildMustKeepWithNext = false;
        ArrayList pageMarker = this.getMarkerSnapshot(new ArrayList());
        int numChildren = this.children.size();
        if (numChildren == 0) {
            throw new FOPException("fo:flow must contain block-level children", this.systemId, this.line, this.column);
        }
        for (int i = this.marker; i < numChildren; ++i) {
            FObj fo = (FObj)this.children.get(i);
            if (bac.isBalancingRequired(fo)) {
                bac.resetSpanArea();
                this.rollback(this.markerSnapshot);
                i = this.marker - 1;
                continue;
            }
            AreaContainer currentArea = bac.getNextArea(fo);
            currentArea.setIDReferences(bac.getIDReferences());
            if (bac.isNewSpanArea()) {
                this.marker = i;
                this.markerSnapshot = this.getMarkerSnapshot(new ArrayList());
            }
            this.setContentWidth(currentArea.getContentWidth());
            this._status = fo.layout(currentArea);
            if (Status.isIncomplete(this._status)) {
                if (prevChildMustKeepWithNext && Status.laidOutNone(this._status)) {
                    this.marker = i - 1;
                    FObj prevChild = (FObj)this.children.get(this.marker);
                    prevChild.removeAreas();
                    prevChild.resetMarker();
                    prevChild.removeID(area.getIDReferences());
                    this._status = 3;
                    return this._status;
                }
                if (bac.isLastColumn()) {
                    if (this._status == 7) {
                        this.marker = i;
                        this._status = 4;
                        return this._status;
                    }
                    this.marker = i;
                    return this._status;
                }
                if (Status.isPageBreak(this._status)) {
                    this.marker = i;
                    return this._status;
                }
                ((ColumnArea)currentArea).incrementSpanIndex();
                --i;
            }
            prevChildMustKeepWithNext = this._status == 8;
        }
        return this._status;
    }

    protected void setContentWidth(int contentWidth) {
        this.contentWidth = contentWidth;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean generatesReferenceAreas() {
        return true;
    }
}

