/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import org.apache.avalon.framework.logger.Logger;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.LinkSet;

public abstract class FONode {
    protected FObj parent;
    protected String areaClass = "unassigned";
    protected ArrayList children = new ArrayList();
    public static final int START = -1000;
    public static final int BREAK_AFTER = -1001;
    protected int marker = -1000;
    protected boolean isInTableCell = false;
    protected int forcedStartOffset = 0;
    protected int forcedWidth = 0;
    protected LinkSet linkSet;
    public int areasGenerated = 0;
    protected Logger log;

    protected FONode(FObj parent) {
        this.parent = parent;
        if (parent != null) {
            this.areaClass = parent.areaClass;
            this.log = parent.log;
        }
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public void setIsInTableCell() {
        this.isInTableCell = true;
        for (int i = 0; i < this.children.size(); ++i) {
            FONode child = (FONode)this.children.get(i);
            child.setIsInTableCell();
        }
    }

    public void forceStartOffset(int offset) {
        this.forcedStartOffset = offset;
        for (int i = 0; i < this.children.size(); ++i) {
            FONode child = (FONode)this.children.get(i);
            child.forceStartOffset(offset);
        }
    }

    public void forceWidth(int width) {
        this.forcedWidth = width;
        for (int i = 0; i < this.children.size(); ++i) {
            FONode child = (FONode)this.children.get(i);
            child.forceWidth(width);
        }
    }

    public void resetMarker() {
        this.marker = -1000;
        this.areasGenerated = 0;
        int numChildren = this.children.size();
        for (int i = 0; i < numChildren; ++i) {
            ((FONode)this.children.get(i)).resetMarker();
        }
    }

    public void removeAreas() {
    }

    protected void addChild(FONode child) {
        this.children.add(child);
    }

    public FObj getParent() {
        return this.parent;
    }

    public void setLinkSet(LinkSet linkSet) {
        this.linkSet = linkSet;
        for (int i = 0; i < this.children.size(); ++i) {
            FONode child = (FONode)this.children.get(i);
            child.setLinkSet(linkSet);
        }
    }

    public LinkSet getLinkSet() {
        return this.linkSet;
    }

    public abstract int layout(Area var1) throws FOPException;

    public Property getProperty(String name) {
        return null;
    }

    public ArrayList getMarkerSnapshot(ArrayList snapshot) {
        snapshot.add(new Integer(this.marker));
        if (this.marker < 0) {
            return snapshot;
        }
        if (this.children.isEmpty()) {
            return snapshot;
        }
        return ((FONode)this.children.get(this.marker)).getMarkerSnapshot(snapshot);
    }

    public void rollback(ArrayList snapshot) {
        this.marker = (Integer)snapshot.get(0);
        snapshot.remove(0);
        if (this.marker == -1000) {
            this.resetMarker();
            return;
        }
        if (this.marker == -1 || this.children.isEmpty()) {
            return;
        }
        int numChildren = this.children.size();
        if (this.marker <= -1000) {
            return;
        }
        for (int i = this.marker + 1; i < numChildren; ++i) {
            FONode fo = (FONode)this.children.get(i);
            fo.resetMarker();
        }
        ((FONode)this.children.get(this.marker)).rollback(snapshot);
    }

    public boolean mayPrecedeMarker() {
        return false;
    }
}

